###################################################################################################################
# This R script creates figure 5 from Berner and Law (2015)
# Author: Logan Berner, OSU
# Date: Nov 4th, 2015
###################################################################################################################
rm(list=ls())
require(lattice)
require(reshape2)
require(plotrix)
setwd("")

plot.data <- read.csv('data/plot_summaries/plot_master_data.csv', header = T)
  
#--------------------------------------------------------------------------------------------
# Plot 
#--------------------------------------------------------------------------------------------
r.crit <- sqrt(qt(0.05/2,50)^2/(48+qt(0.05/2,50)^2)) # critical value for 2-sided t-test at 95% confidence interval
cors.rnd <- round(plot.data$rw.cmi.max.pos.cor.pcnt)
cors.rnd
my.xlab <- expression('Climate moisture index (PPT-ET'[0]*' ; mm yr'^-1*')')
my.col <- c('dodgerblue4','lightseagreen','darkorange2','goldenrod4')
legend.txt <-  rev(c('1-25%','26-50%','51-75%','76-100%'))
my.cols <- c(my.col[1],my.col[1],my.col[2],my.col[1],my.col[4],my.col[3],my.col[4],my.col[2],my.col[4],my.col[4],my.col[4],my.col[4])
  
  #pdf('figures/fig5_site_rw_cmi_cor_by_cmigy.pdf', 4,3)
jpeg('figures/fig5_site_rw_cmi_cor_by_cmigy.jpg', 4,3, units='in', res=600)
par.op <- par(mar=c(4,4.5,1,1), bg = "white")
plotCI(plot.data$cmi.gy.avg, plot.data$rw.cmi.cor.avg, uiw=plot.data$rw.cmi.cor.se, err='y', xaxt='n', yaxt='n',
       xlim=c(-1300,250), ylim=c(-0.05,0.7),xlab = '', ylab='',cex = 0.8, cex.axis = 0.95, pch=plot.data$sp.pch, scol='darkgrey')
plotCI(plot.data$cmi.gy.avg, plot.data$rw.cmi.cor.avg, uiw=plot.data$cmi.gy.se, err='x', add=T, xaxt='n', yaxt='n',
       xlim=c(-1300,250), ylim=c(-0.05,0.7),xlab = '', ylab='',cex = 0.8, cex.axis = 0.95, pch=plot.data$sp.pch, scol='darkgrey')
mtext(side = 2, line = 2.5, cex = 0.95, expression(bar(r)[RWI-CMI]))
mtext(side = 1, line=2.5, cex=1, my.xlab)
text(-1100, 0.05, expression('r' ^2~'= 0.53'))
text(-1100, -0.02, 'P = 0.004')
abline(h = r.crit, lty=3, col='gray')
legend('topright', legend = c('Western juniper','Ponderosa pine','Grand fir'), pch = unique(plot.data$sp.pch), bty='n', ncol=1)
axis(1, at = seq(-1250,250,500), labels = T)
axis(2, at = seq(0,.6,.2), labels = T, las=2)
lines(plot.data$cmi.gy.avg, fitted(my.lm), lwd=1.5, col='gray80')
par(par.op)
dev.off()
