###################################################################################################################
# This R script creates figure S1 from Berner and Law (2015)
# Author: Logan Berner, OSU
# Date: Nov 4th, 2015
###################################################################################################################
rm(list=ls())
setwd('')
require(lattice)
require(latticeExtra)
require(RColorBrewer)
load('workspaces/rw_climate_cors.1994.2013.RDATA')

# set stip to light gray
sb <- trellis.par.get("strip.background") 
sb[["col"]][1] <- "lightgray"
trellis.par.set("strip.background", sb) 

#rw.cmi.frac.cors$month <- factor(rw.cmi.frac.cors$month, labels=month.abb)
rw.clim.species.cor.cnt <- subset(rw.clim.species.cor.cnt, clim.par != 'soilmoist')
rw.clim.species.cor.cnt$species <- factor(rw.clim.species.cor.cnt$species, levels=sp.oi, labels = c('Western juniper','Ponderosa pine','Grand fir'))

rw.clim.species.cor.cnt$clim.par <- factor(rw.clim.species.cor.cnt$clim.par, levels=rev(c('tmean','tmax','tmin','vpd','freeze','cmi','defecit','spei')),
                                             , labels = rev(c('Tavg','Tmax','Tmin','VPD','Freeze','CMI','Deficit','SPEI')))

rw.clim.frac.cors.pos <- subset(rw.clim.species.cor.cnt, cor.cat=='pos')
rw.clim.frac.cors.neg <- subset(rw.clim.species.cor.cnt, cor.cat=='neg')
rw.clim.frac.cors.pos <- droplevels(rw.clim.frac.cors.pos)
rw.clim.frac.cors.neg <- droplevels(rw.clim.frac.cors.neg)

my.cols <- c(brewer.pal(9, "PuBu"), "black")

plot.pos <- useOuterStrips(levelplot(cor.pcnt.avg~lag+month|species+clim.par, rw.clim.frac.cors.pos, layout=c(1,3,1), cex=1.1, 
          #col.regions = rev(terrain.colors(20)), 
          at= do.breaks(c(-0.5,100),10),
          col.regions=my.cols,
          colorkey=list(space='top'),
          panel=panel.2dsmoother, args=list(span=0.13),
          main='% of trees with positive RWI-climate correlation (1964-2013)',
          scales=list(x=list(at=seq(1,36,3)), y=list(at=1:12, labels=month.abb)),
          ylab="Month",
          xlab="Time lag (number of months)",
          par.settings = list(strip.background=list(col="lightgrey"))
))

plot.neg <- useOuterStrips(levelplot(cor.pcnt.avg~lag+month|species+clim.par, rw.clim.frac.cors.neg, layout=c(1,3,1), cex=1.1, 
                         #col.regions = rev(terrain.colors(20)), 
                         at= do.breaks(c(-0.5,100),10),
                         col.regions=my.cols,
                         colorkey=list(space='top'),
                         panel=panel.2dsmoother, args=list(span=0.13),
                         main='% of trees with negative RWI-climate correlation (1964-2013)',
                         scales=list(x=list(at=seq(1,36,3)), y=list(at=1:12, labels=month.abb)),
                         ylab="Month",
                         xlab="Time lag (number of months)",
                         par.settings = list(strip.background=list(col="lightgrey"))
))

# plot both figures in an single window
#pdf('figures/fig4_rw_cmi_cor_frac_species.pdf', width = 6, height = 9)
jpeg('figures/figS1_rw_clim_cor_frac_species.jpg', width =18, height =12, units='in', res=400)
print(plot.pos, position=c(0,0,0.5,1), more=T)
print(plot.neg, position=c(0.5,0,1,1))
dev.off()
