rm(list=ls())
require(lattice)
require(reshape)

setwd("C:/research/projects/cascade_tree_traits/data/")


rw <- read.csv('treering/ringwidth_mmnts.csv', header=T, fill=T)

#-------------------------------------------------------------------------
# reshape the ring-width data from wide to long- format

rw.long <- melt(rw, id=c("year"))
rw.long <- na.omit(rw.long)
rw.long$variable <- as.character(rw.long$variable)

rw.metadat <- as.data.frame(do.call(rbind, strsplit(rw.long$variable, split='.', fixed=T)))
colnames(rw.metadat) <- c('strata','plot','subplot','tree.id','species')

rw.long <- cbind(rw.metadat, rw.long)
colnames(rw.long) <- c(colnames(rw.metadat), c('id','width.mm'))

write.csv(rw.long, 'ring_widths.csv')