rm(list=ls())
setwd('C:/Users/Logan/Google Drive/research/cascade_tree_traits/data/treerings/')
require(dplR)
require(lattice)
require(reshape2)
require(dplyr)
#------------------------------------------------------
ar.res.withNAs <- function(x){
  out.vec <- rep(NA, length(x))
  val.indx <- which(is.na(x)==F)
  ar.res <- rev(ar(rev(x[val.indx]), order.max = 1, method='ols')$resid)
  out.vec[val.indx] <- ar.res
  out.vec
}
ar.res.withNAs(c(rnorm(10)))
#------------------------------------------------------

meta.dat <- read.table('treering_metadata.csv', sep=',', header = T)
dim(meta.dat)

rw.all <- read.table('ringwidth_mmnts/treering_mmnts_combined.csv', sep=',', header = T)
rownames(rw.all) <- rw.all$year # move year to rownames, then drop col
rw.all <- rw.all[,-1]
match.index <- match(meta.dat$id, colnames(rw.all)) # match order of rw mmnt columns with enteries in the metadata
rw.all <- rw.all[,match.index]
dim(rw.all)

# check alignment of metadata and rw-data
rw.all[,which(colnames(rw.all)%in%meta.dat$id==F)] # check that the tree-ring mmnts and meta data align
data.frame(meta=meta.dat$id, rw=colnames(rw.all)) # the meta data and rw ID's line up? 

yoi <- 1963:2013
n.yoi <- length(yoi)

# subset rw mmnts to the reliable periods 
rw.reliable <- rw.all
for (i in 1:ncol(rw.all)){
  rw.tmp <- rw.reliable[,i]
  rw.tmp[which((as.numeric(rownames(rw.all))<meta.dat$reliable[i]))] <- NA
  rw.reliable[,i] <- rw.tmp
}

# rw.reliable <- rw.reliable[,which(colnames(rw.reliable)%in%meta.dat$id[na.omit(which(meta.dat$confidence<=2))])]
# rw.reliable <- rw.reliable[,colSums(is.na(rw.reliable)) != nrow(rw.reliable)]
# reliable.all.na <- as.vector(which(apply(rw.reliable, 1, FUN = function(x){all(is.na(x))}))) # flush out rows with all NA values 
# rw.reliable <- rw.reliable[-reliable.all.na,]

# select only rw years from 1964 to 2013
rw.yoi <- rw.reliable[as.numeric(rownames(rw.reliable))%in%yoi,]
dim(rw.yoi)

# detrend and pre-whiten series
rwi <- detrend(rw.yoi, make.plot = T, method = "Spline")
rwi.ar <- as.data.frame(apply(rwi, 2, FUN=ar.res.withNAs))
dim(rwi.ar)

# double check rwi/meta data alignment
data.frame(meta=meta.dat$id, rw=colnames(rwi)) # the meta data and rw ID's line up? 

# add 'year' column to melt on.... FOR SOME REASON THIS KEEPS ERRORING OUT!!!
rwi.ar$year <- as.numeric(rownames(rw.yoi))
rw.yoi$year <- as.numeric(rownames(rw.yoi))
rwi$year <- as.numeric(rownames(rw.yoi))

# melt meta, rw and rwi data into long format
meta.dat.long <- meta.dat[rep(seq_len(nrow(meta.dat)), each=n.yoi),]

rw.yoi.long <- melt(rw.yoi, variable.name="id", value.name=c("rw.mm"), id='year', na.rm = F)
rw.yoi.long$rwi <- melt(rwi, variable.name="id", value.name=c("rwi"), id='year', na.rm = F)[,3]
rw.yoi.long$rwi.ar <- melt(rwi.ar, variable.name="id", value.name=c("rwi.ar"), id='year', na.rm = F)[,3]

rw.yoi.long$id <- as.character(rw.yoi.long$id)
rw.yoi.long <- cbind(meta.dat.long, rw.yoi.long, by='id') # combine meta data with rwi data
rw.yoi.long <- rw.yoi.long[,-c(13,17)] # clean up a few superfilous cols
head(rw.yoi.long)

mf.data <- subset(rw.yoi.long, strata == 'mf')
rw.yoi.long <- subset(rw.yoi.long, strata != 'mf')
dim(rw.yoi.long)
length(unique(rw.yoi.long$id)) # number of trees 

write.table(mf.data, 'mf_master_treering_data.csv', sep = ',', row.names = F, col.names = T)
write.table(rw.yoi.long, 'treering_master_data.csv', sep = ',', row.names = F, col.names = T)
head(rw.yoi.long)

