####################################################################
### Differences in size class distribution and regression #########
### with grazer densities (ANOVA and lm or glm's)##################
### Table 5 #######################################################
###################################################################
### required data: median_sizes.txt ###############################
###################################################################
### (c) T.R. Vonnahme #############################################
###################################################################
##################################################################

###Journal: Biogeosciences: special issue: Freshwater ecosystems in changing permafrost landscapes
###Title of the paper: Controls on microalgal community structures in cryoconite holes upon high Arctic glaciers, Svalbard

###Authors and affiliations:#######################################
#########T.R. Vonnahme1,2,*  M. Devetter1,3  J. D. rsk1,4  M. aback1,5  J. Elster1,6
#########[1] Centre for Polar Ecology, Faculty of Science, University of South Bohemia, Cesk Budejovice, Czech Republic
#########[2] University of Konstanz, Constance, Germany
#########[3] Biology Centre of the Academy of Science of the Czech Republic, Institute of Soil Biology, Cesk Budejovice, Czech Republic
#########[4] Department of Ecology, Charles University, Prague, Czech Republic
#########[5] British Antarctic Survey, Cambridge, UK
#########[6] Institute of Botany, Academy of the Science of the Czech Republic, Trebon, Czech Republic
#########[*] {now at: Max Planck Institute for Marine Microbiology, Bremen, Germany} 
#########Correspondence to: T. R. Vonnahme (t.r.vonnahme@gmail.com) 

##################################################################
###################################################################
##################################################################


setwd("E://")
data<-read.table("median_sizes.txt", header=T)
head(data)
dim(data)

########################################################
### ANOVAS for differences between sites################
### method: ANOVA and TukeyHSD #########################
### p threshhold: 0.05 ##################################
### p correction: implied in TukeyHSD test ##############
### model validation: hist, Q-Q, Res vs Lev, Cook's dist#
### -> IF NOT NORMALLY DISTRIBUTED <-####################
### method: generalized linear model (poisson)##########
#########################################################

hist(log(data$median_Nostoc_colonysize+1))
model<-aov(log(median_Nostoc_colonysize+1)~site, data=data)
summary(model)
plot(model)

data2<-data[-57,]
### outlier NC3.1
model<-aov(mean_Osci_length~site, data=data2)
summary(model)
plot(model)
TukeyHSD(model)
### NL has longer filaments than the other sites !!! pANOVA=8.46*10^-5

model<-glm(median_Chloro_diamter~site, data=data, family="poisson")
summary(model)
plot(model)
### not possible to transform to normal distribution-> glm

data3<-data[-44,]
hist(data3$median_desmid_length)
model<-glm(median_desmid_length~site, data=data3, family="poisson")
summary(model)
plot(model)
### not possible to transform to normal distribution-> glm
### influential data point outside cook's diatnce removed (44=N22)


###########################################################
### Linear or generalized linear model with grazer ########
### multivariate regression################################
###########################################################
### method: multiple linear regression ###################
### p values and correction as described for ANOVAs######
### algae as dependent and grazer as explanatory var.####
###->NO NORMAL DISTR. POSSIBLE ##########################
### method: glm (poisson)#################################
### p correction for all with false discivery rate########
###########################################################

model<-lm(log(median_Nostoc_colonysize+1)~
Bdelloids_total + Tardigrades + Ciliates , data=data)
summary(model)
model<-glm(log(median_Nostoc_colonysize+1)~
Bdelloids_total + Tardigrades + Ciliates , data=data, family="poisson")
summary(model)
### p 0.758 0.871 0.93
### estimate 0.005 -0.001 0.002

model<-lm(mean_Osci_length~
Bdelloids_total + Tardigrades + Ciliates, data=data2)
model<-glm(mean_Osci_length~
Bdelloids_total + Tardigrades + Ciliates, data=data2, family="poisson")
summary(model)
plot(model)
plot(mean_Osci_length~
Bdelloids_total, data=data2)
### not normally distributed! Bdelloids seem to be negatively correlated
### p 0.000693 0.80588 0.002488
### Estimate -0.0160 0.0004 0.0136

model<-glm(median_Chloro_diamter~
Bdelloids_total + Tardigrades + Ciliates, data=data2, family="poisson")
summary(model)
###p 0.253 0.901 0.606
###Estimate -0.011 0.0004 -0.005

model<-glm(median_desmid_length~
Bdelloids_total + Tardigrades + Ciliates, data=data2, family="poisson")
summary(model)
### Bdelloids seem to be important again
### p 0.0258 0.9622 0.2073
### Estimate -0.0158 -0.0001 0.0093

p<-c(0.758, 0.871, 0.93, 0.000693, 0.80588, 0.002488, 0.253,
0.901, 0.606, 0.0258, 0.9622, 0.2073)

p.adjust(p, method="fdr", n=12)
# [1] 0.962200 0.962200 0.962200 0.008316 0.962200 0.014928 0.607200 0.962200
# [9] 0.962200 0.103200 0.962200 0.607200

################### Rotifers Tardigrades Ciliates
# Nostocales##### Est. 0.005 -0.001 0.002
################# p 0.9622 0.9622 0.9622
# Oscillatoriales Est. -0.016 0.0004 0.0136
################ p 0.0083 0.9622 0.0149 
# Chlorococcales Est. -0.011 0.0004 -0.005
################ p 0.6072 0.9622 0.9622
# Zygnemales#### Est. -0.0158 -0.0001 0.0093
################# p  0.1032 0.9622 0.6072


