setwd('F:/')###############################################
### Plot creator ##############################
###############################################
### (c) T.R. Vonnahme #########################
###############################################
### Script for creation of Figures 3 and 5 ####
### AND data used in the script
###############################################

###Journal: Biogeosciences: special issue: Freshwater ecosystems in changing permafrost landscapes
###Title of the paper: Controls on microalgal community structures in cryoconite holes upon high Arctic glaciers, Svalbard

###Authors and affiliations:
#########T.R. Vonnahme1,2,*  M. Devetter1,3  J. D. rsk1,4  M. aback1,5  J. Elster1,6
#########[1] Centre for Polar Ecology, Faculty of Science, University of South Bohemia, Cesk Budejovice, Czech Republic
#########[2] University of Konstanz, Constance, Germany
#########[3] Biology Centre of the Academy of Science of the Czech Republic, Institute of Soil Biology, Cesk Budejovice, Czech Republic
#########[4] Department of Ecology, Charles University, Prague, Czech Republic
#########[5] British Antarctic Survey, Cambridge, UK
#########[6] Institute of Botany, Academy of the Science of the Czech Republic, Trebon, Czech Republic
#########[*] {now at: Max Planck Institute for Marine Microbiology, Bremen, Germany} 
#########Correspondence to: T.R. Vonnahme (t.r.vonnahme@gmail.com) 

################################################
################################################
################################################

setwd("F://")

################################################
### Figure 3 ###################################
#################################################



pdf("C:/Dokumente und Einstellungen/tobias/Eigene Dateien//Fig3.pdf", width=6.85, height=2.7, family="Times", pointsize=10)

par(mfrow=c(1,3))
par(oma=c(0,3,0,0))

############################################
###A) data import: summarized data #########
env<-read.table("envaverage2.txt", header=T)

### subset with used variables, with NAs##############
all<-data.frame(env$ID, env$site, env$elevation, env$sedmass,
    env$water, env$om, env$depth, env$slopedist,
    env$Chlorococcales, env$Zygnemales, env$coc_cyano, env$filament_cyano,
    env$Tardigrades, env$Rotifers, env$Ciliates)
specA<-data.frame(all$env.Chlorococcales, all$env.Zygnemales, all$env.filament_cyano, 
       all$env.coc_cyano, all$env.Tardigrades, all$env.Rotifers, all$env.Ciliates)
       colnames(specA)<-c("Chl", "Zyg", "Nos", "Osc", "Tar", "Rot", "Cil") 
       row.names(specA)<-all$env.ID
algA<-data.frame(all$env.Chlorococcales, all$env.Zygnemales, all$env.filament_cyano, 
       all$env.coc_cyano)
       colnames(algA)<-c("Chl", "Zyg", "Nos", "Osc") 
       row.names(algA)<-all$env.ID
invA<-data.frame(all$env.Tardigrades, all$env.Rotifers, all$env.Ciliates)
       colnames(invA)<-c( "Tar", "Rot", "Cil") 
       row.names(invA)<-all$env.ID

require(RColorBrewer)

###############################################################
###Fig3a

algA2<-cbind(algA/1000000,env$site)
algA3<-aggregate(cbind(Zyg, Chl, Osc, Nos) ~ env$site, mean, data=algA2)

se=function(x)
{ sd(x)/sqrt(length(x)) }

algA3b<-aggregate(cbind(Zyg, Chl, Osc, Nos) ~ env$site, se, data=algA2)


algA4<-as.data.frame(t(algA3[,-1]))
colnames(algA4)<-c("E","HC","NC","NI","NL","NR")
row.names(algA4)<-c("Zygnemales", "Chlorococcales", "Oscillatoriales","Nostocales")
algA4b<-as.data.frame(t(algA3b[,-1]))
colnames(algA4b)<-c("E","HC","NC","NI","NL","NR")
se<-as.matrix(algA4b)

par(mar=c(5.1,5,4.1,2.1))

mp<-barplot(as.matrix(algA4), beside=T, 
xlab="Sites", ylim=c(0,220),main="a", cex.main=3, lwd=0.25,
#col=c("chocolate4","red","blue4", "deepskyblue2"),
col=brewer.pal(4, "YlGn"),
#angle=c(45,90,0,120), density=c(45,60,80,30), 
ylab=expression(paste("Micoalgae biovolumes [",mu,"m",cm^-2,"]x",10^6)),
oma=c(0,2,0,0))

legend(10, 200, c("Zygnemales", "Chlorococcales", "Oscillatoriales","Nostocales"),
pch=15, 
#angle=c(45,90,0,120), density=c(45,60,80,30),
col=brewer.pal(4, "YlGn"),
#col=c("chocolate4","red","blue4", "deepskyblue2"),
bty= "n", 
cex=1) 


error.bar <- function(x, y, upper, lower=upper, length=0.03,...){
    if(length(x) != length(y) | length(y) !=length(lower) | length(lower) != length(upper))
    stop("vectors must be same length")
    arrows(x,y+upper, x, y-lower, angle=90, code=3, length=length,lwd=0.25, ...)
    }

error.bar(as.matrix(mp), as.matrix(algA4), as.matrix(se))


######### data for microalgae on different sites: ####################

###mean values:
algA4
### standard errors
algA4b


#######################################################################
###Fig3b

invA2<-cbind(invA,env$site)
invA3<-aggregate(cbind(Tar, Rot, Cil) ~ env$site, mean, data=invA2)

se=function(x)
{ sd(x)/sqrt(length(x)) }

invA3b<-aggregate(cbind(Tar, Rot, Cil) ~ env$site, se, data=invA2)

invA4<-as.data.frame(t(invA3[,-1]))
colnames(invA4)<-c("E","HC","NC","NI","NL","NR")
invA4b<-as.data.frame(t(invA3b[,-1]))
colnames(invA4b)<-c("E","HC","NC","NI","NL","NR")
se<-as.matrix(invA4b)
row.names(invA4)<-c("Tardigrada", "Rotifera","Ciliates")

mp<-barplot(as.matrix(invA4), beside=T, legend=F,main="b", cex.main=3,lwd=0.25,
xlab="Sites", ylim=c(0,40), 
col=brewer.pal(3, "YlGn"),
#col=c("chocolate4","red","blue4"),
#angle=c(45,90,0), density=c(60,40,80),
ylab=expression(paste("Grazer abundances [Ind. ",cm^-2,"]")))

legend('top', c("Tardigrada","Rotifera","Ciliates"),
pch=15, bty="n", 
col=brewer.pal(3, "YlGn"),
#col=c("chocolate4","red","blue4"),
#angle=c(45,90,0), density=c(25,40,25), 
cex=1) 

error.bar(as.matrix(mp), as.matrix(invA4), as.matrix(se))

######### data for grazer on different sites: ####################

###mean values:
invA4
### standard errors
invA4b

#################################################################
###Fig3c

 data2<-read.table("16S_Miseq_2.txt", header=T)

rownames(data2)<-data2[,1]

data2<-data2[,-1]
colnames(data2)<-c("Arthronema","Nostoc","Microcoleus",
"Calothrix","Symploca","Pseudoanabaena","Leptolyngbya")

data2<-t(data2)
data2<-data2[,1:3]
colnames(data2) <- c("HC", "NR 1", "NR 2")
se<-sd(data2[,1:3]/sqrt(2))

par(mar=c(5.1,4.1,4.1,2.5))

barplot(as.matrix(data2)
, legend=F, main="c", cex.main=3,lwd=0.25,
col=brewer.pal(7, "YlGn"),
#col=c("red","black","darkorange4","darkorange2","blue4","skyblue1","darkmagenta"),
#density=c(70,80,30,35,40,50,60), angle=c(0,90,45,135,25, 115, 150),
xlab="Sites", ylab="Proportion of cyanobacteria in 16S reads [%]",
xlim=c(0,4), ylim=c(0,50))

legend('topright', 
c(
(expression(italic("Leptolyngbya sp."))),
(expression(italic("Pseudoanabaena sp."))),
(expression(italic("Symploca sp."))),
(expression(italic("Calothrix spp."))),
(expression(italic("Microcoleus sp."))),
(expression(italic("Nostoc spp."))),
(expression(italic("Arthronema sp.")))),

#density=c(60,50,40,35,30,80,70),
#angle=c(150,115,25,135,45,90,0),
col=brewer.pal(7, "YlGn"),
#col=c("darkmagenta","skyblue1","blue4","darkorange2","darkorange4","black","red")
,pch=15,  bty="n")



######### data for the 16S reads on species levels on different sites: #######

###values:
data2



##################################################################
dev.off()
###################################################################


##################################################################
###Figure 5 ######################################################
##################################################################


pdf("C:/Dokumente und Einstellungen/tobias/Eigene Dateien//Fig5.pdf", width=6.85, height=6.85, family="Times", pointsize=9.5)

par(mfrow=c(2,1))
par(oma=c(0,3,0,0))

##########################################################################

spec<-read.table("spec_sc3.txt", header=T, row.names=1)
colnames(spec)<-c("Chroococcales","Nostocales<11","Nostocales>11",
"Oscillatoriales<25","Oscillatoriales=25",
"Oscillatoriales>25","Chlorococcales<11","Chlorococcales>11","Zygnemales")
colnames(spec)<-c("Chr","Nos<11","Nos>11","Osc<25","Osc=25",
"Osc>25","Chl<11","Chl>11","Zyg")
spect <- t(spec)
spectsum <- 


mp<-barplot((100*spect), xlab="Sites", main="a",cex.main=3,
ylab="Proportion of size classes [%]",
col=c("325","300","black","yellow","orange","146","rosybrown1","salmon","saddlebrown")
, density=c(30,40,85,60,70,80,35,45,90), angle=c(150,115,25,135,45,90,0,150,70)
, xlim=c(0,8),legend=T)
#ylab=expression(paste("Microalgae biovolume [",mu,"m"," ",cm^-2,"]")))

#####################################################################

data<-read.table("median_sizes.txt", header=T, row.names=1)
alg<-data.frame(data[,2:5])
colnames(alg)<-c("Nostocales","Oscillatoriales","Chlorococcales","Zygnemales")
boxplot(alg, ylab=expression(paste("Quantiles of size [",mu,"m]")), main="b", 
cex.main=3)

######################################################################
dev.off()
######################################################################


######################################################################
### additional data for Rotifer genera ###############################
######################################################################

rot<-data.frame(env$site, env$Macrotrachella, env$Adineta, env$Encentrum)
colnames(rot)<-c("site","Macrotrachella","Adineta","Encentrum")
rot2<-aggregate(cbind(rot$Macrotrachella, rot$Adineta) ~ rot$site, mean, data=rot)

###mean values
rot2

 se=function(x)
{ sd(x)/sqrt(length(x)) }
 rot3<-aggregate(cbind(rot$Macrotrachella, rot$Adineta, rot$Encentrum) ~ rot$site, se, data=rot)

###standard errors
 rot3