---
title: Documentation for the manganese ocean model
author: Marco van Hulten
email: mvhulten@lsce.ipsl.fr
affiliation: Laboratoire des Sciences du Climat et de l'Environnement (LSCE)
date: 25 November 2016
rights: CeCILL version 2 or higher
...

This document describes how to setup the model that was used in the
paper *Manganese in the West Atlantic Ocean in context of the first global
ocean circulation model of manganese* by Van Hulten et al. ([arXiv:1606.07128]).

Download revision 7036 of [NEMO] [3.6].

    $ svn checkout -r 7036 http://forge.ipsl.jussieu.fr/nemo/svn/branches/2015/nemo_v3_6_STABLE

A login will be asked that you can create on the [NEMO] website.

If exact reproduction is not the ultimate goal, and you rather
want to build further upon my model, download the [latest] version.

[arXiv]: https://arxiv.org/abs/1606.07128
[NEMO]: http://www.nemo-ocean.eu/
[3.6]: http://forge.ipsl.jussieu.fr/nemo/svn/branches/2015/nemo_v3_6_STABLE/
[latest]: http://forge.ipsl.jussieu.fr/nemo/svn/trunk/

Make a NEMO configuration as described in the [online
documentation][NEMO].

The manganese module comes as part of different Fortran 90/95 source code files
that are to be found in the Supplementary Material of the paper.
Those should be put in `NEMOGCM/CONFIG/*/MY_SRC/` that adds and
overrides symlinks in `NEMOGCM/CONFIG/*/WORK/`.
The asterisk must be replaced with your configuration name that should be based
on `ORCA2_OFF_PISCES`.
The forcing files (circulation, dust, rivers and hydrothermal) are as
provided in the NEMO 3.6 download.

Both NEMO and the manganese model are available under the [CeCILL]
licence.  The paper and the documentation are licensed under the
[Creative Commons] Attribution--ShareAlike.
Note that I am the author of only the manganese code that is enclosed
between the `key_mang` preprocessor keys.  The models and components
NEMO, TOP and PISCES are written by others (references in the paper).

[CeCILL]: http://www.cecill.info/
[Creative Commons]: https://creativecommons.org/

