MODULE par_mang
   !!======================================================================
   !!                        ***  par_mang  ***
   !! TOP :   set the parameters for the manganese model
   !!======================================================================
   !! History :   0.0  !  2015-07  (M. van Hulten)  based on MY_PROTAC
   !!----------------------------------------------------------------------
   !! NEMO/TOP 3.6 , NEMO Consortium (2015)
   !! Software governed by the CeCILL licence (NEMOGCM/NEMO_CeCILL.txt)
   !!----------------------------------------------------------------------
   USE par_pisces , ONLY : jp_pisces       !: number of tracers in PISCES
   USE par_pisces , ONLY : jp_pisces_2d    !: number of 2D diag in PISCES
   USE par_pisces , ONLY : jp_pisces_3d    !: number of 3D diag in PISCES
   USE par_pisces , ONLY : jp_pisces_trd   !: number of biological diag in PISCES

   USE par_cfc    , ONLY : jp_cfc          !: number of tracers in CFC
   USE par_cfc    , ONLY : jp_cfc_2d       !: number of tracers in CFC
   USE par_cfc    , ONLY : jp_cfc_3d       !: number of tracers in CFC
   USE par_cfc    , ONLY : jp_cfc_trd      !: number of tracers in CFC

   USE par_c14b   , ONLY : jp_c14b         !: number of tracers in C14
   USE par_c14b   , ONLY : jp_c14b_2d      !: number of tracers in C14
   USE par_c14b   , ONLY : jp_c14b_3d      !: number of tracers in C14
   USE par_c14b   , ONLY : jp_c14b_trd     !: number of tracers in C14

   USE par_protac , ONLY : jp_protac       !: number of tracers in PROTAC
   USE par_protac , ONLY : jp_protac_2d    !: number of tracers in PROTAC
   USE par_protac , ONLY : jp_protac_3d    !: number of tracers in PROTAC
   USE par_protac , ONLY : jp_protac_trd   !: number of tracers in PROTAC

   IMPLICIT NONE

   INTEGER, PARAMETER ::   jp_lm      =  jp_pisces     + jp_cfc     + jp_c14b     + jp_protac
   INTEGER, PARAMETER ::   jp_lm_2d   =  jp_pisces_2d  + jp_cfc_2d  + jp_c14b_2d  + jp_protac_2d
   INTEGER, PARAMETER ::   jp_lm_3d   =  jp_pisces_3d  + jp_cfc_3d  + jp_c14b_3d  + jp_protac_3d
   INTEGER, PARAMETER ::   jp_lm_trd  =  jp_pisces_trd + jp_cfc_trd + jp_c14b_trd + jp_protac_trd

#if defined key_mang
   !!---------------------------------------------------------------------
   !!   'key_mang'                        Manganese
   !!---------------------------------------------------------------------
   LOGICAL, PUBLIC, PARAMETER ::   lk_mang     = .TRUE.
   INTEGER, PUBLIC, PARAMETER ::   jp_mang     =  2
   INTEGER, PUBLIC, PARAMETER ::   jp_mang_2d  =  0
   INTEGER, PUBLIC, PARAMETER ::   jp_mang_3d  =  0
   INTEGER, PUBLIC, PARAMETER ::   jp_mang_trd =  0

   ! assign an index in trc arrays for each PTS prognostic variables
   INTEGER, PUBLIC, PARAMETER ::   jpdmn = jp_lm + 1    !: Dissolved manganese
   INTEGER, PUBLIC, PARAMETER ::   jpomn = jp_lm + 2    !: Oxidised/particulate manganese

#else
   !!---------------------------------------------------------------------
   !!   Default                           No manganese
   !!---------------------------------------------------------------------
   LOGICAL, PUBLIC, PARAMETER ::   lk_mang     = .FALSE.
   INTEGER, PUBLIC, PARAMETER ::   jp_mang     =  0
   INTEGER, PUBLIC, PARAMETER ::   jp_mang_2d  =  0
   INTEGER, PUBLIC, PARAMETER ::   jp_mang_3d  =  0
   INTEGER, PUBLIC, PARAMETER ::   jp_mang_trd =  0
#endif

   ! MANG do-loop mang indices (N.B. no MANG : jp_mang0 > jp_mang1 do-loops are not done)
   INTEGER, PUBLIC, PARAMETER ::   jp_mang0     = jp_lm     + 1             !: First index
   INTEGER, PUBLIC, PARAMETER ::   jp_mang1     = jp_lm     + jp_mang       !: Last  index
   INTEGER, PUBLIC, PARAMETER ::   jp_mang0_2d  = jp_lm_2d  + 1             !: First index
   INTEGER, PUBLIC, PARAMETER ::   jp_mang1_2d  = jp_lm_2d  + jp_mang_2d    !: Last  index
   INTEGER, PUBLIC, PARAMETER ::   jp_mang0_3d  = jp_lm_3d  + 1             !: First index
   INTEGER, PUBLIC, PARAMETER ::   jp_mang1_3d  = jp_lm_3d  + jp_mang_3d    !: Last  index
   INTEGER, PUBLIC, PARAMETER ::   jp_mang0_trd = jp_lm_trd + 1             !: First index
   INTEGER, PUBLIC, PARAMETER ::   jp_mang1_trd = jp_lm_trd + jp_mang_trd   !: Last  index

END MODULE par_mang
