MODULE par_protac
   !!======================================================================
   !!                        ***  par_protac  ***
   !! TOP :   set the parameters for the Pa and Th isotopes model
   !!======================================================================
   !! History :   0.0  !  2015-04  (M. van Hulten)  based on MY_TRC
   !!----------------------------------------------------------------------
   !! NEMO/TOP 3.6 , NEMO Consortium (2015)
   !! Software governed by the CeCILL licence (NEMOGCM/NEMO_CeCILL.txt)
   !!----------------------------------------------------------------------
   USE par_pisces , ONLY : jp_pisces       !: number of tracers in PISCES
   USE par_pisces , ONLY : jp_pisces_2d    !: number of 2D diag in PISCES
   USE par_pisces , ONLY : jp_pisces_3d    !: number of 3D diag in PISCES
   USE par_pisces , ONLY : jp_pisces_trd   !: number of biological diag in PISCES

   USE par_cfc    , ONLY : jp_cfc          !: number of tracers in CFC
   USE par_cfc    , ONLY : jp_cfc_2d       !: number of tracers in CFC
   USE par_cfc    , ONLY : jp_cfc_3d       !: number of tracers in CFC
   USE par_cfc    , ONLY : jp_cfc_trd      !: number of tracers in CFC

   USE par_c14b   , ONLY : jp_c14b         !: number of tracers in C14
   USE par_c14b   , ONLY : jp_c14b_2d      !: number of tracers in C14
   USE par_c14b   , ONLY : jp_c14b_3d      !: number of tracers in C14
   USE par_c14b   , ONLY : jp_c14b_trd     !: number of tracers in C14

   IMPLICIT NONE

   INTEGER, PARAMETER ::   jp_lm      =  jp_pisces     + jp_cfc     + jp_c14b
   INTEGER, PARAMETER ::   jp_lm_2d   =  jp_pisces_2d  + jp_cfc_2d  + jp_c14b_2d
   INTEGER, PARAMETER ::   jp_lm_3d   =  jp_pisces_3d  + jp_cfc_3d  + jp_c14b_3d
   INTEGER, PARAMETER ::   jp_lm_trd  =  jp_pisces_trd + jp_cfc_trd + jp_c14b_trd

#if defined key_protac
   !!---------------------------------------------------------------------
   !!   'key_protac'                     Pa and Th isotopes
   !!---------------------------------------------------------------------
   LOGICAL, PUBLIC, PARAMETER ::   lk_protac     = .TRUE.
   INTEGER, PUBLIC, PARAMETER ::   jp_protac     =  6
   INTEGER, PUBLIC, PARAMETER ::   jp_protac_2d  =  0
   INTEGER, PUBLIC, PARAMETER ::   jp_protac_3d  =  0
   INTEGER, PUBLIC, PARAMETER ::   jp_protac_trd =  0

   ! assign an index in trc arrays for each PTS prognostic variables
   INTEGER, PUBLIC, PARAMETER ::   jppa231d = jp_lm + 1    !: Dissolved protactinium-231 radioactivity
   INTEGER, PUBLIC, PARAMETER ::   jppa231s = jp_lm + 2    !: Slowly sinking Pa-231 radioactivity
   INTEGER, PUBLIC, PARAMETER ::   jppa231f = jp_lm + 3    !: Fast sinking Pa-231 radioactivity
   INTEGER, PUBLIC, PARAMETER ::   jpth230d = jp_lm + 4    !: Dissolved thorium-230 radioactivity
   INTEGER, PUBLIC, PARAMETER ::   jpth230s = jp_lm + 5    !: Slowly sinking Th-230 radioactivity
   INTEGER, PUBLIC, PARAMETER ::   jpth230f = jp_lm + 6    !: Fast sinking Th-230 radioactivity

#else
   !!---------------------------------------------------------------------
   !!   Default                           No Pa and Th isotopes
   !!---------------------------------------------------------------------
   LOGICAL, PUBLIC, PARAMETER ::   lk_protac     = .FALSE.
   INTEGER, PUBLIC, PARAMETER ::   jp_protac     =  0
   INTEGER, PUBLIC, PARAMETER ::   jp_protac_2d  =  0
   INTEGER, PUBLIC, PARAMETER ::   jp_protac_3d  =  0
   INTEGER, PUBLIC, PARAMETER ::   jp_protac_trd =  0
#endif

   ! PROTAC do-loop protac indices (N.B. no PROTAC : jp_protac0 > jp_protac1 do-loops are not done)
   INTEGER, PUBLIC, PARAMETER ::   jp_protac0     = jp_lm     + 1             !: First index
   INTEGER, PUBLIC, PARAMETER ::   jp_protac1     = jp_lm     + jp_protac     !: Last  index
   INTEGER, PUBLIC, PARAMETER ::   jp_protac0_2d  = jp_lm_2d  + 1             !: First index
   INTEGER, PUBLIC, PARAMETER ::   jp_protac1_2d  = jp_lm_2d  + jp_protac_2d  !: Last  index
   INTEGER, PUBLIC, PARAMETER ::   jp_protac0_3d  = jp_lm_3d  + 1             !: First index
   INTEGER, PUBLIC, PARAMETER ::   jp_protac1_3d  = jp_lm_3d  + jp_protac_3d  !: Last  index
   INTEGER, PUBLIC, PARAMETER ::   jp_protac0_trd = jp_lm_trd + 1             !: First index
   INTEGER, PUBLIC, PARAMETER ::   jp_protac1_trd = jp_lm_trd + jp_protac_trd !: Last  index

END MODULE par_protac
