MODULE trcini_mang
   !!======================================================================
   !!                         ***  MODULE trcini_mang  ***
   !! TOP :   initialisation of the manganese tracers
   !!======================================================================
   !! History :   0.0  !  2015-07  (M. van Hulten)  Based on Th/Pa code
   !!             0.1  !  2016-10  (M. van Hulten)  Mn biology namelist
   !!----------------------------------------------------------------------
   !! NEMO/TOP 3.6 , NEMO Consortium (2015)
   !! Software governed by the CeCILL licence     (NEMOGCM/NEMO_CeCILL.txt)
   !!----------------------------------------------------------------------
#if defined key_mang
   !!----------------------------------------------------------------------
   !!   'key_mang'                                          Mn tracers
   !!----------------------------------------------------------------------
   !! trc_ini_mang   : Mn model initialisation
   !!----------------------------------------------------------------------
   USE oce_trc         ! Ocean variables
   USE par_trc         ! TOP parameters
   USE trc             ! TOP variables
   USE sms_pisces,   ONLY : po4r
   USE trcsms_mang     ! Mn sms trends

   IMPLICIT NONE
   PRIVATE

   PUBLIC   trc_ini_mang   ! called by trc_init() in trcini.F90

   REAL(wp), PUBLIC  :: biorMnP, biorMnC  ! uptake/remineralisation ratio of Mn

CONTAINS

   SUBROUTINE trc_ini_mang
      !!----------------------------------------------------------------------
      !!                     ***  trc_ini_mang  ***  
      !!
      !! ** Purpose :   initialization for Mn model
      !!
      !! ** Method  : - Read the nammang_bio namelist and check the parameter values
      !!              - If no restart needed, set initial values for dMn and oMn
      !!
      !! ** Input   :   Namelist section nammang_bio
      !!----------------------------------------------------------------------
      NAMELIST/nammang_bio/ biorMnP
      INTEGER           :: ios                  ! Local output status for namelist read

      IF(lwp) WRITE(numout,*)
      IF(lwp) WRITE(numout,*) ' trc_ini_mang: initialisation of Mn model'
      IF(lwp) WRITE(numout,*) ' ~~~~~~~~~~~~~~'
      
      IF( .NOT. ln_rsttr ) THEN
         IF(lwp) THEN
            WRITE(numout,*)
            WRITE(numout,*) 'No restart : Mn concentrations equal reasonable, small values'
         ENDIF
         trn(:,:,:,jpdmn) = 0.1e-9
         trn(:,:,:,jpomn) = 25.e-12
         !trn(:,:,:,jp_mang0:jp_mang1) = 0.
      ENDIF

      CALL ctl_opn( numnammang, 'namelist_mang', 'UNKNOWN', 'FORMATTED', 'SEQUENTIAL', -1, &
      &             numout, .FALSE. )
      REWIND( numnammang )
      READ  ( numnammang, nammang_bio,  IOSTAT = ios, ERR = 923 )
923   IF ( ios /= 0 ) CALL ctl_nam( ios , 'nammang_bio   in namelist_mang', lwp )
      biorMnC = biorMnP * po4r

      IF(lwp) THEN                         ! control print
         WRITE(numout,*) ' '
         WRITE(numout,*) ' Namelist parameters for biology, nammang_bio'
         WRITE(numout,*) ' ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~'
         WRITE(numout,*) '    incorporation ratio Mn/P                 biorMnP    =', biorMnP
         WRITE(numout,*) '    incorporation ratio Mn/C                 biorMnC    =', biorMnC
      ENDIF

   END SUBROUTINE trc_ini_mang

#else
   !!----------------------------------------------------------------------
   !!   Dummy module                                        No Mn model
   !!----------------------------------------------------------------------
CONTAINS
   SUBROUTINE trc_ini_mang             ! Empty routine
   END SUBROUTINE trc_ini_mang
#endif

   !!======================================================================
END MODULE trcini_mang
