MODULE trcini_protac
   !!======================================================================
   !!                         ***  MODULE trcini_protac  ***
   !! TOP :   initialisation of the Pa/Th tracers
   !!======================================================================
   !! History :   0.0  !  2015-04  (M. van Hulten)  Based on C14b code
   !!----------------------------------------------------------------------
   !! NEMO/TOP 3.6 , NEMO Consortium (2015)
   !! Software governed by the CeCILL licence     (NEMOGCM/NEMO_CeCILL.txt)
   !!----------------------------------------------------------------------
#if defined key_protac
   !!----------------------------------------------------------------------
   !!   'key_protac'                                          Pa/Th tracers
   !!----------------------------------------------------------------------
   !! trc_ini_protac   : Pa/Th model initialisation
   !!----------------------------------------------------------------------
   USE oce_trc         ! Ocean variables
   USE par_trc         ! TOP parameters
   USE trc             ! TOP variables
   USE trcsms_protac   ! Pa/Th sms trends

   IMPLICIT NONE
   PRIVATE

   PUBLIC   trc_ini_protac   ! called by trc_init() in trcini.F90

CONTAINS

   SUBROUTINE trc_ini_protac
      !!----------------------------------------------------------------------
      !!                     ***  trc_ini_protac  ***  
      !!
      !! ** Purpose :   initialization for Pa/Th model
      !!
      !! ** Method  : - Read the namcfc namelist and check the parameter values
      !!----------------------------------------------------------------------

      !                       ! Allocate Pa/Th arrays
      !IF( trc_sms_protac_alloc() /= 0 )   CALL ctl_stop( 'STOP', 'trc_ini_protac: unable to allocate Pa/Th arrays' )
      ! TODO: if to be added, add allocate routine in trcsms_protac.F90 akin to trcsms_my_trc.F90

      IF(lwp) WRITE(numout,*)
      IF(lwp) WRITE(numout,*) ' trc_ini_protac: initialisation of Pa/Th model'
      IF(lwp) WRITE(numout,*) ' ~~~~~~~~~~~~~~'
      
      IF( .NOT. ln_rsttr ) THEN
         IF(lwp) THEN
            WRITE(numout,*)
            WRITE(numout,*) 'No restart : Pa and Th isotope activities equal zero'
         ENDIF
         trn(:,:,:,jp_protac0:jp_protac1) = 0.
      ENDIF

   END SUBROUTINE trc_ini_protac

#else
   !!----------------------------------------------------------------------
   !!   Dummy module                                        No Pa/Th model
   !!----------------------------------------------------------------------
CONTAINS
   SUBROUTINE trc_ini_protac             ! Empty routine
   END SUBROUTINE trc_ini_protac
#endif

   !!======================================================================
END MODULE trcini_protac
