MODULE trcwri_mang
   !!======================================================================
   !!                       *** MODULE trcwri_mang ***
   !!    mang :   Output of mang tracers
   !!======================================================================
   !! History :   0.0  ! 2015-08 (M. van Hulten)  based on PROTAC
   !!----------------------------------------------------------------------
   !! NEMO/TOP 3.6 , NEMO Consortium (2015)
   !! Software governed by the CeCILL licence (NEMOGCM/NEMO_CeCILL.txt)
   !!----------------------------------------------------------------------
#if defined key_top && key_mang && defined key_iomput
   !!----------------------------------------------------------------------
   !!   'key_mang'                                           mang model
   !!----------------------------------------------------------------------
   !! trc_wri_mang   :  outputs of concentration fields
   !!----------------------------------------------------------------------
   USE trc         ! passive tracers common variables 
   USE iom         ! I/O manager

   IMPLICIT NONE
   PRIVATE

   PUBLIC trc_wri_mang 

#  include "top_substitute.h90"
CONTAINS

   SUBROUTINE trc_wri_mang
      !!---------------------------------------------------------------------
      !!                     ***  ROUTINE trc_wri_trc  ***
      !!
      !! ** Purpose :   output passive tracers fields 
      !!---------------------------------------------------------------------
      CHARACTER (len=20)   :: cltra
      INTEGER              :: jn
      !!---------------------------------------------------------------------
 
      ! write the tracer concentrations in the file
      ! ---------------------------------------
      DO jn = jp_mang0, jp_mang1
         cltra = TRIM( ctrcnm(jn) )                  ! short title for tracer
         CALL iom_put( cltra, trn(:,:,:,jn) )
      END DO
      !
   END SUBROUTINE trc_wri_mang

#else
   !!----------------------------------------------------------------------
   !!  Dummy module :                                     No passive tracer
   !!----------------------------------------------------------------------
   PUBLIC trc_wri_mang
CONTAINS
   SUBROUTINE trc_wri_mang                     ! Empty routine  
   END SUBROUTINE trc_wri_mang
#endif

END MODULE trcwri_mang
