MODULE trcwri_protac
   !!======================================================================
   !!                       *** MODULE trcwri_protac ***
   !!    protac :   Output of protac tracers
   !!======================================================================
   !! History :   0.0  ! 2015-04 (M. van Hulten)  based on MY_TRC (C. Ethe)
   !!----------------------------------------------------------------------
   !! NEMO/TOP 3.6 , NEMO Consortium (2015)
   !! Software governed by the CeCILL licence (NEMOGCM/NEMO_CeCILL.txt)
   !!----------------------------------------------------------------------
#if defined key_top && key_protac && defined key_iomput
   !!----------------------------------------------------------------------
   !!   'key_protac'                                           protac model
   !!----------------------------------------------------------------------
   !! trc_wri_protac   :  outputs of concentration fields
   !!----------------------------------------------------------------------
   USE trc         ! passive tracers common variables 
   USE iom         ! I/O manager

   IMPLICIT NONE
   PRIVATE

   PUBLIC trc_wri_protac 

#  include "top_substitute.h90"
CONTAINS

   SUBROUTINE trc_wri_protac
      !!---------------------------------------------------------------------
      !!                     ***  ROUTINE trc_wri_trc  ***
      !!
      !! ** Purpose :   output passive tracers fields 
      !!---------------------------------------------------------------------
      CHARACTER (len=20)   :: cltra
      INTEGER              :: jn
      !!---------------------------------------------------------------------
 
      ! write the tracer concentrations in the file
      ! ---------------------------------------
      DO jn = jp_protac0, jp_protac1
         cltra = TRIM( ctrcnm(jn) )                  ! short title for tracer
         CALL iom_put( cltra, trn(:,:,:,jn) )
      END DO
      !
   END SUBROUTINE trc_wri_protac

#else
   !!----------------------------------------------------------------------
   !!  Dummy module :                                     No passive tracer
   !!----------------------------------------------------------------------
   PUBLIC trc_wri_protac
CONTAINS
   SUBROUTINE trc_wri_protac                     ! Empty routine  
   END SUBROUTINE trc_wri_protac
#endif

END MODULE trcwri_protac
