massSizeData = csvread('massSizeData.csv');
calDen = 2.71;      % density of calcite (g/cm^3)

modNo = 100000;             % no. of models to run
chAspRat = NaN(modNo,1);    % preallocation, descriptions below
forPor = NaN(modNo,1);
secChAd = NaN(modNo,1);
maxInWall = NaN(modNo,1);
axInOb = NaN(modNo,1);
forAspRat = NaN(modNo,1);
chCut = NaN(modNo,1);
forAxIn = NaN(modNo,1);
inchAx2 = NaN(modNo,1);
wallThReg = NaN(modNo,2);
axInOnt = NaN(modNo,1);
massReg = NaN(modNo,2);
modSSqR = NaN(modNo,1);
tempPIC = NaN(modNo,1);
tempCI = NaN(modNo,1);
chAx1 = cell(modNo,1);
chAx2 = cell(modNo,1);
chVol = cell(modNo,1);
chWallThick = cell(modNo,1);
chVolInner = cell(modNo,1);
newVol = cell(modNo,1);
newVolPor = cell(modNo,1);
newVolPorCut = cell(modNo,1);
forAx1 = cell(modNo,1);
forAx2 = cell(modNo,1);
cumVol = cell(modNo,1);
cumVolSec = cell(modNo,1);
orgVol = cell(modNo,1);
CInd1 = cell(modNo,1);
CInd2 = cell(modNo,1);
CInd3 = cell(modNo,1);
PICPOC = cell(modNo,1);
forVol = cell(modNo,1);
volRat = cell(modNo,1);

h = waitbar(0,'Running model...');
for j = 1:modNo
rEr = rand(13,1);

% measurements described in text
chAspRat(j) = 1.66*(rEr(1)*0.2+0.9);    % chamber max/min axes ratio
forPor(j) = 4.2*(rEr(3)*0.2+0.9);       % foram porosity (% empty space)
secChAd(j) = 0.67*(rEr(4)*0.2+0.9);     % secondary layers as a fraction of existing mass
maxInWall(j) = 20*(rEr(5)*0.2+0.9);     % maximum primary wall thickness
axInOb(j) = 1.19*(rEr(6)*0.2+0.9);      % observed increase in chamber ax1 rel. prev. (frac)
forAspRat(j) = 1.16*(rEr(13)*0.2+0.9);  % foram max/min axes ratio

% measurements approximated from SEMs
chCut(j) = 0.45*(rEr(7)*0.2+0.9);       % fraction of chamber that overlaps with previous
forAxIn(j) = 1.15*(rEr(8)*0.2+0.9);     % fraction increase in 1st chamber axis per chamber
inchAx2(j) = 0.005*(rEr(9)*0.2+0.9);    % initial chamber semi axis diameter (mm)
noCh = 18;                              % total number of chambers

% parameterised 
wallThReg(j,:) = [-60+(rEr(10)*80-40) 0.1*(rEr(11)*0.4+0.8)]; %%% logistic function parameters for wall thickness
wallTh = @(x,maxInWall,wallThReg) ...
    (maxInWall/100)/(1+exp(wallThReg(1).*(x-wallThReg(2)))).*100 + 0.5;
    % logistic relationship between wall thickness and spheroid major axis (x in mm, y in um)
chAxIn = @(x,axInOb,axInOnt,chN) x.*(axInOb+chN.*axInOnt);
    %%% increase in chamber ax1 relative to preceding chamber (x); chN is current chamber number
axInOnt(j) = 0;%0.003+(rEr(12)*0.012-0.006);     %%% change in axInOb with chamber (alternatively varies with ontogeny (commented out)

% preallocate matricies
chAx1{j} = NaN(noCh,1);        % chamber semi axis
chAx2{j} = NaN(noCh,1);        % chamber major axis
chVol{j} = NaN(noCh,1);        % outer chamber volume
chWallThick{j} = NaN(noCh,1);  % chamber wall thickness
chVolInner{j} = NaN(noCh,1);   % chamber inner volume (minus wall thickness)
newVol{j} = NaN(noCh,1);       % chamber wall volume
newVolPor{j} = NaN(noCh,1);    % as above, porosity corrected
newVolPorCut{j} = NaN(noCh,1); % as above, with chCut frac removed
forAx1{j} = NaN(noCh,1);       % foram major axis
forAx2{j} = NaN(noCh,1);       % foram  semi axis
cumVol{j} = NaN(noCh,1);       % cumulative volume
cumVolSec{j} = NaN(noCh,1);    % as above, including secondary layers
orgVol{j} = NaN(noCh,1);       % organic volume
PICPOC{j} = NaN(noCh,1);       % very approximate PIC/POC ratio
forVol{j} = NaN(noCh,1);       % approx. foram volume
for i = 1:noCh
    if i == 1    % 1st chamber, special case
        chAx2{j}(i) = inchAx2(j);
        chAx1{j}(i) = chAx2{j}(i)*chAspRat(j);
        chVol{j}(i) = 4/3*pi*chAx1{j}(i)*chAx2{j}(i)*chAx2{j}(i);   % chambers modelled as spheroids
        chWallThick{j}(i) = wallTh(chAx1{j}(i),maxInWall(j),wallThReg(j,:));
        chVolInner{j}(i) = 4/3*pi*(chAx1{j}(i)-chWallThick{j}(i)/1000)*...
            (chAx2{j}(i)-chWallThick{j}(i)/1000)*(chAx2{j}(i)-chWallThick{j}(i)/1000);
        newVol{j}(i) = chVol{j}(i)-chVolInner{j}(i);
        newVolPor{j}(i) = newVol{j}(i)*(1-forPor(j)/100);        
        forAx1{j}(i) = chAx1{j}(i)*2;
        forAx2{j}(i) = chAx2{j}(i)*2;
        cumVol{j}(i) = newVolPor{j}(i);   % not nec., to ease plotting only
        cumVolSec{j}(i) = newVolPor{j}(i);
        orgVol{j}(i) = chVolInner{j}(i);
    else
        chAx1{j}(i) = chAxIn(chAx1{j}(i-1),axInOb(j),axInOnt(j),i);
        chAx2{j}(i) = chAx1{j}(i)/chAspRat(j);
        chVol{j}(i) = 4/3*pi*chAx1{j}(i)*chAx2{j}(i)*chAx2{j}(i);
        chWallThick{j}(i) = wallTh(chAx1{j}(i),maxInWall(j),wallThReg(j,:));
        chVolInner{j}(i) = 4/3*pi*(chAx1{j}(i)-chWallThick{j}(i)/1000)*...
            (chAx2{j}(i)-chWallThick{j}(i)/1000)*(chAx2{j}(i)-chWallThick{j}(i)/1000);
        newVol{j}(i) = chVol{j}(i)-chVolInner{j}(i);
        newVolPor{j}(i) = newVol{j}(i)*(1-forPor(j)/100);
        newVolPorCut{j}(i) = newVolPor{j}(i)*(1-chCut(j));
        forAx1{j}(i) = forAx1{j}(i-1)*forAxIn(j);
        forAx2{j}(i) = forAx1{j}(i)/forAspRat(j);
        cumVol{j}(i) = cumVol{j}(i-1) + newVolPorCut{j}(i);
        cumVolSec{j}(i) = cumVol{j}(i-1)*secChAd(j)+cumVolSec{j}(i-1)+...
            newVolPorCut{j}(i);
        orgVol{j}(i) = sum(chVolInner{j}(1:i))*(1-chCut(j));
    end
end
axProd = forAx1{j}.*forAx2{j};    % product of axes
cumMass = cumVolSec{j}.*calDen.*1000;
CInd1{j} = (cumMass(2:size(cumMass,1))-cumMass(1:size(cumMass,1)-1))./...
    (axProd(2:size(axProd,1))-axProd(1:size(axProd,1)-1));
CInd2{j} = (cumMass(3:size(cumMass,1))-cumMass(1:size(cumMass,1)-2))./...
    (axProd(3:size(axProd,1))-axProd(1:size(axProd,1)-2));
CInd3{j} = (cumMass(4:size(cumMass,1))-cumMass(1:size(cumMass,1)-3))./...
    (axProd(4:size(axProd,1))-axProd(1:size(axProd,1)-3));
PICPOC{j} = cumMass./(orgVol{j}.*1200);

if sum(axProd>0.03)>5 && sum(axProd<0.1)>3  % only include models with >4 points in the range of our cultures
    massReg(j,:) = polyfit(axProd(axProd>0.03 & axProd<0.1),...
        cumMass(axProd>0.03 & axProd<0.1),1);   % axes area mass slope

    tempX = massSizeData(:,1).*massReg(j,1)+massReg(j,2);
    modSSqR(j) = nansum((tempX-massSizeData(:,2)).^2);     % sum square residuals
    [c,ind] = min(abs(axProd-0.1));
    tempPIC(j) = PICPOC{j}(ind);  % PICPOC for closest point to axes product of 0.1 (not used in main text)
    [c,ind] = min(abs(axProd-0.06));
    tempCI(j) = CInd2{j}(ind);  % CI at axesProd = 0.06
    for i = 1:size(chVol{j},1)
        if i==1
            forVol{j}(i) = chVol{j}(i);
        else
            forVol{j}(i) = chVol{j}(i)*(1-chCut(j)) + forVol{j}(i-1);        
        end
    end
    volRat{j} = (cumMass./calDen./1000)./forVol{j};
end
waitbar(j/modNo,h)
end
close(h)
clearvars c h 