
# coding: utf-8

# In[1]:



# Conditional Histograms for Boreal area of Variables conditioned to VCFF State
get_ipython().magic(u'matplotlib inline')
import matplotlib
#matplotlib.use('macosx')  # TkAgg Force mpl to use Tk backend
import matplotlib.pyplot as plt
from mpl_toolkits.basemap import Basemap, shiftgrid
import numpy as np
import seaborn as sns
import datetime
import netCDF4
import sys
import math 
import matplotlib.patches as mpatches
# needs gridspec
from matplotlib import gridspec
from matplotlib.colors import ListedColormap
import palettable 
# sys.path.append("/Users/Beniamino/Documents/OneDrive/MPI-M/iPython_Notebooks/Boreal_Area/") # Edited .zshrc profile with PYTHONPATH 
from pandas import DataFrame 
from collections import Counter
import pandas as pd

cmapbare = sns.light_palette("#332288", n_colors=5, reverse=False, as_cmap=True)
cmapsava = sns.light_palette("#44AA99", n_colors=5, reverse=False, as_cmap=True)
cmapsavab = sns.light_palette("#88CCEE", n_colors=5, reverse=False, as_cmap=True)
cmapfore = sns.light_palette("#117733", n_colors=5, reverse=False, as_cmap=True)

cmapfore_r = sns.light_palette("#117733", n_colors=5, reverse=True, as_cmap=True)
cmapbare_r = sns.light_palette("#332288", n_colors=5, reverse=True, as_cmap=True)
cmapsava_r = sns.light_palette("#44AA99", n_colors=5, reverse=True, as_cmap=True)
cmapsavab_r = sns.light_palette("#88CCEE", n_colors=5, reverse=True, as_cmap=True)

colbare = '#332288'
colsavab = '#88CCEE'
colsava = '#44AA99'
colfore = '#117733'

alt_colbare = '#999933'
alt_colsavab = '#CC6677' 
alt_colsavaf = '#AA4499'
alt_colfore = '#882255'


savabmap = ListedColormap(palettable.colorbrewer.diverging.PuOr_5_r.mpl_colors)
baremap = ListedColormap(palettable.colorbrewer.diverging.PuOr_5.mpl_colors)



# function to create the delimiters for the classification given the arrays of bare, savanna, forest
# it takes the second and second to last percentile and then divide interval in between them
def delimiters_generator(bare, savanna, forest, indexes = [1,2,3,4,5], intervals = 5):
    percentiles = [] # list that will contain all the 10th and 90th percentiles related to the variables from indexes 
    for i in indexes:
        percentiles_dummy = []
        percentiles_dummy.append(np.percentile(forest[:,i],90))
        percentiles_dummy.append(np.percentile(forest[:,i],10))
        percentiles_dummy.append(np.percentile(savanna[:,i],90))
        percentiles_dummy.append(np.percentile(savanna[:,i],10))
        percentiles_dummy.append(np.percentile(bare[:,i],90))
        percentiles_dummy.append(np.percentile(bare[:,i],10))
        percentiles_dummy = sorted(percentiles_dummy, key=float) # sort the list in ascending order
        percentiles.append(percentiles_dummy)
    delimiters = [np.linspace(percentiles[i][1], percentiles[i][4],intervals-1) for i in [0,1,2]]
    for j in [3,4]:
        first = np.nonzero(percentiles[j])[0][0]
        second = np.nonzero(percentiles[j])[0][-2]
        if (j==3): delimiters.append(np.array([percentiles[j][first]/2, percentiles[j][first], percentiles[j][second]]))
        else: delimiters.append(np.array([0.,percentiles[j][first]/2, percentiles[j][first], percentiles[j][second]]))

    return delimiters

# the classification algorithm 
def ea_west_russia_classifier(variables_array, delimiters):
    classified = np.zeros(shape = variables_array[:,0:3].shape)

    
    for i in range(classified.shape[0]):
        classified[i,1]=variables_array[i,-2] # lon
        classified[i,2]=variables_array[i,-1] # lat
        # using mean minimum temperature
        if (variables_array[i,1]<=delimiters[0][0]): 
            classified[i,0]=1
        elif (variables_array[i,1]<=delimiters[0][1]):
            classified[i,0]=2
        elif (variables_array[i,1]<=delimiters[0][2]):
            classified[i,0]=3
        elif (variables_array[i,1]<=delimiters[0][3]):
            classified[i,0]=4
        elif (variables_array[i,1]>delimiters[0][3]):
            classified[i,0]=5
        
        # using mean spring soil moisture
        if (variables_array[i,2]<=delimiters[1][0]):
            classified[i,0]+=0
        elif (variables_array[i,2]<=delimiters[1][1]):
            classified[i,0]+=5
        elif (variables_array[i,2]<=delimiters[1][2]):
            classified[i,0]+=10
        elif (variables_array[i,2]<=delimiters[1][3]):
            classified[i,0]+=15
        elif (variables_array[i,2]>delimiters[1][3]):
            classified[i,0]+=20
        
        # using mean annual rainfall
        if (variables_array[i,3]<=delimiters[2][0]):
            classified[i,0]+=0
        elif (variables_array[i,3]<=delimiters[2][1]):
            classified[i,0]+=25
        elif (variables_array[i,3]<=delimiters[2][2]):
            classified[i,0]+=50
        elif (variables_array[i,3]<=delimiters[2][3]):
            classified[i,0]+=75
        elif (variables_array[i,3]>delimiters[2][3]):
            classified[i,0]+=100

           
        # using permafrost zonation index
        if (variables_array[i,4]<=delimiters[3][0]):
            classified[i,0]+=0
        elif (variables_array[i,4]<=delimiters[3][1]):
            classified[i,0]+=125
        elif (variables_array[i,4]<=delimiters[3][2]):
            classified[i,0]+=250
        elif (variables_array[i,4]>delimiters[3][2]):
            classified[i,0]+=375
        
        # using soil texture
        # better put soil texture before fire, otherwise it will be impossible to check the fire as disturing agent
        if (np.any(variables_array[i,8]==[1,2,12])):
            classified[i,0]+=0. 
        elif (np.any(variables_array[i,8]==[3,4,5,6,7,8])):
            classified[i,0]+=1000. 
        elif (np.any(variables_array[i,8]==[9,10,11,13,14])):
            classified[i,0]+=2000.
        else:
            classified[i,0]+=3000. 

        
          # using fire frequency
        if (variables_array[i,5]<=delimiters[4][0]):
            classified[i,0]+=0
        elif (variables_array[i,5]<=delimiters[4][1]):
            classified[i,0]+=3864
        elif (variables_array[i,5]<=delimiters[4][2]):
            classified[i,0]+=3864*2
        elif (variables_array[i,5]<=delimiters[4][3]):
            classified[i,0]+=3864*3
        elif (variables_array[i,5]>delimiters[4][3]):
            classified[i,0]+=3864*4
 
            
            
    return classified







def generate_legend(fig,c_bare_2_bs, c_sava_2_bs, c_fore_2_fs, c_sava_2_fs, save_2_bs, save_2_sb, save_2_fs, save_2_sf, cmaps = [ListedColormap(palettable.colorbrewer.diverging.PuOr_5.mpl_colors), ListedColormap(palettable.colorbrewer.diverging.PuOr_5_r.mpl_colors), 'summer', 'winter'] ):
    un = [np.unique(c_bare_2_bs), np.unique(c_sava_2_bs), np.unique(c_fore_2_fs), np.unique(c_sava_2_fs)]

    #cmaps = [baremap, savabmap, 'summer', 'winter'] #['Reds_r', 'spring', 'summer', 'winter']
    rep = [[np.random.rand(1)[0] for elem in un[i]] for i in range(4)]
    rop = [[np.random.rand(1)[0] for elem in un[i]] for i in range(4)]
    ck = [plt.scatter(rep[i], rop[i], c=un[i], cmap=cmaps[i], s=500, label=rep[i]) for i in range(4)]#'terrain_r'

#patches = [mpatches.Patch(facecolor=plt.get(ck[2], 'facecolors')[i], label=labels[i]) for i in range(len(plt.get(ck[2], 'facecolors')))]
#patch = [mpatches.Patch(facecolor=plt.get(ck[2], 'facecolors')[0], label = 'test')]
#plt.legend(handles=patch, loc='lower left')
    plt.draw()
    ax1 = fig.add_subplot(111)

    col = []
    for j in range(4):
        col.append([plt.get(ck[j], 'facecolors')[i] for i in range(len(plt.get(ck[j], 'facecolors')))])
    col
    len_tot = 0
    for elem in col: 
        len_tot += len(elem)
    len_tot
    x = np.linspace(0, 1, 10)
    patches = []
    ind = 0
#temporary labels, fix them later
    s_1a = [np.unique(save_2_bs)[i] for i in range(len(np.unique(save_2_bs))) if (np.in1d(np.unique(save_2_bs),np.unique(c_bare_2_bs))[i])]
    s_2a = [np.unique(save_2_fs)[i] for i in range(len(np.unique(save_2_fs))) if (np.in1d(np.unique(save_2_fs),np.unique(c_fore_2_fs))[i])]
    
    s_1 = [np.unique(save_2_sb)[i] for i in range(len(np.unique(save_2_sb))) if (np.in1d(np.unique(save_2_sb),np.unique(c_sava_2_bs))[i])]
    s_2 = [np.unique(save_2_sf)[i] for i in range(len(np.unique(save_2_sf))) if (np.in1d(np.unique(save_2_sf),np.unique(c_sava_2_fs))[i])]
    lab = [str(i) for i in np.concatenate((s_1a, s_1, s_2a, s_2), axis=0)]
    labels = []
    for i in range(len(s_1a)):
        labels.append('Grassland/Open Woodland '+lab[i])
    for i in range(len(s_1)):
        labels.append('Open Woodland/Grassland '+lab[i+len(s_1a)])
    for i in range(len(s_2a)):
        labels.append('Forest/Open Woodland '+lab[i+len(s_1a)+len(s_1)])
    for i in range(len(s_2)):
        labels.append('Open Woodland/Forest '+lab[i+len(s_1a)+len(s_1)+len(s_2a)])
    for j in range(len(col)):
        for i in range(len(col[j])):
            plt.plot(x, np.random.rand(1) * x + np.random.rand(1), color = col[j][i], label='$y = {i}x + {i}$'.format(i=i))
            patches.append(mpatches.Patch(facecolor=col[j][i], label=labels[ind]))
            ind +=1
    plt.legend(handles = patches, loc='best')
    plt.draw()
    return patches

def setcolor(x, color): # for basemap plots-> color parallels and meridians
    for m in x:
         for t in x[m][1]:
             t.set_color(color)

# In[3]:

#from Boreal_Variables import bare_ea_west_russia as bare
#from Boreal_Variables import savanna_ea_west_russia as savanna
#from Boreal_Variables import forest_ea_west_russia as forest 

#from Boreal_Variables import bare_ea as bare
#from Boreal_Variables import savanna_ea as savanna
#from Boreal_Variables import forest_ea as forest 

from Boreal_Variables import bare_ea_west_russia as bare
from Boreal_Variables import savanna_ea_west_russia as savanna
from Boreal_Variables import forest_ea_west_russia as forest 



dataforr_ea_west_russia = np.loadtxt("/Users/Beniamino/Documents/OneDrive/MPI-M/iPython_Notebooks/Boreal_Area/boreal_ea_west_russia_database.txt") # columns=["VCFF", "MAR", "MASM", "Tmin", "PZI", "FF", "GDD0", "State", "Elev", "Lon", "Lat"]
columns=["VCFF", "MAR", "Mean_Spring_SM", "Mean_Tmin", "PZI", "FF", "GDD0", "PTD", "ST", "State","Elev", "Lon", "Lat" ]
dataframe_ea_west_russia = DataFrame(dataforr_ea_west_russia[:,0:13], columns=columns[0:13])

sns.set_style(style="white")


from Boreal_Variables import bare_ea_east as bare_tea_e
from Boreal_Variables import savanna_ea_east as savanna_tea_e
from Boreal_Variables import forest_ea_east as forest_tea_e

from Boreal_Variables import bare_ea_west_russia as bare_tea_wr
from Boreal_Variables import savanna_ea_west_russia as savanna_tea_wr
from Boreal_Variables import forest_ea_west_russia as forest_tea_wr

from Boreal_Variables import bare_ea_europe as bare_tea_eu
from Boreal_Variables import savanna_ea_europe as savanna_tea_eu
from Boreal_Variables import forest_ea_europe as forest_tea_eu

from Boreal_Variables import bare_na_east_update as bare_tna_e
from Boreal_Variables import savanna_na_east_update as savanna_tna_e
from Boreal_Variables import forest_na_east_update as forest_tna_e

from Boreal_Variables import bare_na_west_update as bare_tna_w
from Boreal_Variables import savanna_na_west_update as savanna_tna_w
from Boreal_Variables import forest_na_west_update as forest_tna_w


#from Boreal_Variables import bare_ea_east as bare
#from Boreal_Variables import savanna_ea_east as savanna
#from Boreal_Variables import forest_ea_east as forest 

#from Boreal_Variables import bare_ea as bare
#from Boreal_Variables import savanna_ea as savanna
#from Boreal_Variables import forest_ea as forest 


beat = len(bare_tea_e)+len(bare_tea_wr)+len(bare_tea_eu)
seat = len(savanna_tea_e)+len(savanna_tea_eu)+len(savanna_tea_wr)
feat = len(forest_tea_e)+len(forest_tea_eu)+len(forest_tea_wr)


# In[2]:


    
    # set delimiters and run classification # if you load the pickles, don't run this

# delimiters west_russia ea (18)
delimiters = delimiters_generator(bare, savanna, forest)

col_class = ["state", "lon", "lat"]
bare_classified = DataFrame(ea_west_russia_classifier(bare, delimiters), columns = col_class)
savanna_classified = DataFrame(ea_west_russia_classifier(savanna, delimiters), columns = col_class)
forest_classified = DataFrame(ea_west_russia_classifier(forest, delimiters), columns = col_class)

#bare_classified.to_pickle('/Users/Beniamino/Documents/OneDrive/MPI-M/iPython_Notebooks/Boreal_Area/Dataframes/bare_ea_west_russia_classified_with_SoilT.pkl')
#savanna_classified.to_pickle('/Users/Beniamino/Documents/OneDrive/MPI-M/iPython_Notebooks/Boreal_Area/Dataframes/savanna_ea_west_russia_classified_with_SoilT.pkl')
#forest_classified.to_pickle('/Users/Beniamino/Documents/OneDrive/MPI-M/iPython_Notebooks/Boreal_Area/Dataframes/forest_ea_west_russia_classified_with_SoilT.pkl')

# delimiters


# In[2]:

delimiters = delimiters_generator(bare, savanna, forest)
for elem in delimiters: print elem


# In[5]:

# load dataframes of classified
bare_classified = pd.read_pickle('/Users/Beniamino/Documents/OneDrive/MPI-M/iPython_Notebooks/Boreal_Area/Dataframes/bare_ea_west_russia_classified_with_SoilT.pkl')
savanna_classified = pd.read_pickle('/Users/Beniamino/Documents/OneDrive/MPI-M/iPython_Notebooks/Boreal_Area/Dataframes/savanna_ea_west_russia_classified_with_SoilT.pkl')
forest_classified = pd.read_pickle('/Users/Beniamino/Documents/OneDrive/MPI-M/iPython_Notebooks/Boreal_Area/Dataframes/forest_ea_west_russia_classified_with_SoilT.pkl')

# count the intersecting values with at least a minimum amount of repetitions
sb0count, sbcount = [], [] # counters for savanna-bare
sf0count, sfcount = [], [] # counters for savanna-forest
b0count, bcount = [], [] # counters for bare
f0count, fcount = [], [] # counters for forest

index_0_bs, save_0_bs = [], [] # index to eliminate or keep of elements which are in the intersections and appear a minimum amount of times
index_1_sb, save_1_sb = [], [] # for all variables are the same (0), all variables are the same except fire for forest and bare (2)
index_2_bs, save_2_bs = [], [] # all the variables are the same except fire for savanna (1)   
index_0_fs, save_0_fs = [], [] # [sf means savanna fixed, forest disturbed and vice versa, except in the 0 case - and the intersection is between forest and savanna]
index_1_sf, save_1_sf = [], []
index_2_fs, save_2_fs = [], []

minvalue_b, minvalue_s, minvalue_f = int(0.015*len(bare)), int(0.015*len(savanna)), int(0.015*len(forest)) # min values of repetitions for states
print minvalue_b, minvalue_s, minvalue_f

#minvalue_b, minvalue_s, minvalue_f = 1,1,1
fire_subtracter = 3864 # the value for fire in the classification 
template2 = "{0:18}|{1:7}|{2:12}|{3:5}|{4:12}|{5:13}" # template for printing function 
for st_number in np.unique(bare_classified["state"]): # loop through unique elements of bare_classified
    b0count.append(Counter(bare_classified["state"])[st_number]) # count repetitions of each element in bare
    sb0count.append(Counter(savanna_classified["state"])[st_number]) # and in savanna
    bc, sb = [], []
    for subtract_mult_bare in range(1,4): # loop in the possible bins for fire
        bc.append(Counter(bare_classified["state"]-fire_subtracter*subtract_mult_bare)[st_number]) # count repetitions
        sb.append(Counter(savanna_classified["state"]-fire_subtracter*subtract_mult_bare)[st_number])
    bcount.append(bc)
    sbcount.append(sb)
        #print bcount #l'intersezione deve anche essere lista

        
        
for i in range(len(b0count)): # loop number of through counted elements
    if (b0count[i]>=10*sb0count[i] or sb0count[i]>=10*b0count[i]): index_0_bs.append(i) # if one counter is at least 10folds the other, discard
    elif (b0count[i]>minvalue_b and sb0count[i]>minvalue_s): # if both counters are above thresholds, save the corresponding classified state 
        print template2.format("bare/op wood state", np.unique(bare_classified["state"])[i], "b count", b0count[i], "op wo count", sb0count[i])
        save_0_bs.append(np.unique(bare_classified["state"])[i]) # the saved classified states in the case where all variables are the same
    else: index_0_bs.append(i)

for i in range(len(b0count)): # same as previous loop
    if (sb0count[i]>minvalue_s and (np.any(np.array(bcount[i])>minvalue_b))): # counts if the standard savanna counter and any one of the disturbed ones are > thresholds
        print template2.format("op wood state", np.unique(bare_classified["state"])[i], "op wo count", sb0count[i], "b count", bcount[i])
        save_1_sb.append(np.unique(bare_classified["state"])[i]) # save the savab fixed and bare disturbed states 
    else: index_1_sb.append(i)
        
for i in range(len(b0count)): # same as previous, but bare is fixed and savanna is fire disturbed
    if (np.all(b0count[i]>=10*np.array(sbcount[i])) or np.any(np.array(sbcount[i])>=10*(b0count[i]+1))): index_2_bs.append(i)
    elif (b0count[i]>minvalue_b and (np.any(np.array(sbcount[i])>minvalue_s))):
        print template2.format("bare state", np.unique(bare_classified["state"])[i], "b count", b0count[i], "op wo count", sbcount[i])
        save_2_bs.append(np.unique(bare_classified["state"])[i]) # bare fixed and savab disturbed
    else: index_2_bs.append(i)
        
print " "          
        
# same as the previous loops, but this time between savanna and forest states     
for st_number in np.unique(forest_classified["state"]):
    f0count.append(Counter(forest_classified["state"])[st_number])
    sf0count.append(Counter(savanna_classified["state"])[st_number])
    fc, sf = [], []
    for subtract_mult_fore in range(1,4):
        fc.append(Counter(forest_classified["state"]-fire_subtracter*subtract_mult_fore)[st_number])
        sf.append(Counter(savanna_classified["state"]-fire_subtracter*subtract_mult_fore)[st_number])
    fcount.append(fc)
    sfcount.append(sf)
    
        
for i in range(len(f0count)):
    if (f0count[i]>=10*sf0count[i] or sf0count[i]>=10*f0count[i]): index_0_fs.append(i)
    elif (f0count[i]>minvalue_f and sf0count[i]>minvalue_s):
        print template2.format("fore/op wood state", np.unique(forest_classified["state"])[i], "f count", f0count[i], "op wo count", sf0count[i])
        save_0_fs.append(np.unique(forest_classified["state"])[i])
    else: index_0_fs.append(i)

for i in range(len(f0count)):
      
    #if (np.any(np.array(bcount[i])>=10*sb0count[i]) or np.any(sb0count[i]>=10*np.array(b0count[i]))): index_1_sf.append(i)
    if (sf0count[i]>minvalue_s and (np.any(np.array(fcount[i])>minvalue_f))):
        print template2.format("op wood state", np.unique(forest_classified["state"])[i], "op wo count", sf0count[i], "f count", fcount[i])
        save_1_sf.append(np.unique(forest_classified["state"])[i])
    else: index_1_sf.append(i)
        
for i in range(len(f0count)):
      
    #if (bcount[i]>=10*sb0count[i] or sb0count[i]>=10*b0count[i]): index_0.append(i)
    if (f0count[i]>minvalue_f and (np.any(np.array(sfcount[i])>minvalue_s))):
        print template2.format("forest state", np.unique(forest_classified["state"])[i], "f count", f0count[i], "op wo count", sfcount[i])
        save_2_fs.append(np.unique(forest_classified["state"])[i])
    else: index_2_fs.append(i)
    

    
## here the indexes contain the positions of elements in the unique vectors of the classified states  that should be elimited in the mask
# to get the actual element you should check if the element corresponds to a certain state which corresponds to a certain ordered element from the
# indexes 
# so to do so you need to save the state that you don't want to erase (because it's faster this way) and then
# create the masks by looking at which elements of the original _classified are also present in the filtered save_ 

# print results: case - state - type of counter - count - type of counter - count


# In[6]:

# masks for where all the datasets are used for classification and I cannot separate certains states
# let's create the masks : 4 level_0 masks (1 bare, 1 savab, 1 savaf, 1 fore) and corresponding lonlat masks

mask_bare_0_bs = np.in1d(bare_classified['state'],save_0_bs) # create mask of intersection
mask_sava_0_bs = np.in1d(savanna_classified['state'],save_0_bs) # keeps the element of classified that are in the save vector
mask_sava_0_fs = np.in1d(savanna_classified['state'],save_0_fs)
mask_fore_0_fs = np.in1d(forest_classified['state'],save_0_fs)


c_bare_0_bs = np.ma.masked_array(bare_classified['state'], ~mask_bare_0_bs) #apply inverse mask
lon_bare_0_bs = np.ma.masked_array(bare_classified['lon'], ~mask_bare_0_bs) # creates a masked array same as the classified but according to the mask
lat_bare_0_bs = np.ma.masked_array(bare_classified['lat'], ~mask_bare_0_bs)

c_sava_0_bs = np.ma.masked_array(savanna_classified['state'], ~mask_sava_0_bs) #apply inverse mask
lon_sava_0_bs = np.ma.masked_array(savanna_classified['lon'], ~mask_sava_0_bs)
lat_sava_0_bs = np.ma.masked_array(savanna_classified['lat'], ~mask_sava_0_bs)

c_fore_0_fs = np.ma.masked_array(forest_classified['state'], ~mask_fore_0_fs) #apply inverse mask
lon_fore_0_fs = np.ma.masked_array(forest_classified['lon'], ~mask_fore_0_fs)
lat_fore_0_fs = np.ma.masked_array(forest_classified['lat'], ~mask_fore_0_fs)

c_sava_0_fs = np.ma.masked_array(savanna_classified['state'], ~mask_sava_0_fs) #apply inverse mask
lon_sava_0_fs = np.ma.masked_array(savanna_classified['lon'], ~mask_sava_0_fs)
lat_sava_0_fs = np.ma.masked_array(savanna_classified['lat'], ~mask_sava_0_fs)


# masks for fire as disturbance
# let's create the 8 masks : 
# 1 for bare fixed and 1 bare fire disturbed
# 1 for savab fixed and 1 savab disturbed
# 1 for savaf fixed and 1 savaf disturbed
# 1 for fore fixed and 1 fore disturbed 

# create mask of intersection - bare fixed
mask_bare_2_bs = np.in1d(bare_classified['state'],save_2_bs)  # 2 = bare fixed for bare
save_2_sb = np.ravel([elem+fire_subtracter*np.array((1,2,3)) for elem in save_2_bs]) # consider all elements modulo firesubtracter
mask_sava_2_bs = np.in1d(savanna_classified['state'],save_2_sb)  # 2 = bare fixed for sava
# create the inverse mask and the mask for lon lat from the one just created - bare
c_bare_2_bs = np.ma.masked_array(bare_classified['state'], ~mask_bare_2_bs) #apply inverse mask
lon_bare_2_bs = np.ma.masked_array(bare_classified['lon'], ~mask_bare_2_bs)
lat_bare_2_bs = np.ma.masked_array(bare_classified['lat'], ~mask_bare_2_bs)
# create the inverse mask and the mask for lon lat from the one just created - savanna
c_sava_2_bs = np.ma.masked_array(savanna_classified['state'], ~mask_sava_2_bs) #apply inverse mask
lon_sava_2_bs = np.ma.masked_array(savanna_classified['lon'], ~mask_sava_2_bs)
lat_sava_2_bs = np.ma.masked_array(savanna_classified['lat'], ~mask_sava_2_bs)

# create mask of intersection - fore fixed 
mask_fore_2_fs = np.in1d(forest_classified['state'],save_2_fs)  # 2 = fore fixed
save_2_sf = np.ravel([elem+fire_subtracter*np.array((1,2,3)) for elem in save_2_fs])
mask_sava_2_fs = np.in1d(savanna_classified['state'],save_2_sf)  # 2 = fore fixed
# create the inverse mask and the mask for lon lat from the one just created - forest
c_fore_2_fs = np.ma.masked_array(forest_classified['state'], ~mask_fore_2_fs) #apply inverse mask
lon_fore_2_fs = np.ma.masked_array(forest_classified['lon'], ~mask_fore_2_fs)
lat_fore_2_fs = np.ma.masked_array(forest_classified['lat'], ~mask_fore_2_fs)
# create the inverse mask and the mask for lon lat from the one just created - savanna
c_sava_2_fs = np.ma.masked_array(savanna_classified['state'], ~mask_sava_2_fs) #apply inverse mask
lon_sava_2_fs = np.ma.masked_array(savanna_classified['lon'], ~mask_sava_2_fs)
lat_sava_2_fs = np.ma.masked_array(savanna_classified['lat'], ~mask_sava_2_fs)

# create mask of intersection - savab fixed
mask_sava_1_sb = np.in1d(savanna_classified['state'],save_1_sb)  # 1 = sava fixed
save_1_bs = np.ravel([elem+fire_subtracter*np.array((1,2,3)) for elem in save_1_sb])
mask_bare_1_sb = np.in1d(bare_classified['state'],save_1_bs)  # 1 = sava fixed
# create the inverse mask and the mask for lon lat from the one just created - bare
c_bare_1_sb = np.ma.masked_array(bare_classified['state'], ~mask_bare_1_sb) #apply inverse mask
lon_bare_1_sb = np.ma.masked_array(bare_classified['lon'], ~mask_bare_1_sb)
lat_bare_1_sb = np.ma.masked_array(bare_classified['lat'], ~mask_bare_1_sb)
# create the inverse mask and the mask for lon lat from the one just created - savanna
c_sava_1_sb = np.ma.masked_array(savanna_classified['state'], ~mask_sava_1_sb) #apply inverse mask
lon_sava_1_sb = np.ma.masked_array(savanna_classified['lon'], ~mask_sava_1_sb)
lat_sava_1_sb = np.ma.masked_array(savanna_classified['lat'], ~mask_sava_1_sb)

# create mask of intersection - savaf fixed
mask_sava_1_sf = np.in1d(savanna_classified['state'],save_1_sf)  # 1 = sava fixed
save_1_fs = np.ravel([elem+fire_subtracter*np.array((1,2,3)) for elem in save_1_sf])
mask_fore_1_sf = np.in1d(forest_classified['state'],save_1_fs)  # 1 = sava fixed
# create the inverse mask and the mask for lon lat from the one just created - forest
c_fore_1_sf = np.ma.masked_array(forest_classified['state'], ~mask_fore_1_sf) #apply inverse mask
lon_fore_1_sf = np.ma.masked_array(forest_classified['lon'], ~mask_fore_1_sf)
lat_fore_1_sf = np.ma.masked_array(forest_classified['lat'], ~mask_fore_1_sf)
# create the inverse mask and the mask for lon lat from the one just created - savanna
c_sava_1_sf = np.ma.masked_array(savanna_classified['state'], ~mask_sava_1_sf) #apply inverse mask
lon_sava_1_sf = np.ma.masked_array(savanna_classified['lon'], ~mask_sava_1_sf)
lat_sava_1_sf = np.ma.masked_array(savanna_classified['lat'], ~mask_sava_1_sf)

# create masks to disentangle the effects (remove duplicates)
mask_distufore = np.in1d(c_fore_0_fs,save_2_fs)
c_distufore = np.ma.masked_array(c_fore_0_fs, mask_distufore) #apply mask
lon_distufore = np.ma.masked_array(lon_fore_0_fs, mask_distufore)
lat_distufore = np.ma.masked_array(lat_fore_0_fs, mask_distufore)

mask_distusavaf = np.in1d(c_sava_0_fs,save_2_sf)
c_distusavaf = np.ma.masked_array(c_sava_0_fs, mask_distusavaf) #apply mask
lon_distusavaf = np.ma.masked_array(lon_sava_0_fs, mask_distusavaf)
lat_distusavaf = np.ma.masked_array(lat_sava_0_fs, mask_distusavaf)

mask_distufore2 = np.in1d(c_distufore,save_1_fs)
c_distufore2 = np.ma.masked_array(c_distufore, mask_distufore2) #apply mask
lon_distufore2 = np.ma.masked_array(lon_distufore, mask_distufore2)
lat_distufore2 = np.ma.masked_array(lat_distufore, mask_distufore2)

mask_distusavaf2 = np.in1d(c_distusavaf,save_1_sf)
c_distusavaf2 = np.ma.masked_array(c_distusavaf, mask_distusavaf2) #apply mask
lon_distusavaf2 = np.ma.masked_array(lon_distusavaf, mask_distusavaf2)
lat_distusavaf2 = np.ma.masked_array(lat_distusavaf, mask_distusavaf2)


mask_distubare = np.in1d(c_bare_0_bs,save_1_bs)
c_distubare = np.ma.masked_array(c_bare_0_bs, mask_distubare) #apply mask
lon_distubare = np.ma.masked_array(lon_bare_0_bs, mask_distubare)
lat_distubare = np.ma.masked_array(lat_bare_0_bs, mask_distubare)

mask_distusavab = np.in1d(c_sava_0_bs,save_1_sb)
c_distusavab = np.ma.masked_array(c_sava_0_bs, mask_distusavab) #apply mask
lon_distusavab = np.ma.masked_array(lon_sava_0_bs, mask_distusavab)
lat_distusavab = np.ma.masked_array(lat_sava_0_bs, mask_distusavab)

mask_distubare2 = np.in1d(c_distubare,save_2_bs)
c_distubare2 = np.ma.masked_array(c_distubare, mask_distubare2) #apply mask
lon_distubare2 = np.ma.masked_array(lon_distubare, mask_distubare2)
lat_distubare2 = np.ma.masked_array(lat_distubare, mask_distubare2)

mask_distusavab2 = np.in1d(c_distusavab,save_2_sb)
c_distusavab2 = np.ma.masked_array(c_distusavab, mask_distusavab2) #apply mask
lon_distusavab2 = np.ma.masked_array(lon_distusavab, mask_distusavab2)
lat_distusavab2 = np.ma.masked_array(lat_distusavab, mask_distusavab2)
# need to mask also the lon lat arrays



# In[5]:

fig = plt.figure(figsize=(12,12), facecolor='white')
#patches = generate_legend(fig,c_bare_1_sb, c_sava_1_sb, c_fore_2_fs, c_sava_2_fs, save_1_bs,save_1_sb,  save_2_fs, save_2_sf, cmaps=[cmapbare, cmapsava, cmapfore, 'winter'])

ax = fig.add_subplot(111)
ax.set_title("Fire Disturbed Tree Cover States over Northern West Russia", fontsize=18)
#m = Basemap(projection='ortho',lon_0=-125,lat_0=60,resolution='l') #West
m = Basemap(projection='ortho',lon_0=50.,lat_0=60,resolution='l') #East
width = m.urcrnrx - m.llcrnrx
height = m.urcrnry - m.llcrnry
# let's zoom in the plot
coef = 0.45
width = width*coef
height = height*coef
m1 = Basemap(projection='ortho',lon_0=50.,lat_0=60.,resolution='l',
            llcrnrx=-0.5*width,llcrnry=-0.5*height,urcrnrx=0.5*width,urcrnry=0.5*height)
par = m1.drawparallels(np.arange(-80.,81.,20.),labels=[True,False,False,False], color='black', fontsize=14)
mer = m1.drawmeridians(np.arange(-180.,181.,20.),labels=[False,False,False,True], color='black', fontsize=14)
m1.drawmapboundary(fill_color='black')
m1.drawcoastlines(linewidth=1.5)
m1.fillcontinents(color='white',lake_color='black')

# set the color of the parallel and meridian lines
setcolor(par,'black')
setcolor(mer,'black')



#bare1
m1_sub_lons, m1_sub_lats = m1(lon_bare_1_sb,lat_bare_1_sb)
cbs = m1.scatter(m1_sub_lons,m1_sub_lats, marker='h', c=colbare,                 alpha=0.8, s=50, zorder=3, label = 'Grassland / Open Woodland')
#bare2
m1_sub_lons, m1_sub_lats = m1(lon_bare_2_bs,lat_bare_2_bs)
cbs = m1.scatter(m1_sub_lons,m1_sub_lats, marker='h', c=colbare,                 alpha=0.8, s=50, zorder=3)
#savab1
m1_sub_lons, m1_sub_lats = m1(lon_sava_1_sb,lat_sava_1_sb)
csb = m1.scatter(m1_sub_lons,m1_sub_lats, marker='h', c=colsavab,                 alpha=0.8, s=50, zorder=4, label = 'Open Woodland / Grassland')
#savab2
m1_sub_lons, m1_sub_lats = m1(lon_sava_2_bs,lat_sava_2_bs)
csb = m1.scatter(m1_sub_lons,m1_sub_lats, marker='h', c=colsavab,                 alpha=0.8, s=50, zorder=4)
#savaf1
m1_sub_lons, m1_sub_lats = m1(lon_sava_1_sf,lat_sava_1_sf)
csf = m1.scatter(m1_sub_lons,m1_sub_lats, marker='h', c=colsava,                 alpha=0.8, s=50, zorder=4, label = 'Open Woodland / Forest')
#savaf2
m1_sub_lons, m1_sub_lats = m1(lon_sava_2_fs,lat_sava_2_fs)
csf = m1.scatter(m1_sub_lons,m1_sub_lats, marker='h', c=colsava,                 alpha=0.8, s=50, zorder=4)
#fore1
m1_sub_lons, m1_sub_lats = m1(lon_fore_1_sf,lat_fore_1_sf)
cfs = m1.scatter(m1_sub_lons,m1_sub_lats, marker='h', c=colfore,                 alpha=0.8, s=50, zorder=4, label = 'Forest / Open Woodland')
#fore2
m1_sub_lons, m1_sub_lats = m1(lon_fore_2_fs,lat_fore_2_fs)
cfs = m1.scatter(m1_sub_lons,m1_sub_lats, marker='h', c=colfore,                 alpha=0.8, s=50, zorder=4)

plt.legend(bbox_to_anchor=(0.5, -0.03), ncol = 2, loc='upper center', markerscale = 2, fontsize = 14, fancybox = True, frameon=True)
#legend = plt.legend(handles=patches, loc='upper center', bbox_to_anchor=(0.5, -0.03), ncol = 3, fontsize = 14, fancybox = True, frameon=True)


plt.savefig('/Users/Beniamino/Documents/OneDrive/MPI-M/iPython_Notebooks/Pic/Meeting_Victor/Alternative_States/New_Classification_with_SoilTexture_and_Disturbances/Nea_West_Russia_Fire_Disturbed_States_002.pdf', dpi=600)


plt.show()


# In[6]:

# plot it [white plot] # states where all variables are the same but without repetition with fire stuff
fig = plt.figure(figsize=(12,12), facecolor='white')
# use generative function for legend, requires a figure, 4 data_arrays, 4 lists for legend entries, optionally list of 4 cmaps
#el_bare = [el for el in np.unique(c_distubare2) if np.ma.is_masked(el)==False]
#el_savab = [el for el in np.unique(c_distusavab2) if np.ma.is_masked(el)==False]
#el_savaf = [el for el in np.unique(c_distusavaf2) if np.ma.is_masked(el)==False]
#el_fore = [el for el in np.unique(c_distufore2) if np.ma.is_masked(el)==False]
#patches = generate_legend(fig,c_distubare2, c_distusavab2, c_distufore2, c_distusavaf2, el_bare, el_savab, el_fore, el_savaf, cmaps=[cmapbare_r, cmapsavab_r, cmapfore_r, cmapsava_r])
# create ax and set title
ax = fig.add_subplot(111)
ax.set_title("Same Variables Tree Cover States over Northern East Eurasia", fontsize=18)
#m = Basemap(projection='ortho',lon_0=-125,lat_0=60,resolution='l') #West
m = Basemap(projection='ortho',lon_0=50.,lat_0=60,resolution='l') #East
width = m.urcrnrx - m.llcrnrx
height = m.urcrnry - m.llcrnry
# let's zoom in the plot
coef = 0.45
width = width*coef
height = height*coef
m1 = Basemap(projection='ortho',lon_0=50.,lat_0=60.,resolution='l',
            llcrnrx=-0.5*width,llcrnry=-0.5*height,urcrnrx=0.5*width,urcrnry=0.5*height)
# map extra features
par = m1.drawparallels(np.arange(-80.,81.,20.),labels=[True,False,False,False], color='black', fontsize=14)
mer = m1.drawmeridians(np.arange(-180.,181.,20.),labels=[False,False,False,True], color='black', fontsize=14)
m1.drawmapboundary(fill_color='black')
m1.drawcoastlines(linewidth=1.5)
m1.fillcontinents(color='white',lake_color='black')

# set the color of the parallel and meridian lines
setcolor(par,'black')
setcolor(mer,'black')

#bare
m1_sub_lons, m1_sub_lats = m1(lon_distubare2,lat_distubare2) # convert lon lat to basemap coordinates
cbs = m1.scatter(m1_sub_lons,m1_sub_lats, marker='h', c=alt_colbare,                 alpha=0.8, s=50, zorder=3, label = 'Grassland / Open Woodland')
#m1.contourf(m1_sub_lons,m1_sub_lats, c_bare_0_bs,cmap=baremap, tri = True, alpha=1, s=100, zorder=6)

#savab
m1_sub_lons, m1_sub_lats = m1(lon_distusavab2,lat_distusavab2)
csb = m1.scatter(m1_sub_lons,m1_sub_lats, marker='h', c=alt_colsavab,                 alpha=1, s=50, zorder=4, label = "Open Woodland / Grassland")
#m1.contourf(m1_sub_lons,m1_sub_lats, c_sava_0_bs,cmap=savabmap, tri = True, alpha=0.8, s=50, zorder=6)

#savaf
m1_sub_lons, m1_sub_lats = m1(lon_distusavaf2,lat_distusavaf2)
csf = m1.scatter(m1_sub_lons,m1_sub_lats, marker='h', c=alt_colsavaf,                 alpha=0.8, s=50, zorder=4, label = "Open Woodland / Forest")


#fore
m1_sub_lons, m1_sub_lats = m1(lon_distufore2,lat_distufore2)
cfs = m1.scatter(m1_sub_lons,m1_sub_lats, marker='h', c=alt_colfore,                 alpha=0.8, s=50, zorder=4, label = "Forest / Open Woodland")

legend = plt.legend(loc='upper center', bbox_to_anchor=(0.5, -0.03), markerscale = 2, ncol = 2, fontsize = 14, fancybox = True, frameon=True)
plt.savefig('/Users/Beniamino/Documents/OneDrive/MPI-M/iPython_Notebooks/Pic/Meeting_Victor/Alternative_States/New_Classification_with_SoilTexture_and_Disturbances/Nea_West_Russia_Equivalent_States_001.pdf', dpi=600)

plt.show()

# plot it [white plot] # states where all variables are the same but without repetition with fire stuff
fig = plt.figure(figsize=(12,12), facecolor='white')
# use generative function for legend, requires a figure, 4 data_arrays, 4 lists for legend entries, optionally list of 4 cmaps
#el_bare = [el for el in np.unique(c_distubare2) if np.ma.is_masked(el)==False]
#el_savab = [el for el in np.unique(c_distusavab2) if np.ma.is_masked(el)==False]
#el_savaf = [el for el in np.unique(c_distusavaf2) if np.ma.is_masked(el)==False]
#el_fore = [el for el in np.unique(c_distufore2) if np.ma.is_masked(el)==False]
#patches = generate_legend(fig,c_distubare2, c_distusavab2, c_distufore2, c_distusavaf2, el_bare, el_savab, el_fore, el_savaf, cmaps=[cmapbare_r, cmapsavab_r, cmapfore_r, cmapsava_r])
# create ax and set title
ax = fig.add_subplot(111)
ax.set_title("Same Variables Tree Cover States over Northern East Eurasia", fontsize=18)
#m = Basemap(projection='ortho',lon_0=-125,lat_0=60,resolution='l') #West
m = Basemap(projection='ortho',lon_0=50.,lat_0=60,resolution='l') #East
width = m.urcrnrx - m.llcrnrx
height = m.urcrnry - m.llcrnry
# let's zoom in the plot
coef = 0.45
width = width*coef
height = height*coef
m1 = Basemap(projection='ortho',lon_0=50.,lat_0=60.,resolution='l',
            llcrnrx=-0.5*width,llcrnry=-0.5*height,urcrnrx=0.5*width,urcrnry=0.5*height) # same as previous but with new extension
# map extra features
par = m1.drawparallels(np.arange(-80.,81.,20.),labels=[True,False,False,False], color='black', fontsize=14)
mer = m1.drawmeridians(np.arange(-180.,181.,20.),labels=[False,False,False,True], color='black', fontsize=14)
m1.drawmapboundary(fill_color='black')
m1.drawcoastlines(linewidth=1.5)
m1.fillcontinents(color='white',lake_color='black')

# set the color of the parallel and meridian lines
setcolor(par,'black')
setcolor(mer,'black')

#bare
m1_sub_lons, m1_sub_lats = m1(lon_distubare2,lat_distubare2) # convert lon lat to basemap coordinates
cbs = m1.scatter(m1_sub_lons,m1_sub_lats, marker='h', c=colbare,                 alpha=0.8, s=50, zorder=3, label = 'Grassland / Open Woodland')
#m1.contourf(m1_sub_lons,m1_sub_lats, c_bare_0_bs,cmap=baremap, tri = True, alpha=1, s=100, zorder=6)

#savab
m1_sub_lons, m1_sub_lats = m1(lon_distusavab2,lat_distusavab2)
csb = m1.scatter(m1_sub_lons,m1_sub_lats, marker='h', c=colsavab,                 alpha=1, s=50, zorder=4, label = "Open Woodland / Grassland")
#m1.contourf(m1_sub_lons,m1_sub_lats, c_sava_0_bs,cmap=savabmap, tri = True, alpha=0.8, s=50, zorder=6)

#savaf
m1_sub_lons, m1_sub_lats = m1(lon_distusavaf2,lat_distusavaf2)
csf = m1.scatter(m1_sub_lons,m1_sub_lats, marker='h', c=colsava,                 alpha=0.8, s=50, zorder=4, label = "Open Woodland / Forest")


#fore
m1_sub_lons, m1_sub_lats = m1(lon_distufore2,lat_distufore2)
cfs = m1.scatter(m1_sub_lons,m1_sub_lats, marker='h', c=colfore,                 alpha=0.8, s=50, zorder=4, label = "Forest / Open Woodland")

legend = plt.legend(loc='upper center', bbox_to_anchor=(0.5, -0.03), markerscale = 2, ncol = 2, fontsize = 14, fancybox = True, frameon=True)



plt.show()


# In[7]:

fig = plt.figure(figsize=(15,10), facecolor='white')
#patches = generate_legend(fig,c_bare_1_sb, c_sava_1_sb, c_fore_2_fs, c_sava_2_fs, save_1_bs,save_1_sb,  save_2_fs, save_2_sf, cmaps=[cmapbare, cmapsava, cmapfore, 'winter'])

ax = fig.add_subplot(111)
ax.set_title("Possible Alternative Tree Cover States over Northern West Eurasia", fontsize=18)
#m = Basemap(projection='ortho',lon_0=-125,lat_0=60,resolution='l') #West
m = Basemap(projection='ortho',lon_0=50.,lat_0=60,resolution='l') #East
width = m.urcrnrx - m.llcrnrx
height = m.urcrnry - m.llcrnry
# let's zoom in the plot
coef = 0.45
width = width*coef
height = height*coef
m1 = Basemap(projection='ortho',lon_0=50.,lat_0=60.,resolution='l',
            llcrnrx=-0.5*width,llcrnry=-0.5*height,urcrnrx=0.5*width,urcrnry=0.5*height) # same as previous but with new extension
# map extra features
par = m1.drawparallels(np.arange(-80.,81.,20.),labels=[True,False,False,False], color='black', fontsize=14)
mer = m1.drawmeridians(np.arange(-180.,181.,20.),labels=[False,False,False,True], color='black', fontsize=14)
m1.drawmapboundary(fill_color='black')
m1.drawcoastlines(linewidth=1.5)
m1.fillcontinents(color='white',lake_color='black')

# set the color of the parallel and meridian lines
setcolor(par,'black')
setcolor(mer,'black')

#bare1
m1_sub_lons, m1_sub_lats = m1(lon_bare_1_sb,lat_bare_1_sb)
cbs = m1.scatter(m1_sub_lons,m1_sub_lats, marker='h', c=colbare,                 alpha=0.8, s=50, zorder=3, label = 'Grassland / Open Woodland')
#bare2
m1_sub_lons, m1_sub_lats = m1(lon_bare_2_bs,lat_bare_2_bs)
cbs = m1.scatter(m1_sub_lons,m1_sub_lats, marker='h', c=colbare,                 alpha=0.8, s=50, zorder=3)
#savab1
m1_sub_lons, m1_sub_lats = m1(lon_sava_1_sb,lat_sava_1_sb)
csb = m1.scatter(m1_sub_lons,m1_sub_lats, marker='h', c=colsavab,                 alpha=0.8, s=50, zorder=4, label = 'Open Woodland / Grassland')
#savab2
m1_sub_lons, m1_sub_lats = m1(lon_sava_2_bs,lat_sava_2_bs)
csb = m1.scatter(m1_sub_lons,m1_sub_lats, marker='h', c=colsavab,                 alpha=0.8, s=50, zorder=4)
#savaf1
m1_sub_lons, m1_sub_lats = m1(lon_sava_1_sf,lat_sava_1_sf)
csf = m1.scatter(m1_sub_lons,m1_sub_lats, marker='h', c=colsava,                 alpha=0.8, s=50, zorder=4, label = 'Open Woodland / Forest')
#savaf2
m1_sub_lons, m1_sub_lats = m1(lon_sava_2_fs,lat_sava_2_fs)
csf = m1.scatter(m1_sub_lons,m1_sub_lats, marker='h', c=colsava,                 alpha=0.8, s=50, zorder=4)
#fore1
m1_sub_lons, m1_sub_lats = m1(lon_fore_1_sf,lat_fore_1_sf)
cfs = m1.scatter(m1_sub_lons,m1_sub_lats, marker='h', c=colfore,                 alpha=0.8, s=50, zorder=4, label = 'Forest / Open Woodland')
#fore2
m1_sub_lons, m1_sub_lats = m1(lon_fore_2_fs,lat_fore_2_fs)
cfs = m1.scatter(m1_sub_lons,m1_sub_lats, marker='h', c=colfore,                 alpha=0.8, s=50, zorder=4)


# not fire disturbed
#bare
m1_sub_lons, m1_sub_lats = m1(lon_distubare2,lat_distubare2) # convert lon lat to basemap coordinates
cbs2 = m1.scatter(m1_sub_lons,m1_sub_lats, marker='h', c=alt_colbare,                 alpha=0.8, s=50, zorder=3, label = 'Grassland / Open Woodland')
#m1.contourf(m1_sub_lons,m1_sub_lats, c_bare_0_bs,cmap=baremap, tri = True, alpha=1, s=100, zorder=6)

#savab
m1_sub_lons, m1_sub_lats = m1(lon_distusavab2,lat_distusavab2)
csb2 = m1.scatter(m1_sub_lons,m1_sub_lats, marker='h', c=alt_colsavab,                 alpha=1, s=50, zorder=4, label = "Open Woodland / Grassland")
#m1.contourf(m1_sub_lons,m1_sub_lats, c_sava_0_bs,cmap=savabmap, tri = True, alpha=0.8, s=50, zorder=6)

#savaf
m1_sub_lons, m1_sub_lats = m1(lon_distusavaf2,lat_distusavaf2)
csf2 = m1.scatter(m1_sub_lons,m1_sub_lats, marker='h', c=alt_colsavaf,                 alpha=0.8, s=50, zorder=4, label = "Open Woodland / Forest")


#fore
m1_sub_lons, m1_sub_lats = m1(lon_distufore2,lat_distufore2)
cfs2 = m1.scatter(m1_sub_lons,m1_sub_lats, marker='h', c=alt_colfore,                 alpha=0.8, s=50, zorder=4, label = "Forest / Open Woodland")

# Shrink current axis by 20%
#box = ax.get_position()
#ax.set_position([box.x0, box.y0, box.width * 0.8, box.height])
legend1 = plt.legend((cbs, csb, csf, cfs), ('Grassland / Open Woodland', 'Open Woodland / Grassland', 'Open Woodland / Forest', 'Forest / Open Woodland') ,                     loc='center left', bbox_to_anchor=(1., 0.4), markerscale = 2, ncol = 1, fontsize = 14, fancybox = True, frameon=True, title = "Fire Disturbed Tree Cover States")

legend2 = plt.legend((cbs2, csb2, csf2, cfs2), ('Grassland / Open Woodland', 'Open Woodland / Grassland', 'Open Woodland / Forest', 'Forest / Open Woodland') ,                     loc='center left', bbox_to_anchor=(1., 0.6), markerscale = 2, ncol = 1, fontsize = 14, fancybox = True, frameon=True, title = "Equivalent Tree Cover States")
legend2.get_title().set_fontsize('12') #legend 'Title' fontsize
legend1.get_title().set_fontsize('12') #legend 'Title' fontsize

plt.gca().add_artist(legend1)
plt.subplots_adjust(left=0.001)
#plt.savefig('/Users/Beniamino/Documents/OneDrive/MPI-M/iPython_Notebooks/Pic/Meeting_Victor/Alternative_States/New_Classification_with_SoilTexture_and_Disturbances/Nea_West_Russia_Possible_Alternative_001.pdf', dpi=600)


plt.show()


# In[8]:

def altst_plot(m1, lonlat = np.zeros(8), dotsize = 20, alpha=0.8, marker = 'h'):
    #bare
    m1_sub_lons, m1_sub_lats = m1(lonlat[0],lonlat[1]) # convert lon lat to basemap coordinates
    cbs2 = m1.scatter(m1_sub_lons,m1_sub_lats, marker='h', c=alt_colbare,                 alpha=0.8, s=20, zorder=3, label = 'Grassland / Open Woodland')
#m1.contourf(m1_sub_lons,m1_sub_lats, c_bare_0_bs,cmap=baremap, tri = True, alpha=1, s=100, zorder=6)

#savab
    m1_sub_lons, m1_sub_lats = m1(lonlat[2],lonlat[3])
    csb2 = m1.scatter(m1_sub_lons,m1_sub_lats, marker='h', c=alt_colsavab,                 alpha=1, s=20, zorder=4, label = "Open Woodland / Grassland")
#m1.contourf(m1_sub_lons,m1_sub_lats, c_sava_0_bs,cmap=savabmap, tri = True, alpha=0.8, s=50, zorder=6)

#savaf
    m1_sub_lons, m1_sub_lats = m1(lonlat[4],lonlat[5])
    csf2 = m1.scatter(m1_sub_lons,m1_sub_lats, marker='h', c=alt_colsavaf,                 alpha=0.8, s=20, zorder=4, label = "Open Woodland / Forest")


#fore
    m1_sub_lons, m1_sub_lats = m1(lonlat[6],lonlat[7])
    cfs2 = m1.scatter(m1_sub_lons,m1_sub_lats, marker='h', c=alt_colfore,                 alpha=0.8, s=20, zorder=4, label = "Forest / Open Woodland")
    
    return
def st_plot(m1, lonlat = np.zeros(8), dotsize = 20, alpha=0.8, marker = 'h'):
    #bare
    m1_sub_lons, m1_sub_lats = m1(lonlat[0],lonlat[1]) # convert lon lat to basemap coordinates
    cbs2 = m1.scatter(m1_sub_lons,m1_sub_lats, marker='h', c=colbare,                 alpha=0.8, s=20, zorder=3, label = 'Grassland / Open Woodland')
#m1.contourf(m1_sub_lons,m1_sub_lats, c_bare_0_bs,cmap=baremap, tri = True, alpha=1, s=100, zorder=6)

#savab
    m1_sub_lons, m1_sub_lats = m1(lonlat[2],lonlat[3])
    csb2 = m1.scatter(m1_sub_lons,m1_sub_lats, marker='h', c=colsavab,                 alpha=1, s=20, zorder=4, label = "Open Woodland / Grassland")
#m1.contourf(m1_sub_lons,m1_sub_lats, c_sava_0_bs,cmap=savabmap, tri = True, alpha=0.8, s=50, zorder=6)

#savaf
    m1_sub_lons, m1_sub_lats = m1(lonlat[4],lonlat[5])
    csf2 = m1.scatter(m1_sub_lons,m1_sub_lats, marker='h', c=colsava,                 alpha=0.8, s=20, zorder=4, label = "Open Woodland / Forest")


#fore
    m1_sub_lons, m1_sub_lats = m1(lonlat[6],lonlat[7])
    cfs2 = m1.scatter(m1_sub_lons,m1_sub_lats, marker='h', c=colfore,                 alpha=0.8, s=20, zorder=4, label = "Forest / Open Woodland")
    
    return

#lonlat = [lon_distubare2,lat_distubare2,lon_distusavab2,lat_distusavab2, lon_distusavaf2,lat_distusavaf2, lon_distufore2,lat_distufore2]
#lonlat2 = [lon_bare_1_sb,lat_bare_1_sb, lon_sava_1_sb,lat_sava_1_sb, lon_sava_1_sf,lat_sava_1_sf, lon_fore_1_sf,lat_fore_1_sf]
#lonlat3 = [lon_bare_2_bs,lat_bare_2_bs, lon_sava_2_bs,lat_sava_2_bs, lon_sava_2_fs,lat_sava_2_fs, lon_fore_2_fs,lat_fore_2_fs]
#np.save('ea_w_dist_lolat', lonlat)
#np.save('ea_w_alt1_lolat', lonlat2)
#np.save('ea_w_alt2_lolat', lonlat3)
ea_w_dist_lonlat = np.load('ea_w_dist_lolat.npy')
ea_w_alt1_lonlat = np.load('ea_w_alt1_lolat.npy')
ea_w_alt2_lonlat = np.load('ea_w_alt2_lolat.npy')


# In[10]:

# possible states, but with different projection
fig = plt.figure(figsize=(15,10), facecolor='white')
ax = fig.add_subplot(111)
ax.set_title("Possible Alternative Tree Cover States", fontsize=18)
m1 = Basemap(projection='npaeqd',boundinglat=45,lon_0=-90,resolution='l', round=True)

# map extra features
par = m1.drawparallels([30.,45.,55.,65.,75.,90],labels=[False,False,False,False], color='black', fontsize=14)
mer = m1.drawmeridians(np.arange(-180.,179.,45.),labels=[False,False,True,True], color='black', fontsize=14)
#list of 4 values (default [0,0,0,0]) that control
#whether parallels are labelled where they intersect
#the left, right, top or bottom of the plot. For
#example labels=[1,0,0,1] will cause parallels
#to be labelled where they intersect the left and
#and bottom of the plot, but not the right and top.
#labelstyle       if set to "+/-", north and south latitudes are
#labelled with "+" and "-", otherwise they are
#labelled with "N" and "S".
m1.drawmapboundary(fill_color='#02d8e9')#black
m1.drawcoastlines(linewidth=1.5)
m1.fillcontinents(color='white',lake_color='black')

# set the color of the parallel and meridian lines
setcolor(par,'black')
setcolor(mer,'black')



# fire disturbed
altst_plot(m1=m1, lonlat = ea_w_dist_lonlat, dotsize = 20, alpha=0.8, marker = 'h')

# nondist
st_plot(m1=m1, lonlat = ea_w_alt1_lonlat, dotsize = 20, alpha=0.8, marker = 'h')

st_plot(m1=m1, lonlat = ea_w_alt2_lonlat, dotsize = 20, alpha=0.8, marker = 'h')


# Shrink current axis by 20%
#box = ax.get_position()
#ax.set_position([box.x0, box.y0, box.width * 0.8, box.height])
legend1 = plt.legend((cbs, csb, csf, cfs), ('Grassland / Open Woodland', 'Open Woodland / Grassland', 'Open Woodland / Forest', 'Forest / Open Woodland') ,                     loc='center left', bbox_to_anchor=(1.05, 0.4), markerscale = 2, ncol = 1, fontsize = 14, fancybox = True, frameon=True,                      title = "Fire Disturbed Tree Cover States")

legend2 = plt.legend((cbs2, csb2, csf2, cfs2), ('Grassland / Open Woodland', 'Open Woodland / Grassland', 'Open Woodland / Forest', 'Forest / Open Woodland') ,                     loc='center left', bbox_to_anchor=(1.05, 0.6), markerscale = 2, ncol = 1, fontsize = 14, fancybox = True, frameon=True,                      title = "Equivalent Tree Cover States")
legend2.get_title().set_fontsize('12') #legend 'Title' fontsize
legend1.get_title().set_fontsize('12') #legend 'Title' fontsize

plt.gca().add_artist(legend1)
plt.subplots_adjust(left=0.001)
#plt.savefig('/Users/Beniamino/Documents/OneDrive/MPI-M/iPython_Notebooks/Pic/Meeting_Victor/Alternative_States/New_Classification_with_SoilTexture_and_Disturbances/Nea_East_Possible_Alternative_001.pdf', dpi=600)


plt.show()


# In[ ]:




# In[ ]:




# In[ ]:




# In[ ]:




# In[ ]:




# In[5]:


# conditional histograms sectiondel_ind = []
del_ind = []
for i in range(len(forest[:,5])):
    if forest[i,5]==0: del_ind.append(i)
for_with_fire = np.delete(forest[:], del_ind, 0)

del_ind = []
for i in range(len(bare[:,5])):
    if bare[i,5]==0: del_ind.append(i)
bar_with_fire = np.delete(bare[:], del_ind, 0)

del_ind = []
for i in range(len(savanna[:,5])):
    if savanna[i,5]==0: del_ind.append(i)
sav_with_fire = np.delete(savanna[:], del_ind, 0)

del_ind = []
for i in range(len(dataforr_ea_west_russia[:,5])):
    if dataforr_ea_west_russia[i,5]==0: del_ind.append(i)
data_with_fire = np.delete(dataforr_ea_west_russia[:], del_ind, 0)


# In[18]:

cmapbare = sns.light_palette("#7570b3", n_colors=5, reverse=False, as_cmap=True)
cmapsava = sns.light_palette("#d95f02", n_colors=5, reverse=False, as_cmap=True)
cmapfore = sns.light_palette("#1b9e77", n_colors=5, reverse=False, as_cmap=True)
colbare = '#7570b3'
colsava = '#d95f02'
colfore = '#1b9e77'

columns_2=["VCFF [%]", "MAR - ["+r'mm yr$^{-1}$'+"]", "Mean_Spring_SM - ["+r'mm'+"]", "Mean_Tmin - ["+r'$^\circ$C'+"]",           "PZI", "FF - ["+r'fires yr$^{-1}$'+"]", "GDD0 - ["+r'$^\circ$C yr$^{-1}$'+"]", "PTD", "ST", "State","Elev", "Lon", "Lat" ]
columns=["VCFF", "MAR", "Mean_Spring_SM", "Mean_Tmin", "PZI", "FF", "GDD0", "PTD", "ST", "State","Elev", "Lon", "Lat" ]

# create plot with conditional histograms and joint scatterplot
def scatter_rug_hist_plot(bare, savanna, forest, dataforr_ea_east, index, index_2):
    if index==1:
        binBoundaries = np.linspace(np.min(dataforr_ea_east[:,index])+0.01,np.max(dataforr_ea_east[:,index]),51)#np.linspace(0,1000,51)
    else:
        binBoundaries = np.linspace(np.min(dataforr_ea_east[:,index])+0.01,np.max(dataforr_ea_east[:,index]),51)
    
    if index_2==1:
        binBoundaries2 = np.linspace(np.min(dataforr_ea_east[:,index_2]),np.max(dataforr_ea_east[:,index_2]),51)#np.linspace(0,1000,51)
    else:
        binBoundaries2 = np.linspace(np.min(dataforr_ea_east[:,index_2]),np.max(dataforr_ea_east[:,index_2]),51)
    xmin, ymin = np.min(binBoundaries), np.min(binBoundaries2)
    xmax, ymax = np.max(binBoundaries), np.max(binBoundaries2)

    xmax, xmin = tuple(np.array([xmax, xmin]) + 0.25*(xmax - xmin)*np.array([1, -1]))
    ymax, ymin = tuple(np.array([ymax, ymin]) + 0.25*(ymax - ymin)*np.array([1, -1]))
    #Define grid for subplots
    gs = gridspec.GridSpec(2, 2, width_ratios=[3, 1], height_ratios = [1, 4])

        
    #Create scatter plot
    fig = plt.figure(figsize=(12,8))
    ax = plt.subplot(gs[1, 0],frameon = False,xticks=[],yticks=[], xlim = (xmin, xmax), ylim = (ymin, ymax))
    
    cax = ax.scatter(bare[:,index], bare[:,index_2], alpha=.4, color = colbare)
    sns.rugplot(bare[:,index], color=colbare, ax=ax, height=0.02)
    sns.rugplot(bare[:,index_2], color=colbare,vertical=True, ax=ax, height=0.02);
    
    cax1 = ax.scatter(savanna[:,index], savanna[:,index_2], color = colsava, alpha=.4)
    sns.rugplot(savanna[:,index], color=colsava, ax=ax, height=0.02)
    sns.rugplot(savanna[:,index_2], color=colsava,vertical=True, ax=ax, height=0.02);
    
    cax2 = ax.scatter(forest[:,index], forest[:,index_2], color=colfore, alpha=.4)
    sns.rugplot(forest[:,index], color=colfore, ax=ax, height=0.02)
    sns.rugplot(forest[:,index_2], color=colfore,vertical=True, ax=ax, height=0.02);
    
    
    
    plt.xlabel(columns_2[index])
    plt.ylabel(columns_2[index_2])

    sns.despine()
    #Turn off all axes
    #_=ax.axis('off')

    #Create Y-marginal (right)
    axr = plt.subplot(gs[1, 1], xticks=[], frameon = False,  ylim = (ymin, ymax))
    axr.hist([bare[:,index_2], savanna[:,index_2], forest[:,index_2]], label=["treeless", "open woodland", "forest"]             ,stacked=True,bins=binBoundaries2, alpha=0.8,normed=True, orientation='horizontal', color = [colbare, colsava, colfore])#bare[:,3], color = '#5673E0', orientation = 'horizontal', normed = True)

    #Create X-marginal (top)
    axt = plt.subplot(gs[0,0], frameon = False,  yticks = [], xlim = (xmin, xmax))
    axt.set_title('Northern West Eurasia '+str(columns[index])+' vs '+str(columns[index_2]))

    axt.hist([bare[:,index], savanna[:,index], forest[:,index]], label=["treeless", "open woodland", "forest"],stacked=True,             bins=binBoundaries, alpha=0.8,normed=True, color = [colbare, colsava, colfore])#hist(bare[:,1], color = '#5673E0', normed = True)

    #Create ax for legend with data that will not appear
    axl = plt.subplot(gs[0, 1],frameon = False,  xticks=[],yticks = [], xlim=(xmin-100,xmin-50))
    axl.hist([bare[0:2,index], savanna[0:2,index], forest[0:2,index]], label=["treeless", "open woodland", "forest"],              alpha=0.8,normed=True, color = [colbare, colsava, colfore])
    leg = axl.legend( loc="lower left", ncol = 1, labels=['Treeless','Open woodland','Forest'])

    #plt.savefig('/Users/Beniamino/Documents/OneDrive/MPI-M/iPython_Notebooks/Pic/Meeting_Victor/Conditional_Histograms/Eurasia/NEA_East/bor_ea_east_joint_scatter_'+str(columns[index])+'_'+str(columns[index_2])+'.pdf',dpi=300, transparent=False)
    plt.show()

def kde_rug_hist_plot(bare, savanna, forest, dataforr_ea_east, index, index_2, fsize = 16, figsize = (12,8)):
    # Define limits and bins for histograms 
    if index==1:
        binBoundaries = np.linspace(np.min(dataforr_ea_east[:,index])+0.01,np.max(dataforr_ea_east[:,index]),51)#np.linspace(0,1000,51)
    else:
        binBoundaries = np.linspace(np.min(dataforr_ea_east[:,index])+0.01,np.max(dataforr_ea_east[:,index]),51)
    
    if index_2==1:
        binBoundaries2 = np.linspace(np.min(dataforr_ea_east[:,index_2]),np.max(dataforr_ea_east[:,index_2]),51)#np.linspace(0,1000,51)
    else:
        binBoundaries2 = np.linspace(np.min(dataforr_ea_east[:,index_2]),np.max(dataforr_ea_east[:,index_2]),51)
    xmin, ymin = np.min(binBoundaries), np.min(binBoundaries2)
    xmax, ymax = np.max(binBoundaries), np.max(binBoundaries2)
    xmax, xmin = tuple(np.array([xmax, xmin]) + 0.25*(xmax - xmin)*np.array([1, -1]))
    ymax, ymin = tuple(np.array([ymax, ymin]) + 0.25*(ymax - ymin)*np.array([1, -1]))

    #Define grid for subplots
    gs = gridspec.GridSpec(2, 2, width_ratios=[3, 1], height_ratios = [1, 4])

    #Create kdeplot with rugplot

    fig = plt.figure(figsize=figsize)
    ax = plt.subplot(gs[1, 0],frameon = False,xticks=[],yticks=[], xlim = (xmin, xmax), ylim = (ymin, ymax))
    

    sns.kdeplot(bare[:,index], bare[:,index_2], ax=ax,cmap=cmapbare, linewidths = 2)
    sns.rugplot(bare[:,index], color='#7570b3', ax=ax, height=0.02, linewidth=0.2)
    sns.rugplot(bare[:,index_2], color='#7570b3',vertical=True, ax=ax, height=0.02, linewidth=0.2);
    
    sns.kdeplot(savanna[:,index], savanna[:,index_2], ax=ax,cmap=cmapsava, linewidths = 2)
    sns.rugplot(savanna[:,index], color='#d95f02', ax=ax, height=0.02, linewidth=0.2)
    sns.rugplot(savanna[:,index_2], color='#d95f02',vertical=True, ax=ax, height=0.02, linewidth=0.2);

    sns.kdeplot(forest[:,index], forest[:,index_2], ax=ax,cmap=cmapfore, linewidths = 2)
    sns.rugplot(forest[:,index], color='#1b9e77', ax=ax, height=0.02, linewidth=0.2)
    sns.rugplot(forest[:,index_2], color='#1b9e77',vertical=True, ax=ax, height=0.02, linewidth=0.2);
    
    plt.xlabel(columns_2[index], fontsize=fsize)
    plt.ylabel(columns_2[index_2], fontsize=fsize)

    sns.despine()
#Turn off all axes
#_=ax.axis('off')

#Create Y-marginal (right)
    axr = plt.subplot(gs[1, 1], xticks=[], frameon = False,  ylim = (ymin, ymax))
    hist_Y = axr.hist([bare[:,index_2], savanna[:,index_2], forest[:,index_2]], label=["treeless", "open woodland", "forest"],             stacked=True,bins=binBoundaries2, alpha=0.8,normed=False, orientation='horizontal', color = ['#7570b3', '#d95f02', '#1b9e77'])#bare[:,3], color = '#5673E0', orientation = 'horizontal', normed = True)
    mi, qua, mid, triqua, ma = 0, (np.min(hist_Y[0])+np.max(hist_Y[0]))/4,(np.min(hist_Y[0])+np.max(hist_Y[0]))/2,(np.min(hist_Y[0])+np.max(hist_Y[0]))/4+(np.min(hist_Y[0])+np.max(hist_Y[0]))/2, np.max(hist_Y[0])
    axr.set_xticks([int(mi), int(qua), int(mid), int(triqua), int(ma)])
    plt.xticks(fontsize = fsize)
    plt.yticks(fontsize = fsize)


#Create X-marginal (top)
    axt = plt.subplot(gs[0,0], frameon = False, yticks=[], xlim = (xmin, xmax)) #,  yticks = []
    axt.set_title('Northern West Eurasia '+str(columns[index])+' vs '+str(columns[index_2]), fontsize=fsize)
    hist_X = axt.hist([bare[:,index], savanna[:,index], forest[:,index]], label=["treeless", "open woodland", "forest"],             stacked=True,bins=binBoundaries, alpha=0.8,normed=False, color = ['#7570b3', '#d95f02', '#1b9e77'])#hist(bare[:,1], color = '#5673E0', normed = True)
    mi, qua, mid, triqua, ma = 0, (np.min(hist_X[0])+np.max(hist_X[0]))/4,(np.min(hist_X[0])+np.max(hist_X[0]))/2,(np.min(hist_X[0])+np.max(hist_X[0]))/4+(np.min(hist_X[0])+np.max(hist_X[0]))/2, np.max(hist_X[0])
    axt.set_yticks([int(mi), int(qua), int(mid), int(triqua), int(ma)])
    plt.xticks(fontsize = fsize)
    plt.yticks(fontsize = fsize)

#Create ax for legend with data that will not appear

    axl = plt.subplot(gs[0, 1],frameon = False,  xticks=[],yticks = [], xlim=(xmin-100,xmin-50))
    axl.hist([bare[0:2,index], savanna[0:2,index], forest[0:2,index]], label=["grassland", "savanna", "forest"],             alpha=0.8,normed=True, color = ['#7570b3', '#d95f02', '#1b9e77'])
    leg = axl.legend( loc="lower left", ncol = 1, labels=['Treeless','Open woodland','Forest'] , fontsize=fsize)


    plt.savefig('/Users/Beniamino/Documents/OneDrive/MPI-M/My_Papers/First_Paper_First_Draft/Conditional/bor_ea_west_joint_kde_'+str(columns[index])+'_'+str(columns[index_2])+'.pdf',                dpi=300, transparent=True)
    plt.show()
    return
    #plt.close()











# In[17]:

kde_rug_hist_plot(bare,savanna,forest,dataforr_ea_west_russia,6,4)


# In[19]:

kde_rug_hist_plot(bar_with_fire,sav_with_fire,for_with_fire,data_with_fire,3,5, fsize = 20, figsize = (12,8))


# In[16]:

in1, in2 = [1,1,2,2,2], [3,6,4,5,8]
for i in range(5):
    kde_rug_hist_plot(bare,savanna,forest,dataforr_ea_west_russia,in1[i],in2[i])


# In[ ]:


# In[7]:
index = 2
fore_90 = np.percentile(forest[:,index],90)
bare_90 = np.percentile(bare[:,index],90)
sava_90 = np.percentile(savanna[:,index],90)
fore_10 = np.percentile(forest[:,index],10)
bare_10 = np.percentile(bare[:,index],10)
sava_10 = np.percentile(savanna[:,index],10)



binBoundaries = np.linspace(np.min(dataforr_ea_west_russia[:,index]),np.max(dataforr_ea_west_russia[:,index]),51) #
binw = (binBoundaries[2]-binBoundaries[1])
f_annot_location = round((fore_90)/binw)*binw+binw#+ binBoundaries[0]-binw
s_annot_location = round((sava_90)/binw)*binw+binw#+ binBoundaries[0]-binw
b_annot_location = round((bare_90)/binw)*binw+binw#+ binBoundaries[0]-binw

f_annot_location_10 = round((fore_10)/binw)*binw+binw#+ binBoundaries[0]-2*binw
s_annot_location_10 = round((sava_10)/binw)*binw+binw#+ binBoundaries[0]-2*binw
b_annot_location_10 = round((bare_10)/binw)*binw+binw#+ binBoundaries[0]-2*binw




fig = plt.figure(figsize=(12,8))
ax = fig.add_subplot(111)
ax.set_title('Northern West Russia '+str(columns[index]))

sns.despine()
hi = plt.hist([bare[:,index], savanna[:,index], forest[:,index]], label=["Grassland", "Open woodland", "Forest"],stacked=True,              bins=binBoundaries, alpha=0.8, color = [colbare, colsava, colfore])
plt.legend()
plt.xlabel(columns[index])

lin_f = np.linspace(0,0.60*np.max(hi[0]))
lin_s = np.linspace(0,0.55*np.max(hi[0]))
lin_b = np.linspace(0,0.50*np.max(hi[0]))

lin_f_10 = np.linspace(0,1.02*np.max(hi[0]))
lin_s_10 = np.linspace(0,0.99*np.max(hi[0]))
lin_b_10 = np.linspace(0,1.05*np.max(hi[0]))

plt.plot([f_annot_location for i in lin_f ], lin_f, color = 'k')
plt.plot([s_annot_location for i in lin_s ], lin_s, color = 'k')
plt.plot([b_annot_location for i in lin_b ], lin_b, color = 'k')

plt.plot([f_annot_location_10 for i in lin_f ], lin_f_10, color = 'k')
plt.plot([s_annot_location_10 for i in lin_s ], lin_s_10, color = 'k')
plt.plot([b_annot_location_10 for i in lin_b ], lin_b_10, color = 'k')

ax.annotate('forest 90th percentile: '+str("{:.4f}".format(fore_90)), xy=(f_annot_location+0.005, 0.62*np.max(hi[0])))
ax.annotate('open woodland 90th percentile: '+str("{:.4f}".format(sava_90)), xy=(s_annot_location+0.005, 0.57*np.max(hi[0])))
ax.annotate('grassland 90th percentile: '+str("{:.4f}".format(bare_90)), xy=(b_annot_location+0.005, 0.52*np.max(hi[0])))

ax.annotate('forest 10th percentile: '+str("{:.4f}".format(fore_10)), xy=(f_annot_location_10+0.005, 1.04*np.max(hi[0])))
ax.annotate('open woodland 10th percentile: '+str("{:.4f}".format(sava_10)), xy=(s_annot_location_10+0.005, 1.01*np.max(hi[0])))
ax.annotate('grassland 10th percentile: '+str("{:.4f}".format(bare_10)), xy=(b_annot_location_10+0.005, 1.07*np.max(hi[0])))

plt.xlim(np.min(binBoundaries),np.max(binBoundaries)+0.35)
#plt.ylim(0,510)
#plt.savefig( '/Users/Beniamino/Documents/OneDrive/MPI-M/iPython_Notebooks/Pic/Meeting_Victor/Conditional_Histograms/Eurasia/NEA_West/bor_ea_west_russia_conditional_per_10_90_'+str(columns[index])+'.pdf',dpi=300, transparent=False)
plt.show()



# In[ ]:

index += 1

scatter_rug_hist_plot(bare,savanna,forest,dataforr_ea_west_russia,1,5)


# In[ ]:

delimiters = [np.percentile(savanna[:,1],10),              np.percentile(bare[:,5],90)]
              #np.percentile(bare[:,2],90),np.percentile(savanna[:,2],90)]
delimiters_2 = [np.percentile(savanna[:,1],90),np.percentile(savanna[:,3],90)]#np.percentile(savanna[:,2],90)]
              
kde_rug_hist_plot_delimiters(bare,savanna,forest,dataforr_ea_west_russia,1,5,delimiters, delimiters_2)



# In[ ]:

for i in range(2,8):
    kde_rug_hist_plot(bare,savanna,forest,dataforr_ea_west_russia,1,i)
    scatter_rug_hist_plot(bare,savanna,forest,dataforr_ea_west_russia,1,i)


# In[ ]:

#kde_rug_hist_plot(bare,savanna,forest,dataforr_ea_west,3,1)
scatter_rug_hist_plot(bare,savanna,forest,dataforr_ea_west_russia,1,4)


# In[ ]:

i=0
for elem in columns:
    print i,columns[i]
    i+=1


# In[ ]:

ind_list = [(1,2),(1,3),(1,6),(1,7),(2,3),(2,6),(2,7),(3,6),(3,7),(6,7),(4,7)]
for elem in ind_list:
    kde_rug_hist_plot(bare,savanna,forest,dataforr_ea_west_russia,elem[0],elem[1])
 


# In[ ]:

# set delimiters and run classification

# delimiters west_russia ea (18)
delimiters = delimiters_generator(bare, savanna, forest)

col_class = ["state", "lon", "lat"]
bare_classified = DataFrame(ea_west_russia_classifier(bare, delimiters), columns = col_class)
savanna_classified = DataFrame(ea_west_russia_classifier(savanna, delimiters), columns = col_class)
forest_classified = DataFrame(ea_west_russia_classifier(forest, delimiters), columns = col_class)

#bare_classified.to_pickle('/Users/Beniamino/Documents/OneDrive/MPI-M/iPython_Notebooks/Boreal_Area/Dataframes/bare_ea_west_russia_classified.pkl')
#savanna_classified.to_pickle('/Users/Beniamino/Documents/OneDrive/MPI-M/iPython_Notebooks/Boreal_Area/Dataframes/savanna_ea_west_russia_classified.pkl')
#forest_classified.to_pickle('/Users/Beniamino/Documents/OneDrive/MPI-M/iPython_Notebooks/Boreal_Area/Dataframes/forest_ea_west_russia_classified.pkl')


# In[ ]:

delimiters


# In[ ]:

bare_classified = pd.read_pickle('/Users/Beniamino/Documents/OneDrive/MPI-M/iPython_Notebooks/Boreal_Area/Dataframes/bare_ea_west_classified.pkl')
savanna_classified = pd.read_pickle('/Users/Beniamino/Documents/OneDrive/MPI-M/iPython_Notebooks/Boreal_Area/Dataframes/savanna_ea_west_classified.pkl')
forest_classified = pd.read_pickle('/Users/Beniamino/Documents/OneDrive/MPI-M/iPython_Notebooks/Boreal_Area/Dataframes/forest_ea_west_classified.pkl')


# In[ ]:

# common elements grassland - savanna
bare_sava_intersect = np.intersect1d(bare_classified["state"], savanna_classified["state"])
# common elements foreset - savanna
fore_sava_intersect = np.intersect1d(forest_classified["state"], savanna_classified["state"])
# common elements foreset - savanna - grassland 
fore_sava_bare_intersect = np.intersect1d(np.intersect1d(forest_classified["state"], savanna_classified["state"]), np.intersect1d(bare_classified["state"], savanna_classified["state"]))
template = "{0:6}|{1:5}|{2:5}" # column widths for formatting print
bare_tot = 0
savab_tot = 0
for elem in bare_sava_intersect: 
    #print template.format(elem,Counter(bare_classified["state"])[elem], Counter(savanna_classified["state"])[elem])
    bare_tot += Counter(bare_classified["state"])[elem]
    savab_tot += Counter(savanna_classified["state"])[elem]

fore_tot = 0
savaf_tot = 0
for elem in fore_sava_intersect: 
    print template.format(elem,Counter(forest_classified["state"])[elem], Counter(savanna_classified["state"])[elem])
    fore_tot += Counter(forest_classified["state"])[elem]
    savaf_tot += Counter(savanna_classified["state"])[elem]

template2 = "{0:6}|{1:5}|{2:5}|{3:5}" # column widths for formatting print
#for elem in fore_sava_bare_intersect: print template2.format(elem,Counter(bare_classified["state"])[elem], Counter(savanna_classified["state"])[elem], Counter(forest_classified["state"])[elem])

print bare_tot, savab_tot, savaf_tot, fore_tot


# In[ ]:

bdiv, sbdiv, sfdiv, fdiv = (len(bare_tea[:,1])+len(bare_tna[:,1]))/float(bare_tot), (len(savanna_tea[:,1])+len(savanna_tna[:,1]))/float(savab_tot),(len(savanna_tea[:,1])+len(savanna_tna[:,1]))/float(savaf_tot),(len(forest_tea[:,1])+len(forest_tna[:,1]))/float(fore_tot)
print bdiv, sbdiv, sfdiv, fdiv
blim, slimb, slimf, flim = (len(bare_tea[:,1])+len(bare_tna[:,1]))/round(bdiv), (len(savanna_tea[:,1])+len(savanna_tna[:,1]))/round(sbdiv), (len(savanna_tea[:,1])+len(savanna_tna[:,1]))/round(sfdiv),(len(forest_tea[:,1])+len(forest_tna[:,1]))/round(fdiv)
print blim, slimb, slimf, flim
print 0.05*blim, 0.05*slimb, 0.05*slimf, 0.05*flim


# In[ ]:

# test with different savanna limit considering the entire savanna something intersection
# do it for west russia
slimf, slimb = (slimb + slimf)/2, (slimb + slimf)/2
0.05*slimf 


# In[ ]:

index = []
index2 = []
limit = 0.05 #0.05
for i in range(len(bare_sava_intersect)): 
    if (Counter(bare_classified["state"])[bare_sava_intersect[i]]>=int(limit*blim) and Counter(savanna_classified["state"])[bare_sava_intersect[i]]>=int(limit*slimb)): 
        print bare_sava_intersect[i], Counter(bare_classified["state"])[bare_sava_intersect[i]], Counter(savanna_classified["state"])[bare_sava_intersect[i]]
    else: 
        index.append(i)
    
bare_sava_pruned = np.delete(bare_sava_intersect, index)

for i in range(len(fore_sava_intersect)): 
    if (Counter(forest_classified["state"])[fore_sava_intersect[i]]>=int(limit*flim) and Counter(savanna_classified["state"])[fore_sava_intersect[i]]>=int(limit*slimf)): 
        print fore_sava_intersect[i], Counter(forest_classified["state"])[fore_sava_intersect[i]], Counter(savanna_classified["state"])[fore_sava_intersect[i]]
    else: 
        index2.append(i)

fore_sava_pruned = np.delete(fore_sava_intersect, index2)

print "fore sava",fore_sava_pruned," bare sava", bare_sava_pruned


mask_bare_sava = np.in1d(bare_classified['state'],bare_sava_pruned) # create mask of intersection
mask_sava_bare = np.in1d(savanna_classified['state'],bare_sava_pruned)
mask_fore_sava = np.in1d(forest_classified['state'],fore_sava_pruned)
mask_sava_fore = np.in1d(savanna_classified['state'],fore_sava_pruned)


c_sava_bare = np.ma.masked_array(savanna_classified['state'], ~mask_sava_bare) #apply inverse mask
lon_sb = np.ma.masked_array(savanna_classified['lon'], ~mask_sava_bare)
lat_sb = np.ma.masked_array(savanna_classified['lat'], ~mask_sava_bare)

c_bare_sava = np.ma.masked_array(bare_classified['state'], ~mask_bare_sava) #apply inverse mask
lon_bs = np.ma.masked_array(bare_classified['lon'], ~mask_bare_sava)
lat_bs = np.ma.masked_array(bare_classified['lat'], ~mask_bare_sava)

c_sava_fore = np.ma.masked_array(savanna_classified['state'], ~mask_sava_fore) #apply inverse mask
lon_sf = np.ma.masked_array(savanna_classified['lon'], ~mask_sava_fore)
lat_sf = np.ma.masked_array(savanna_classified['lat'], ~mask_sava_fore)

c_fore_sava = np.ma.masked_array(forest_classified['state'], ~mask_fore_sava) #apply inverse mask
lon_fs = np.ma.masked_array(forest_classified['lon'], ~mask_fore_sava)
lat_fs = np.ma.masked_array(forest_classified['lat'], ~mask_fore_sava)

col2 = np.array(savanna_classified["state"])





# In[ ]:

# execute this before to have correct entries for the legend
#cmap = ListedColormap(sns.color_palette("YlGnBu", 5))
fig = plt.figure()
ax = fig.add_subplot(111)
un = [np.unique(c_bare_sava), np.unique(c_sava_bare), np.unique(c_fore_sava), np.unique(c_sava_fore)]

cmaps = [ListedColormap(palettable.colorbrewer.diverging.PuOr_5.mpl_colors), ListedColormap(palettable.colorbrewer.diverging.PuOr_5_r.mpl_colors), 'summer', 'winter'] #['Reds_r', 'spring', 'summer', 'winter']
rep = [[np.random.rand(1)[0] for elem in un[i]] for i in range(4)]
rop = [[np.random.rand(1)[0] for elem in un[i]] for i in range(4)]
ck = [plt.scatter(rep[i], rop[i], c=un[i], cmap=cmaps[i], s=500, label=rep[i]) for i in range(4)]#'terrain_r'

#patches = [mpatches.Patch(facecolor=plt.get(ck[2], 'facecolors')[i], label=labels[i]) for i in range(len(plt.get(ck[2], 'facecolors')))]
#patch = [mpatches.Patch(facecolor=plt.get(ck[2], 'facecolors')[0], label = 'test')]
#plt.legend(handles=patch, loc='lower left')
plt.show()

col = []
for j in range(4):
    col.append([plt.get(ck[j], 'facecolors')[i] for i in range(len(plt.get(ck[j], 'facecolors')))])
col
len_tot = 0
for elem in col: 
    len_tot += len(elem)
len_tot
x = np.linspace(0, 1, 10)
patches = []
ind = 0
#temporary labels, fix them later
labels = [str(i) for i in np.concatenate((fore_sava_pruned, fore_sava_pruned, bare_sava_pruned, bare_sava_pruned), axis=0)]
labels = ['Forest/Open Woodland '+labels[0], 'Forest/Open Woodland '+labels[1], 'Open Woodland/Forest '+labels[2],'Open Woodland/Forest '+labels[3]]#, 'Open Woodland/Forest '+labels[5] ]
#labels = ['Grassland/Open Woodland','Open Woodland/Grassland/Forest','Forest/Open Woodland', 'Open Woodland/Forest']
#labels = ['Grassland/Savanna','Savanna/Grassland', 'Forest/Savanna 1', 'Forest/Savanna 2','Savanna/Forest 1','Savanna/Forest 2']
#labels = ['Grassland/Savanna','Savanna/Grassland', 'Grassland/Savanna 2','Savanna/Grassland 2','Grassland/Savanna 3','Savanna/Grassland 3','Forest/Savanna 1', 'Forest/Savanna 2', 'Forest/Savanna 3', 'Savanna/Forest 1', 'Savanna/Forest 2', 'Savanna/Forest 3']
for j in range(len(col)):
    for i in range(len(col[j])):
        plt.plot(x, np.random.rand(1) * x + np.random.rand(1), color = col[j][i], label='$y = {i}x + {i}$'.format(i=i))
        patches.append(mpatches.Patch(facecolor=col[j][i], label=labels[ind]))
        ind +=1
plt.legend(handles = patches, loc='best')
plt.show()


# In[ ]:

# plot it [white plot]
fig = plt.figure(figsize=(12,12), facecolor='white')
ax = fig.add_subplot(111)
#plt.clf()
ax.set_title("Alternative Tree Cover States over Northern West Russia", fontsize=18)
#m = Basemap(projection='ortho',lon_0=-125,lat_0=60,resolution='l') #West
m = Basemap(projection='ortho',lon_0=50.,lat_0=60,resolution='l') #East
width = m.urcrnrx - m.llcrnrx
height = m.urcrnry - m.llcrnry
# let's zoom in the plot
coef = 0.45
width = width*coef
height = height*coef
m1 = Basemap(projection='ortho',lon_0=50.,lat_0=60.,resolution='l',
            llcrnrx=-0.5*width,llcrnry=-0.5*height,urcrnrx=0.5*width,urcrnry=0.5*height)
par = m1.drawparallels(np.arange(-80.,81.,20.),labels=[True,False,False,False], color='black', fontsize=14)
mer = m1.drawmeridians(np.arange(-180.,181.,20.),labels=[False,False,False,True], color='black', fontsize=14)

m1.drawmapboundary(fill_color='black')
m1.drawcoastlines(linewidth=1.5)
m1.fillcontinents(color='white',lake_color='black')

def setcolor(x, color):
     for m in x:
         for t in x[m][1]:
             t.set_color(color)

setcolor(par,'black')
setcolor(mer,'black')



# let's add a layer with a variable from the dataset 
#lons,lats = np.meshgrid(lon_ea_west,lat_ea_west)
#x, y = m1(lons,lats)
#cf = m1.contourf(x,y,vcff_ea_west,range(0,90,5),cmap='viridis', zorder=2, alpha=0.8)

m1_sub_lons, m1_sub_lats = m1(lon_bs,lat_bs)
cbs = m1.scatter(m1_sub_lons,m1_sub_lats, marker='h', c=c_bare_sava, cmap=ListedColormap(palettable.colorbrewer.diverging.PuOr_5.mpl_colors),                 alpha=0.8, s=50, zorder=3)
#cbscont = m1.contourf(m1_sub_lons,m1_sub_lats, c_bare_sava, cmap='Reds_r', alpha=0.8)

m1_sub_lons, m1_sub_lats = m1(lon_sb,lat_sb)
csb = m1.scatter(m1_sub_lons,m1_sub_lats, marker='h', c=c_sava_bare, cmap=ListedColormap(palettable.colorbrewer.diverging.PuOr_5_r.mpl_colors),                 alpha=0.8, s=50, zorder=4)
#csbcont = m1.contourf(m1_sub_lons,m1_sub_lats, c_sava_bare, cmap='spring', alpha=0.8)

m1_sub_lons, m1_sub_lats = m1(lon_fs,lat_fs)
cfs = m1.scatter(m1_sub_lons,m1_sub_lats, marker='h', c=c_fore_sava, cmap='summer',                 alpha=0.8, s=50, zorder=3)
#cfscont = m1.contourf(m1_sub_lons,m1_sub_lats, c_fore_sava, clevs = [i for i in fore_sava_pruned], cmap='summer', alpha=0.8, tri=True, zorder=5)

m1_sub_lons, m1_sub_lats = m1(lon_sf,lat_sf)
csf = m1.scatter(m1_sub_lons,m1_sub_lats, marker='h', c=c_sava_fore, cmap='winter',                 alpha=0.8, s=50, zorder=3)
#csfcont = m1.contourf(m1_sub_lons,m1_sub_lats,c_sava_fore, V= [0,1,2,3], cmap='winter', alpha=0.8, tri=True, zorder=5)
#m1.contourf(m1_sub_lons,m1_sub_lats, c_sava_fore, clevs = [i for i in fore_sava_pruned], tri=True,cmap='winter', alpha=0.8, zorder=5)
#matplotlib.pyplot.tricontourf(m1_sub_lons,m1_sub_lats, triangles = None, mask = c_sava_fore, V= [i for i in fore_sava_pruned], zorder=10)

legend = plt.legend(handles=patches, loc='upper center', bbox_to_anchor=(0.5, -0.03), ncol = 2, fontsize = 14, fancybox = True, frameon=True)
#legend.get_frame().set_facecolor('black')
#legend.get_frame().set_edgecolor('w')
#for text in legend.get_texts():
#    plt.setp(text, color = 'w')

# plt.legend(proxy, legsc[i+3] , loc='upper center', bbox_to_anchor=(0.5, -0.01), ncol = 3, fontsize = 20, fancybox = True, frameon=True)
#colbar = m1.colorbar(cf, "right", size="4%", pad="3%", ticks=range(0,90,5), boundaries=range(0,90,5))
#cbytick_obj = plt.getp(colbar.ax.axes, 'yticklabels')                #tricky
#plt.setp(cbytick_obj, color='w')


#leg = ax.legend( loc="lower left", ncol = 2, handles=patches, labels=['Grassland - Savanna','Savanna - Grassland','Forest - Savanna', 'Savanna - Forest'])
#bounds_dif = np.append(np.unique(col), np.unique(col)[-1]) # new bounds and ticks for the colorbar
#cb = m1.colorbar(cs, "bottom", size="4%", pad="2%", cmap='Blues')#,  ticks=bounds_dif, boundaries=bounds_dif)


plt.savefig('/Users/Beniamino/Documents/OneDrive/MPI-M/iPython_Notebooks/Pic/Meeting_Victor/Alternative_States/EA_Alternative_States/Nea_West_Russia_Alternative_States_004.pdf', dpi=600)

#plt.draw()
plt.show()


# In[ ]:

# plot it [white plot]
fig = plt.figure(figsize=(12,12), facecolor='white')
ax = fig.add_subplot(111)
#plt.clf()
ax.set_title("Alternative Tree Cover States over Northern West Eurasia", fontsize=18)
#m = Basemap(projection='ortho',lon_0=-125,lat_0=60,resolution='l') #West
m = Basemap(projection='ortho',lon_0=50.,lat_0=60,resolution='l') #East
width = m.urcrnrx - m.llcrnrx
height = m.urcrnry - m.llcrnry
# let's zoom in the plot
coef = 0.45
width = width*coef
height = height*coef
m1 = Basemap(projection='ortho',lon_0=50.,lat_0=60.,resolution='l',
            llcrnrx=-0.5*width,llcrnry=-0.5*height,urcrnrx=0.5*width,urcrnry=0.5*height)
par = m1.drawparallels(np.arange(-80.,81.,20.),labels=[True,False,False,False], color='black', fontsize=14)
mer = m1.drawmeridians(np.arange(-180.,181.,20.),labels=[False,False,False,True], color='black', fontsize=14)

m1.drawmapboundary(fill_color='black')
m1.drawcoastlines(linewidth=1.5)
m1.fillcontinents(color='white',lake_color='black')

def setcolor(x, color):
     for m in x:
         for t in x[m][1]:
             t.set_color(color)

setcolor(par,'black')
setcolor(mer,'black')



# let's add a layer with a variable from the dataset 
lons,lats = np.meshgrid(lon_ea_west,lat_ea_west)
x, y = m1(lons,lats)
cf = m1.contourf(x,y,vcff_ea_west,range(0,90,5),cmap='viridis', zorder=2, alpha=0.8)

plt.savefig('/Users/Beniamino/Documents/OneDrive/MPI-M/iPython_Notebooks/Pic/Meeting_Victor/Alternative_States/EA_Alternative_States/Nea_West_VCFF.pdf', dpi=600)

#plt.draw()
plt.show()


# In[ ]:

# plot it [black plot]
fig = plt.figure(figsize=(12,12), facecolor='black')
ax = fig.add_subplot(111)
#plt.clf()
#ax.set_title("Multiple Stable States over Eastern North America", fontsize=18)
#m = Basemap(projection='ortho',lon_0=-125,lat_0=60,resolution='l') #West
m = Basemap(projection='ortho',lon_0=130,lat_0=60,resolution='l') #East
width = m.urcrnrx - m.llcrnrx
height = m.urcrnry - m.llcrnry
# let's zoom in the plot
coef = 0.5
width = width*coef
height = height*coef
m1 = Basemap(projection='ortho',lon_0=130.,lat_0=60.,resolution='l',
            llcrnrx=-0.5*width,llcrnry=-0.5*height,urcrnrx=0.5*width,urcrnry=0.5*height)
par = m1.drawparallels(np.arange(-80.,81.,20.),labels=[True,False,False,False], color='white', fontsize=18)
mer = m1.drawmeridians(np.arange(-180.,181.,20.),labels=[False,False,True,False], color='white', fontsize=18)

m1.drawmapboundary(fill_color='black')
m1.drawcoastlines(linewidth=1.5)
m1.fillcontinents(color='white',lake_color='black')

def setcolor(x, color):
     for m in x:
         for t in x[m][1]:
             t.set_color(color)

setcolor(par,'w')
setcolor(mer,'w')



# let's add a layer with a variable from the dataset 
#lons,lats = np.meshgrid(lon5,lat5)
#x, y = m1(lons,lats)
#cf = m1.contourf(x,y,vcff5,range(0,90,5),cmap='viridis', zorder=2, alpha=0.8)

m1_sub_lons, m1_sub_lats = m1(lon_bs,lat_bs)
cbs = m1.scatter(m1_sub_lons,m1_sub_lats, marker='h', c=c_bare_sava, cmap=ListedColormap(palettable.colorbrewer.diverging.PuOr_5.mpl_colors), alpha=0.8, s=50, zorder=3)
#cbscont = m1.contourf(m1_sub_lons,m1_sub_lats, c_bare_sava, cmap='Reds_r', alpha=0.8)

m1_sub_lons, m1_sub_lats = m1(lon_sb,lat_sb)
csb = m1.scatter(m1_sub_lons,m1_sub_lats, marker='h', c=c_sava_bare, cmap=ListedColormap(palettable.colorbrewer.diverging.PuOr_5_r.mpl_colors), alpha=0.8, s=50, zorder=3)
#csbcont = m1.contourf(m1_sub_lons,m1_sub_lats, c_sava_bare, cmap='spring', alpha=0.8)

m1_sub_lons, m1_sub_lats = m1(lon_fs,lat_fs)
cfs = m1.scatter(m1_sub_lons,m1_sub_lats, marker='h', c=c_fore_sava, cmap='summer', alpha=0.8, s=50, zorder=3)
#cfscont = m1.contourf(m1_sub_lons,m1_sub_lats, c_fore_sava, cmap='summer', alpha=0.8)

m1_sub_lons, m1_sub_lats = m1(lon_sf,lat_sf)
csf = m1.scatter(m1_sub_lons,m1_sub_lats, marker='h', c=c_sava_fore, cmap='winter', alpha=0.8, s=50, zorder=3)
#csfcont = m1.contourf(m1_sub_lons,m1_sub_lats,c_sava_fore, cmap='winter', alpha=0.8, tri=True)



#legend = plt.legend(handles=patches, loc='upper center', bbox_to_anchor=(0.5, -0.01), ncol = 3, fontsize = 20, fancybox = True, frameon=True)
#legend.get_frame().set_facecolor('black')
#legend.get_frame().set_edgecolor('w')
#for text in legend.get_texts():
#    plt.setp(text, color = 'w')

# plt.legend(proxy, legsc[i+3] , loc='upper center', bbox_to_anchor=(0.5, -0.01), ncol = 3, fontsize = 20, fancybox = True, frameon=True)
#colbar = m1.colorbar(cf, "right", size="4%", pad="3%", ticks=range(0,90,5), boundaries=range(0,90,5))
#cbytick_obj = plt.getp(colbar.ax.axes, 'yticklabels')                #tricky
#plt.setp(cbytick_obj, color='w')


#leg = ax.legend( loc="lower left", ncol = 2, handles=patches, labels=['Grassland - Savanna','Savanna - Grassland','Forest - Savanna', 'Savanna - Forest'])
#bounds_dif = np.append(np.unique(col), np.unique(col)[-1]) # new bounds and ticks for the colorbar
#cb = m1.colorbar(cs, "bottom", size="4%", pad="2%", cmap='Blues')#,  ticks=bounds_dif, boundaries=bounds_dif)


#plt.savefig('/Users/Beniamino/Documents/OneDrive/MPI-M/iPython_Notebooks/Pic/Meeting_Victor/Alternative_States/Na_East_over_VCFF_Black.png', facecolor='black', dpi=600)

#plt.draw()
plt.show()


# In[ ]:

np.where(abs(forest[:,-1]-np.unique(lat_fs)[0])<0.01), np.where(abs(forest[:,-2]-np.unique(lon_fs)[0])<0.1)


whe = 1
la = np.where(abs(lat5-np.unique(lat_sf)[whe])<0.1)
lo = np.where(abs(lon5-np.unique(lon_sf)[whe])<0.1)
for i in range(len(la[0])):
    print lat5[la[0][i]], lon5[lo[0][i]], vcff5[la[0][i]][lo[0][i]]
print 
print np.unique(lat_sf)[whe], np.unique(lon_sf)[whe]




# non funziona perché stai usando i np.unique che ordina i valori, quindi non è detto che il primo valore
# per lat corriponda al primo valore per lon e via dicendo
# devi usare tutti i valori non mascherati nel loro ordine originale
for whe in range(len(np.unique(lat_fs))):
    la = np.where(abs(lat-np.unique(lat_fs)[whe])<0.01)
    lo = np.where(abs(lon-np.unique(lon_fs)[whe])<0.01)
    for i in range(len(la[0])):
        print lat[la[0][i]], lon[lo[0][i]], vcff[la[0][i]][lo[0][i]]
     
    print np.unique(lat_fs)[whe], np.unique(lon_fs)[whe]
    print




plt.hist([bare_classified['state'],savanna_classified['state'],forest_classified['state']],label=["grassland", "savanna", "forest"],alpha=0.8,stacked=True, bins=125)
sns.despine()
plt.xticks(np.arange(0,130,5))
plt.xlim(0,130)
plt.legend()
plt.show()




col = np.array(bare_classified["state"])
col2 = np.array(savanna_classified["state"])
col3 = np.array(forest_classified["state"])

fig = plt.figure(figsize=(12,12))
ax = fig.add_subplot(111)
#plt.clf()
ax.set_title("Grassland States")
m = Basemap(projection='ortho',lon_0=-80,lat_0=60,resolution='l')
width = m.urcrnrx - m.llcrnrx
height = m.urcrnry - m.llcrnry
# let's zoom in the plot
coef = 0.3
width = width*coef
height = height*coef
m1 = Basemap(projection='ortho',lon_0=-80.,lat_0=60.,resolution='l',
            llcrnrx=-0.5*width,llcrnry=-0.5*height,urcrnrx=0.5*width,urcrnry=0.5*height)
m1.drawparallels(np.arange(-80.,81.,20.))
m1.drawmeridians(np.arange(-180.,181.,20.))
m1.drawmapboundary(fill_color='white')
m1.drawcoastlines(linewidth=1.5)




# let's add a layer with a variable from the dataset 
#lons,lats = np.meshgrid(lon_ea,lat)
#x, y = m1(lons,lats)
#cf = m1.contourf(x,y,data=vcff_ea, cmap='Reds')



# Here the subsample of VCF colored according to right/wrong in the fitting
m1_sub_lons, m1_sub_lats = m1(np.array(bare_classified["lon"]), np.array(bare_classified["lat"]))
cs = m1.scatter(m1_sub_lons,m1_sub_lats, marker='h', c=col, cmap='Blues', alpha=0.8, s=50)

m2_sub_lons, m2_sub_lats = m1(np.array(savanna_classified["lon"]), np.array(savanna_classified["lat"]))
cs2 = m1.scatter(m2_sub_lons,m2_sub_lats, marker='h', c=col2, cmap='Greens', alpha=0.8, s=50)

m3_sub_lons, m3_sub_lats = m1(np.array(forest_classified["lon"]), np.array(forest_classified["lat"]))
cs3 = m1.scatter(m3_sub_lons,m3_sub_lats, marker='h', c=col3, cmap='Reds', alpha=0.8, s=50)

#bounds_dif = np.append(np.unique(col), np.unique(col)[-1]) # new bounds and ticks for the colorbar
cb = m1.colorbar(cs, "bottom", size="4%", pad="2%", cmap='Blues')#,  ticks=bounds_dif, boundaries=bounds_dif)

#bounds = np.append(np.unique(col), np.unique(col)[-1]+0.1) # new bounds and ticks for the colorbar
#cd = m1.colorbar(cf, "right", size="4%", pad="3%", cmap='Reds')

#plt.savefig('/Users/Beniamino/Documents/OneDrive/MPI-M/iPython_Notebooks/Pic/Meeting_Victor/Phase_Space/NA_Distribution_FF+VCFF.pdf', dpi=300)

plt.draw()
plt.show()







