ramanFit <- function(wavenumber,intensity){
	
	# ramanFit returns the v1 fit parameters given inputs of measured Raman wavenumber and intensity. Wavenumber and intensity must be the same length. Wavenumber is in 1/cm units, and intensity is in arbitrary units. The start values for the optimization route (line 20 below) are based on typical measured values in this study using the WITec Alpha300RA. If an error message is received when running this function, the start values may need to be adjusted to typical values from your instrument.
	# see "example_peak_fitting.R" for an example of how to use this function
	 	
	# locate the data between 1080 and 1100 cm^-1 (i.e. the v1 peak)
	inds = which(wavenumber < 1100 & wavenumber > 1080)
	
	# define x as cm^-1 and r as the intensity
	x = wavenumber[inds]
	r = intensity[inds]
	
	# make a data frame for curve fitting
	v1 = data.frame(x,r)
	
	# estimate peak height:
	peakGuess = max(v1)-min(v1)

	# non-linear least squares fitting: background intercept and slope, and Gaussian curve
	thisFit_v1 = try(nls(r ~ b + m*x + k * exp(-((x-p))^2/(2*(FWHM/(2*sqrt(2*log(2))))^2)), data=v1, start = list(b=600,k=peakGuess,p=1087,FWHM=3,m=0)),silent=TRUE)
	
	if (length(thisFit_v1)>1) {
		# define full width at half maximum (FWHM), peak height, and peak position from the Gaussian fit
		fwhm_v1 = coef(thisFit_v1)[4]
		peak_v1 = coef(thisFit_v1)[2]
		pos_v1 = coef(thisFit_v1)[3]
		background = coef(thisFit_v1)[1]+coef(thisFit_v1)[5]*coef(thisFit_v1)[3]
		}
	if (length(thisFit_v1)==1) {
		print("Error: convergence not reached. Try adjusting 'start' values of nls function")
		}
		
	out = list(fwhm_v1,peak_v1,pos_v1,background,thisFit_v1)
	return(out)
		
	}


