!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! This is part of the program for demostrating the bubble formation and growth  !     
! ebullition module (EBG) used in:                                              !
!                                                                               !
! Peltola, O., Raivonen, M., Li, X., and Vesala, T.: Technical Note: Comparison !
! of methane ebullition modelling approaches used in terrestrial wetland models,!
! Biogeosiences Discuss., XXX, 2017.                                            !
!                                                                               !
! Please see the pdf-document distributed along with these codes                !
! and the article Peltola et al., Biogeosciences Discussions xxx, 2017, for     !
! more information.                                                             ! 
!                                                                               !
! If you use these codes in your research, please cite the above-mentioned      !
! article.                                                                      !
!                                                                               !
! Contact:                                                                      !
! Olli Peltola                                                                  !
! olli.peltola@helsinki.fi                                                      !
!                                                                               !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

module bubble_output

  use bubble_parameters, only: dp, n_flux_parts, mebuair, mebutot
  use bubble_geometry, only: geometry
  implicit none

  private
  public output_data

contains


  subroutine output_data(time, nz, geom, por, methaneP, gases_out_rates, Vp, foldout, &
    mebu_rateP)

    real(dp), intent(in)        :: time, por
    integer, intent(in)         :: nz
    type(geometry), intent(in)  :: geom
    real(dp), intent(in)        :: methaneP(nz), gases_out_rates(n_flux_parts), &
                                    Vp(nz), mebu_rateP(nz)
    logical, save               :: first_call = .true.
    real(dp), parameter         :: day = 24._dp * 3600._dp
    CHARACTER(LEN = *)          :: foldout
    integer                     :: i
    real(dp)                    :: mcP(nz)

    if (first_call) then
      first_call = .false.
      open(11, file = foldout // 'methane_conc.txt', action = 'WRITE', status = 'REPLACE')

      open(21, file = foldout // 'output_fluxes.txt', action = 'WRITE', status = 'REPLACE')
      write(21, *) '  t CH4ebu CH4ebutot'


      open(24, file = foldout // 'bubble_volumes.txt', action = 'WRITE', status = 'REPLACE')
      open(28, file = foldout // 'bubble_flux.txt', action = 'WRITE', status = 'REPLACE')


    end if

    ! starting to write

    ! concentrations
    mcP = 0
    if (geom % waterQ) then
      do i = geom % w2, geom % w1, -1
        mcP(i) = methaneP(i)/(por * geom % dzP(i))
      end do
    end if
    if (geom % SurfaceQ) then
      do i = geom % s2, geom % s1, -1
        mcP(i) = methaneP(i)/(geom % dzP(i))
      end do
    end if
    if (geom % airQ) then
      do i = geom % a1, geom % a2
        mcP(i) = methaneP(i)/(por * geom % dzP(i))
      end do
    end if
    write(11, *) time/day, mcP

    ! methane fluxes
    write(21, *) time/day, -gases_out_rates(mebuair), -gases_out_rates(mebutot)

    ! bubble volumes     
    write(24, *) time/day, Vp

    ! flux of methane in and out from the bubble
    write(28, *) time/day, mebu_rateP

  end subroutine output_data


end module bubble_output
