!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! This is part of the program for demostrating the bubble formation and growth  !     
! ebullition module (EBG) used in:                                              !
!                                                                               !
! Peltola, O., Raivonen, M., Li, X., and Vesala, T.: Technical Note: Comparison !
! of methane ebullition modelling approaches used in terrestrial wetland models,!
! Biogeosiences Discuss., XXX, 2017.                                            !
!                                                                               !
! Please see the pdf-document distributed along with these codes                !
! and the article Peltola et al., Biogeosciences Discussions xxx, 2017, for     !
! more information.                                                             ! 
!                                                                               !
! If you use these codes in your research, please cite the above-mentioned      !
! article.                                                                      !
!                                                                               !
! Contact:                                                                      !
! Olli Peltola                                                                  !
! olli.peltola@helsinki.fi                                                      !
!                                                                               !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

module bubble_parameters
  implicit none

  ! MODEL SETTINGS
  integer, parameter :: dp = selected_real_kind(15, 300) !64bit double precision
  real(dp), parameter :: min_dz = 0.01_dp ! means 1 cm
  ! minimum thickness for boxes, because small boxes require a smaller time step
  integer, parameter :: n_flux_parts = 2
  ! indices for the bookkeeping arrays where we collect the output fluxes etc.
  !  1 = methane ebullition into air
  !  2 = methane ebullition total (when WTD is below peat surface, ebullition is
  !      released in the lowest air layer inside peat)
  integer, parameter :: mebuair = 1, mebutot = 2
  ! Scaling to choose a safe time step for numerics. Anything up to 1 should be
  ! safe, but values close to 1 might give oscillations (but only dampening
  ! type) in the solution of diffusion. 0.5 should be very safe.
  real(dp), parameter :: time_scale = 0.5
  ! model geometry
  integer, parameter :: nlayers = 10
  real(dp), parameter :: layer_thickness = 0.2_dp





  ! CONSTANTS
  ! Atmospheric pressure [Pa]
  real(dp), parameter :: atm = 101325._dp
  ! Gas constant
  real(dp), parameter :: Rgas = 8.3144621_dp ! [J mol-1 K-1]
  ! pi
  real(dp), parameter :: pi = 3.141592653589793_dp
  ! Ebullition
  ! half-life of supersaturated dissolved methane
  real(dp), parameter :: ebu_hl = 1800._dp ! 30 minutes, 1800 s
  ! peat porosity
  real(dp), parameter :: por = 0.85_dp
  ! Fraction of the diffusion rate in air-filled peat divided by the diffusion rate in free air
  real(dp), parameter :: peat_coeff_a = 0.37_dp
  ! Fraction of the diffusion rate in water-filled peat divided by the diffusion rate in free water
  real(dp), parameter :: peat_coeff_w = 0.9_dp





  ! PARAMETERS RELATED SPECIFICALLY TO THE BUBBLE MODULE
  ! CH4 mixing ratio in bubbles (mol mol-1)
  real(dp), parameter :: f = 0.5_dp
  ! probability that a bubble will get stuck at one layer
  real(dp), parameter :: bubprob = 0.3_dp
  ! Amount of bubbles in one model layer. This directly impacts the CH4 exchange
  ! rate between pore water and bubbles
  real(dp), parameter :: Nbub = 100.0_dp
  ! Maximum fraction of volume occupied by bubbles (10 %)
  ! If this is exceeded, then the extra volume is released
  real(dp), parameter :: Vmaxfraction = 0.1_dp



  
  
end module bubble_parameters

