%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%% Time-series Radiocarbon 2-pool modelling 2-timepoints%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%% Optimization Utsav Tessa %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Script by utsav mannu and tessa van der voort
% prerequisites: 
% 1. Matlab Licence
% 2. 2-point 14C time-series data on bulk level 
% 3. turnover estimate of one of the pools (e.g. the fast cycling pool)
% 4. matrix with year & atmospheric Fm values (Hua2013). Should be updated
% depending on recent atmospheric values. File is provided
% We follow standard equations such as explained in Torn et al., 2009.
% Note this script takes more time to run that the 1-pool

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%% Standard variable input %%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% 2- pool %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 % clear 
clear
% load in matrix year & atmospheric signature
load UDnew.mat %UD new can be adjusted for potential vegetation-induced lag.
% atmospheric signature
Fatm=UDnew(:,2);
%%%%%other parameters
lamda = 1.210*10^-4;
% Slow pool turnover range:
step2=10:10:10000; %range of turnover time slow pool from 10 year to 10.000 yearsin steps of 10 years
erR=Inf;
% define the fraction loop, reduce to speed up optimization
stepf=0.01;
max_size_f1 = 0.5;
min_size_f1 = 0.01;
f1=min_size_f1:stepf:max_size_f1;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%% Standard variable input %%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% 2- pool %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% You should have the following data:
% 1. turnover time of your dynamic pool

% Change the following four things for your run:
% 1. Time-point 1 bulk
% 2. Time-point 2 bulk
% 3. turnover time of dynamic pool e.g. WEOC
% 4. sampling year of time-point 1
% 5. sampling year of time-point 2

% 1. Fill in the bulk D14C signature of time-point 1
D14C_time_point_1 = -78.22;
% 2. fill in bulk D14C signature of time-point 2
D14C_time_point_2 = -19.71;
% 3. Fill in the turnover time of WEOC
Turnover_time_WEOC = 213.5;
% 4. sampling year of time-point 1 @ Utsav we should adapt this 
st_yr=3;%starting year
% 5. sampling year of time-point 2
end_yr = 12014; % note that number = yr A.d. + 10.000

% Implementing standard formulae as described in paper
Fac(st_yr)=1; %concentration 14C in the starting year
KM1 = 1./Turnover_time_WEOC; 
KM2 = 1./step2; % k turnover second/slow pool
% Define error space
er1=zeros(length(min_size_f1:stepf:max_size_f1),length(KM2)); % first number is the length of F range and second legth of K2
er2=er1;
counterF=1;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%% Optimisation loop %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% 2- pool %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


for F1=min_size_f1:stepf:max_size_f1
    F2 = 1-F1;
KM = 1./(F1/KM1+F2./KM2); 
counter=1;
for K=1:length(KM(:))

    for i=(st_yr):(end_yr) 
        Fac(i+1)=KM(K)*Fatm(i+1)+F1*Fac(i)*(1-KM1-lamda) +F2*Fac(i)*(1-KM2(K)-lamda);
    end
    er1(counterF,counter)=abs(Fac(end_yr)-((D14C_time_point_2/1000)+1));
    er2(counterF,counter)=abs(Fac(11995)-((D14C_time_point_1/1000)+1)); 
    counter=counter+1;
end
counterF=counterF+1;
end

Er=sqrt(er1.^2 +er2.^2); % square root error
val=min(min(Er));
[row,column]=find(Er==val);
index =[row column];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%% Vizualize the output %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% 2- pool %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
KM1d=KM1; % Visualize output
KM2d=KM2(column); % Visualize output
F1d=f1(row);
F2d=1-F1d;
% run the attained fit s o results can be visualised
KMd= 1/(F1d/KM1d + F2d/KM2d); % This has been modified after reviews.



 for i=(st_yr):12014 % insert year gap here
        Fac(i+1)=KMd*Fatm(i+1)+F1d*Fac(i)*(1-KM1d-lamda) +F2d*Fac(i)*(1-KM2d-lamda);
 end

 
dxx1=['The turovertime(data1) is ::',num2str(1/KM1d),'years'];
dxx2=['The turovertime(data2) is ::',num2str(1/KM2d),'years'];
dxx=['The turovertime is bulk:',num2str(1/KMd),'years'];
dxxf=['The fraction of the weak pool is ::' num2str(F1d)];
RSME_lowest=['The lowest error in R is:' num2str(val)];

disp(dxx1); % turnover time fast pool
disp(dxx2); % turnover time slow pool
disp(dxx); % turnover time one pool
disp(dxxf); % fraction of weak pool
disp(RSME_lowest); % lowest error
pcolor(Er); shading interp
surf(Er); shading interp % 3 dimensional error map
