
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Script to determine likeliest turnover time with two 14C data-points%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% 1- pool %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Script by utsav mannu and tessa van der voort
% prerequisites: 1. Matlab Licence
% 2. 2-point 14C time-series data 
% 3. matrix with year & atmospheric Fm values (Hua2013). Should be updated
% depending on recent atmospheric values. File is provided
% We follow standard equations such as explained in Torn et al., 2009.


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%% Standard variable input %%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% 1- pool %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%clear any previous logged materials
clear
% load file with atmospheric Fm 14C signature
%load UDnew.mat %UD new can be adjusted for potential vegetation-induced lag.
load UDnew.mat % with lag
%%%%%other parameters
lamda = 1.210*10^-4; % decay rate 14C
% range turnover times possible and step-size
% step size is 1 year to save computation, but reduce if deadling with ad
% dynamic pool 
step=1:0.1:10000; %range of turnover time from 1 year to 10.000 years, steps of 0.1
KM=1./step; % k is inverse turnover time, so decay rate

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%% Variable input by user %%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% 1- pool %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Change the following four things for your run:
% 1. Time-point 1 
% 2. Time-point 2 
% 3. sampling year of time-point 1
% 4. sampling year of time-point 2

% 1. Fill in the D14C signature of time-point 1
D14C_time_point_1 = -416.3826;
% 2. fill in D14C signature of time-point 2
D14C_time_point_2 = -215.4705;
% 3. Set starting year time_point_1. Earliest possible is 1995 
% 1996 =2 1997 = 3 1998 = 4 %%, so  change accordingly
st_yr=4;%starting year % 
% 4. year second timepoint. Note add 10.000 years (deglaciation to any date A.D.) 
end_yr = 12014;




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%Now we start with the optimization loop!%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% 1- pool %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Fatm=UDnew(:,2);% select atmospheric signature second column matrix
Fac(st_yr)=1; %concentration in the starting year, assumed to be 1
counter=1;
for K=KM
    K;
    for i=(st_yr):(end_yr) % insert year gap here
        Fac(i+1)=K*Fatm(i+1 )+Fac(i)*(1-K-lamda);
    end
    er1(counter)=abs(Fac(end_yr)-((D14C_time_point_2/1000)+1));
    er2(counter)=abs(Fac(11995)-((D14C_time_point_1/1000)+1)); %insert 2014 value here %% insert year+1
    counter=counter+1;
end
er=sqrt((er1).^2+(er2).^2); 
[val1,index1]=min(er1); % error of data point 1
[val2,index2]=min(er2);% error of data point 2
[val,index]=min(er); % take mean square error booth values


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%% Translate optimisation to output %%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% 1- pool %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Visualize output
output=step(index); 
K=1/output;
 for i=(st_yr):12014 % insert year gap here
        Fac(i+1)=K*Fatm(i+1)+Fac(i)*(1-K-lamda);
 end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% Results %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% 1- pool %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dxx1=['The turovertime(data1) is ::',num2str(step(index1)),'years'];
dxx2=['The turovertime(data2) is ::',num2str(step(index2)),'years'];
dxx=['The turovertime is ::',num2str(step(index)),'years'];
RSME_lowest=['The lowest error for R is:',num2str(min(er)),' R '];

disp(dxx1);
disp(dxx2);
disp(dxx);
disp(RSME_lowest);
% plot optimsation and bomb-peak 14C incorporation
% adapt plot to personal preference. year A.D. +10.000 --> year
% input
hold on
plot(11950:12014,Fac(11950:12014),'-or'); hold on %1000 was 11950
plot(Fatm); hold on
plot(11995, ((D14C_time_point_1/1000)+1), '*'); hold on
plot(12014, ((D14C_time_point_2/1000)+1), '*');
figure
plot(step,er1,'r');hold on;
plot(step,er2,'g');
plot(step,er,'k');
