# For testing purposes extract the data from the supplementary material into three seperate .xls files named: Hyrrokin_isotopes_all.xlsx (containing the isotope data)
#Hyrrokin_EPMA.xlsx (containing the EPMA data) and ICP_results_all.xlsx (containing the OES data)
#####Libraries#####
library(readxl)
library(rstatix)
library(dplyr)
library(ggplot2)
library(tidyverse)
library(ggrepel)
library(gridExtra)
library(ggpubr)
library(ggsci)
library(cowplot)
library(gridExtra)
library(xtable)
library(reshape2)
library(svglite)
setwd(dirname(rstudioapi::getActiveDocumentContext()$path))
options(digits=3)
options(pillar.sigfig = 3)


#####Stable isotopes#####
#####Data import#####
hyrr_isotopes<-read_excel("Hyrrokin_isotopes_all.xlsx") # import data
df<- hyrr_isotopes

#####Mean,SD,Min,Max#####
means_hyrro<- df  %>% group_by(host) %>%
  summarise_at(vars(c("d18O","d13C")), funs(mean(., na.rm=TRUE),
                                            median(.,na.rm = TRUE),
                                            sd(., na.rm = TRUE),
                                            min(., na.rm=TRUE),
                                            max(., na.rm=TRUE))) # calculate mean,sd, etc.

df$host <- factor(df$host, levels=c("acesta/m","acesta/o", "lophelia", "host acesta", "host lophelia")) #convert host to factor
#####ANOVA and Kruskal-Wallis#####
anova_df<- df %>% filter( host == "acesta/o" | host == "lophelia" | host == "acesta/m")

anova_df %>% group_by(host) %>% summarise_at(vars(c("d18O","d13C")), funs(shapiro_test(.))) # shapiro and levenes test
levene_test(d18O ~ host, data = anova_df)
levene_test(d13C ~ host, data = anova_df)

anova_d13<- anova_df %>%anova_test(d13C ~ host) # Anova to test for significant differences in the isotopic composition
anova_d18<- anova_df %>%anova_test(d18O ~ host)
anova_d18
anova_d13
anova_df %>% kruskal_test(d18O ~ host)
anova_df %>% kruskal_test(d13C ~ host)

anova_iso_results <-data.frame(t(anova_d13), t(anova_d18))
colnames(anova_iso_results)<- c("d13", "d18")

pwc <- anova_df %>% tukey_hsd(d13C ~ host) # Tuckey HSD as post-hoc test
pwc
pwc <- pwc %>% add_xy_position(x = "host")
ggboxplot(anova_df, x = "host", y = "d13C") +
  stat_pvalue_manual(pwc, hide.ns = TRUE) 

pwc <- anova_df %>% tukey_hsd(d18O ~ host)
pwc
pwc <- pwc %>% add_xy_position(x = "host")
ggboxplot(anova_df, x = "host", y = "d18O") +
  stat_pvalue_manual(pwc, hide.ns = TRUE) 
#####Fig. 6#####
df$host <- factor(df$host, levels=c("acesta/m","acesta/o", "lophelia", "host acesta", "host lophelia"))
g1<-df%>%
  ggplot()+
  geom_point(aes(x=d18O,y=d13C, color=host))+
  geom_point(color = "red",size = 3,aes(x=2.4, y = 1.4))+
  geom_point(color = "red",size = 3,aes(x=3.2, y = 3.1))+
  stat_ellipse(aes(x=d18O,y=d13C, color=host))+
  annotate("segment", x = 0, xend = -2, y = -2.5, yend = -6, colour = "black", size=1, arrow=arrow())+
  annotate("segment", x = 3.2,xend = 3.2, y = 1, yend = -2.5, colour = "black", size=1, arrow=arrow())+
  annotate("text", x = c(-1), y = c(-3.3),
           label = c("Less Seawater C \n  Higher pH \n Slower Hydration/Hydroxilation") ,
           color="black",
           size=4,
           angle = 32)+
  annotate("text", x = c(3.3), y = c(0),
           label = c("Respiration") ,
           color="black",
           size=4,
           angle= 270)+
  annotate("text", x = 2.2, y = 1.8, label = "EQ calcite")+
  annotate("text", x = 2.9, y = 3.5, label = "EQ aragonite")+
  theme_pubr()+
  theme(panel.border = element_rect(colour = "black",
                                    fill=NA, size=0.5),
        legend.position = c(0.38,0.92),
        legend.text.align = 0,
        legend.background = element_blank(),
        legend.direction = "horizontal",
        legend.box.background = element_rect(colour = "black"))+
  ylab(expression(delta^13*"C"*" [\u2030]"))+
  xlab(expression(delta^18*"O"*" [\u2030]"))+
  scale_color_manual(name = "",
                  labels=c(expression(over(textstyle(italic("H. sarcophaga")),
                                           atop(textstyle(italic("A. excavata")),
                                                atop(textstyle("with callus"))))),
                           expression(over(textstyle(italic("H. sarcophaga")),
                                           atop(textstyle(italic("A. excavata")),
                                                atop(textstyle("without callus"))))),
                           expression(over(textstyle(italic("H. sarcophaga")),
                                           atop(textstyle(italic("D. pertusum"))))),
                           expression(paste(italic("A. excavata"))),
                           expression(paste(italic("D. pertusum ")))),
                  breaks=c("acesta/m","acesta/o", "lophelia", "host acesta", "host lophelia"),
                  values = c("acesta/m"= "#0073C2Ff", "acesta/o"="#868686FF", "lophelia" = "#EFC000FF", "host acesta"="#CD534CFF", "host lophelia" ="#8F7700FF"))+
  scale_y_continuous(breaks=seq(-10,4, by=1), limits=c(-10, 4))+
  scale_x_continuous(breaks=seq(-3, 4, by = 1),limits = c(-3,3.5))

plot(g1)
ggsave(plot = g1, filename = "Isotopes.png", dpi = 400, device = "png", height = 8, width = 10)
ggsave(plot = g1, filename = "Isotopes.svg", dpi = 400, device = "svg", height = 8, width = 10)
#####EPMA#####
#####Data import#####
Hyrrokin_EPMA <- read_excel("Hyrrokin_EPMA.xlsx") # import data

#####Mean,SD,Min,Max#####
var <- c("Mg_Ca", "Sr_Ca", "Na_Ca", "S_Ca")
means<- Hyrrokin_EPMA  %>% group_by(Loc) %>%
  summarise_at(vars(var), funs(mean(., na.rm=TRUE),
                               median(.,na.rm = TRUE),
                               sd(., na.rm = TRUE),
                               min(., na.rm=TRUE),
                               max(., na.rm=TRUE))) # calculate mean,sd, etc.
#####Fig. 2#####
Hyrrokin_EPMA$Loc <- factor(Hyrrokin_EPMA$Loc, levels = c("Biv C", "Biv A", "Biv R", "Foram B"))
legend_EPMA<- get_legend(ggplot(data=Hyrrokin_EPMA, aes(x=Loc, y = Mg_Ca, color = Loc))+
                           geom_boxplot()+stat_summary(fun=mean,shape=1,col='red',geom='point')+
                           theme_pubr()+
                           xlab("")+
                           ylab("Mg/Ca [mmol/mol]")+
                           scale_x_discrete(labels=c("","","","",""))+
                           scale_color_jco(name = "Sample",
                           labels=c(expression(over(textstyle(italic("A. excavata")),atop(textstyle("Calcite")))),
                                   expression(over(textstyle(italic("A. excavata")),atop(textstyle("Aragonite")))),
                                   expression(over(textstyle(italic("A. excavata")),atop(textstyle("SRZ")))),
                                   expression(paste(italic("H. sarcophaga")))),
                           breaks=c("Biv C","Biv A", "Biv R", "Foram B")))
                                                                                                                                                                                                                                                                           

Hyrrokin_EPMA <- Hyrrokin_EPMA %>% filter(Mg_Ca > 0.7) 
g1<-plot_grid(ggplot(data=Hyrrokin_EPMA, aes(x=Loc, y = Mg_Ca, color = Loc))+
                geom_jitter(aes(alpha=0.1))+
                geom_boxplot(outlier.shape = NA)+
                stat_summary(fun=mean,shape=1,col='red',geom='point')+
                theme_pubr(legend="none")+
                xlab("")+
                ylab(expression("Mg/Ca ["*mmol*" "*mol^-1*"]"))+
                scale_x_discrete(labels=c("","","","",""))+
                scale_color_jco(), 
              ggplot(data=Hyrrokin_EPMA, aes(x=Loc, y = Na_Ca, color = Loc))+
                geom_jitter(aes(alpha=0.1))+
                geom_boxplot(outlier.shape = NA)+
                stat_summary(fun=mean,shape=1,col='red',geom='point',position = )+
                theme_pubr(legend="none")+
                xlab("")+
                ylab(expression("Na/Ca ["*mmol*" "*mol^-1*"]"))+
                scale_x_discrete(labels=c("","","","",""))+
                scale_color_jco(),
              ggplot(data=Hyrrokin_EPMA, aes(x=Loc, y = Sr_Ca, color = Loc))+
                geom_jitter(aes(alpha=0.1))+
                geom_boxplot(outlier.shape = NA)+
                stat_summary(fun=mean,shape=1,col='red',geom='point')+
                theme_pubr(legend="none")+
                xlab("")+
                ylab(expression("Sr/Ca ["*mmol*" "*mol^-1*"]"))+
                scale_x_discrete(labels=c("","","","",""))+
                scale_color_jco(),
              ggplot(data=Hyrrokin_EPMA, aes(x=Loc, y = S_Ca, color = Loc))+
                geom_jitter(aes(alpha=0.1))+
                geom_boxplot(outlier.shape = NA)+
                stat_summary(fun=mean,shape=1,col='red',geom='point')+
                theme_pubr(legend="none")+
                xlab("")+
                ylab(expression("S/Ca ["*mmol*" "*mol^-1*"]"))+
                scale_x_discrete(labels=c("","","","",""))+
                scale_color_jco(),labels = c("(a)","(b)","(c)","(d)"), vjust = -0.1)

EPMA<-plot_grid(legend_EPMA, g1, ncol = 1, rel_heights = c(0.1,1))
plot(EPMA)
ggsave(plot = EPMA, filename = "EPMA_BOXPLOT.png", dpi = 400, device = "png", height = 8, width = 10)
ggsave(plot = EPMA, filename = "EPMA_BOXPLOT.svg", dpi = 400, device = "svg", height = 8, width = 10)
#####OES#####
ICP_results <- read_excel("ICP_results_all.xlsx") # import data

#####Mean,SD,Min,Max#####
means_hyrro<- Samples  %>% group_by(host) %>%
  summarise_at(vars(c("Mg26","Na","Sr","Mn"),), funs(mean(., na.rm=TRUE),
                                                     sd(., na.rm = TRUE),
                                                     min(., na.rm=TRUE),
                                                     max(., na.rm=TRUE))) %>% as.data.frame() # calculate mean,sd, etc.

samples_hyrro <- ICP_results[which(ICP_results$area == "foram"),] #extract hyrrokkin results
Samples$host <- factor(Samples$host, levels=c("acesta/m","acesta/o", "lophelia", "host acesta", "host lophelia")) #convert host to factor
legend <- get_legend(ggplot(data=Samples, aes(x=host, y = Mg26, color=host))+geom_boxplot()+theme_pubr()+scale_color_manual(name = "Sample",
                                                                                                                         labels=c(expression(over(textstyle(italic("H. sarcophaga")),atop(textstyle(italic("A. excavata")),atop(textstyle("with callus"))))),
                                                                                                                                  expression(over(textstyle(italic("H. sarcophaga")),atop(textstyle(italic("A. excavata")),atop(textstyle("without callus"))))),
                                                                                                                                  expression(over(textstyle(italic("H. sarcophaga")),atop(textstyle(italic("D. pertusum"))))),
                                                                                                                                  expression(paste(italic("A. excavata"))),
                                                                                                                                  expression(paste(italic("D. pertusum")))),
                                                                                                                         breaks=c("acesta/m","acesta/o", "lophelia","host acesta", "host lophelia" ),
                                                                                                                         values = c("acesta/m"= "#0073C2Ff", "acesta/o"="#868686FF", "lophelia" = "#EFC000FF", "host acesta"="#CD534CFF", "host lophelia" ="#8F7700FF")))

#####Fig. 4#####

g1<-plot_grid(ggplot(data=Samples, aes(x=host, y = Mg26, color=host))+geom_jitter(aes(alpha= 0.1))+geom_boxplot(outlier.shape = NA)+stat_summary(fun=mean,shape=1,col='red',geom='point')+theme_pubr(legend="none")+xlab("")+ylab(expression("Mg/Ca ["*mmol*" "*mol^-1*"]"))+scale_x_discrete(labels=c("","","","",""))+scale_color_manual(values = c("acesta/m"= "#0073C2Ff", "acesta/o"="#868686FF", "lophelia" = "#EFC000FF", "host acesta"="#CD534CFF", "host lophelia" ="#8F7700FF")), 
              ggplot(data=Samples, aes(x=host, y = Na, color=host))+geom_jitter(aes(alpha= 0.1))+geom_boxplot(outlier.shape = NA)+stat_summary(fun=mean,shape=1,col='red',geom='point')+theme_pubr(legend="none")+xlab("")+ylab(expression("Na/Ca ["*mmol*" "*mol^-1*"]"))+scale_x_discrete(labels=c("","","","",""))+scale_color_manual(values = c("acesta/m"= "#0073C2Ff", "acesta/o"="#868686FF", "lophelia" = "#EFC000FF", "host acesta"="#CD534CFF", "host lophelia" ="#8F7700FF")),
              ggplot(data=Samples, aes(x=host, y = Sr, color=host))+geom_jitter(aes(alpha= 0.1))+geom_boxplot(outlier.shape = NA)+stat_summary(fun=mean,shape=1,col='red',geom='point')+theme_pubr(legend="none")+xlab("")+ylab(expression("Sr/Ca ["*mmol*" "*mol^-1*"]"))+scale_x_discrete(labels=c("","","","",""))+scale_color_manual(values = c("acesta/m"= "#0073C2Ff", "acesta/o"="#868686FF", "lophelia" = "#EFC000FF", "host acesta"="#CD534CFF", "host lophelia" ="#8F7700FF")),
              ggplot(data=Samples, aes(x=host, y = Mn, color=host))+geom_jitter(aes(alpha= 0.1))+geom_boxplot(outlier.shape = NA)+stat_summary(fun=mean,shape=1,col='red',geom='point')+theme_pubr(legend = "none")+xlab("")+ylab(expression("Mn/Ca ["*mmol*" "*mol^-1*"]"))+scale_x_discrete(labels=c("","","","",""))+scale_color_manual(values = c("acesta/m"= "#0073C2Ff", "acesta/o"="#868686FF", "lophelia" = "#EFC000FF", "host acesta"="#CD534CFF", "host lophelia" ="#8F7700FF")),
              df %>% 
                ggplot(aes(x=host, y = d18O, color = host))+geom_jitter(aes(alpha= 0.1))+
                geom_boxplot(aes(x=host, y = d18O, color = host), outlier.shape = NA)+
                stat_summary(fun=mean,shape=1,col='red',geom='point')+
                geom_hline(yintercept = 0.26, alpha=0.5)+
                theme_pubr(legend="none")+
                xlab("")+
                ylab(expression(delta^18*"O"*" [\u2030]"))+
                scale_x_discrete(labels=c("","","","",""))+
                scale_color_manual(values = c("acesta/m"= "#0073C2Ff", "acesta/o"="#868686FF", "lophelia" = "#EFC000FF", "host acesta"="#CD534CFF", "host lophelia" ="#8F7700FF")),
              df %>% 
                ggplot(aes(x=host, y = d13C, color = host))+geom_jitter(aes(alpha= 0.1))+
                geom_boxplot(aes(x=host, y = d13C, color = host), outlier.shape = NA)+
                stat_summary(fun=mean,shape=1,col='red',geom='point')+
                geom_hline(yintercept = 0.38, alpha=0.5)+
                theme_pubr(legend="none")+
                xlab("")+
                ylab(expression(delta^13*"C"*" [\u2030]"))+
                scale_x_discrete(labels=c("","","","",""))+
                scale_color_manual(values = c("acesta/m"= "#0073C2Ff", "acesta/o"="#868686FF", "lophelia" = "#EFC000FF", "host acesta"="#CD534CFF", "host lophelia" ="#8F7700FF")),
              labels = c("(a)","(b)","(c)","(d)","(e)","(f)"), align = "hv")

boxplot<-plot_grid(legend, g1, ncol = 1, rel_heights = c(0.1,1))
boxplot
ggsave(plot = boxplot, filename = "OES_BOXPLOT.png", dpi = 400, device = "png", height = 8, width = 10)
ggsave(plot = boxplot, filename = "OES_BOXPLOT.svg", dpi = 400, device = "svg", height = 8, width = 10)
#####ANOVA and Kruskal-Wallis#####
shapiro_df<-samples_hyrro %>% group_by(host) %>% summarise_at(vars(c("Mg26","Sr","Na","Mn")), funs(shapiro_test(.)))

levene_test(Mg26 ~ host, data = samples_hyrro)
levene_test(Sr ~ host, data = samples_hyrro)
levene_test(Na ~ host, data = samples_hyrro)
levene_test(Mn ~ host, data = samples_hyrro) #shapiro and levenes test


anov_Mg<- samples_hyrro %>% anova_test(Mg26 ~ host) #ANOVA to test for significant differences in in the elemental ratios
anov_Na<- samples_hyrro %>% anova_test(Na ~ host)
anov_Sr<- samples_hyrro %>% anova_test(Sr ~ host)
anov_Mn<- samples_hyrro %>% anova_test(Mn ~ host)

samples_hyrro %>% kruskal_test(Mg26 ~ host)
samples_hyrro %>% kruskal_test(Na ~ host)
samples_hyrro %>% kruskal_test(Sr ~ host)
samples_hyrro %>% kruskal_test(Mn ~ host)


anova_results <-data.frame(Mg=t(anov_Mg),Na=t(anov_Na),Sr=t(anov_Sr),Mn=t(anov_Mn))
colnames(anova_results)<- c("Mg", "Na","Sr","Mn")


pwcMg <- samples_hyrro %>% tukey_hsd(Mg26 ~ host, p.adj = "bonf") #Tuckey HSD as post-hoc test'
pwcSr <- samples_hyrro %>% tukey_hsd(Sr ~ host, p.adj = "bonf")
pwcNa <- samples_hyrro %>% tukey_hsd(Na ~ host, p.adj = "bonf")
pwcMn <- samples_hyrro %>% tukey_hsd(Mn ~ host, p.adj = "bonf")
pwcMg
pwcSr
pwcNa
pwcMn

###### Mixing Model######
setwd(dirname(rstudioapi::getActiveDocumentContext()$path))
Ca<- seq(-4,2,0.1) # sequence from 0 to 4 in 0.1 steps
CaM <- 100.086 # mass carbonate
#Na/Ca Lophelia
hostNa <- 26 # 26 mmol/mol Na/Ca from measurements
swNa <- 0.450 # seawater in mol/l
swCa <- 0.010 # seawater in mol/l
DNa <- 0.00028
DNa1 <- 0.0001

calcCa<- swCa + (10^Ca)/CaM
calcNa <- swNa + 10^Ca/CaM*hostNa/1000
calciteNaCaL <- calcNa/calcCa*DNa
calciteNaCaL1 <- calcNa/calcCa*DNa1


#Na/Ca Acesta
hostNa <- 20

calcCa<- swCa + (10^Ca)/CaM
calcNa <- swNa + ((10^Ca)/CaM)*hostNa/1000
calciteNaCaA <- calcNa/calcCa*DNa
calciteNaCaA1 <- calcNa/calcCa*DNa1

dfNa <- data.frame(Ca, calciteNaCaA, calciteNaCaL)
dfNa <- melt(dfNa, id="Ca")
dfNa1 <- data.frame(Ca, calciteNaCaA1, calciteNaCaL1)
dfNa1 <- melt(dfNa1, id="Ca")

g1<-ggplot()+
  geom_line(data = dfNa,size=1.5, aes(x=Ca, y= value*1000, color = variable, linetype = variable))+
  geom_line(data = dfNa1,size=1.5, aes(x=Ca, y= value*1000, color = variable, linetype = variable))+
  theme_pubr(legend="none")+
  xlab(expression("log "*CaCO[3]*"/Seawater ratio ["*g*" "*L^-1*"]"))+
  ylab(expression("Na/Ca ["*mmol*" "*mol^-1*"]"))+
  scale_y_continuous(n.breaks = 7)+
  #geom_hline(yintercept = c(24.2-3.19,24.2+3.19), color = "#0073C2FF", alpha =0.5)+
  #geom_hline(yintercept = c(15.5-2.04,15.5+2.04), color = "#EFC000FF", alpha =0.5)+
  scale_color_manual(values = c(calciteNaCaA="#0073C2FF",
                                calciteNaCaL="#EFC000FF",
                                calciteNaCaA1="#0073C2FF",
                                calciteNaCaL1="#EFC000FF"))+
  scale_linetype_manual(values = c(calciteNaCaA="solid",
                                   calciteNaCaL="solid",
                                   calciteNaCaA1="dotted",
                                   calciteNaCaL1="dotted"))

g1
#Mg/Ca Lophelia
hostMg <- 4.2
swMg <- 0.053
DMg <- 0.015
DMg1 <- 0.009

calcMg <- swMg+10^Ca/CaM*hostMg/1000
calciteMgCaL <- calcMg/calcCa*DMg
calciteMgCaL1 <- calcMg/calcCa*DMg1
#Mg/Ca Acesta
hostMg = 19

calcMg <- swMg+10^Ca/CaM*hostMg/1000
calciteMgCaA <- calcMg/calcCa*DMg
calciteMgCaA1 <- calcMg/calcCa*DMg1

dfMg <- data.frame(Ca, calciteMgCaA, calciteMgCaL)
dfMg <- melt(dfMg, id="Ca")
dfMg1 <- data.frame(Ca, calciteMgCaA1, calciteMgCaL1)
dfMg1 <- melt(dfMg1, id="Ca")

g2<-ggplot()+
  geom_line(data = dfMg,size=1.5, aes(x=Ca, y= value*1000, color = variable, linetype = variable))+
  geom_line(data = dfMg1,size=1.5, aes(x=Ca, y= value*1000, color = variable, linetype = variable))+
  theme_pubr(legend="none")+
  xlab(expression("log "*CaCO[3]*"/Seawater ratio ["*g*" "*L^-1*"]"))+
  ylab(expression("Mg/Ca ["*mmol*" "*mol^-1*"]"))+
  #geom_hline(yintercept = c(43.5-7.015,43.5+7.015), color = "#0073C2FF", alpha =0.5)+
  #geom_hline(yintercept = c(42.45-6.77,42.45+6.77), color = "#EFC000FF", alpha =0.5)+
  scale_color_manual(values = c(calciteMgCaA="#0073C2FF",
                                calciteMgCaL="#EFC000FF",
                                calciteMgCaA1="#0073C2FF",
                                calciteMgCaL1="#EFC000FF"))+
  scale_linetype_manual(values = c(calciteMgCaA="solid",
                                   calciteMgCaL="solid",
                                   calciteMgCaA1="dotted",
                                   calciteMgCaL1="dotted"))

g2
#Mn/Ca Lophelia
hostMn <- 0.008
swMn <- 0.000000005
DMn <- 0.5
DMn1<- 10

calcMn <- swMn+10^Ca/CaM*hostMn/1000
calciteMnCaL <- calcMn/calcCa*DMn
calciteMnCaL1 <- calcMn/calcCa*DMn1
#Mn/Ca Acesta
hostMn = 0.13

calcMn <- swMn+10^Ca/CaM*hostMn/1000
calciteMnCaA <- calcMn/calcCa*DMn
calciteMnCaA1 <- calcMn/calcCa*DMn1

dfMn <- data.frame(Ca, calciteMnCaA, calciteMnCaL)
dfMn <- melt(dfMn, id="Ca")

dfMn1 <- data.frame(Ca,calciteMnCaA1, calciteMnCaL1)
dfMn1 <- melt(dfMn1, id="Ca")

g3<-ggplot()+
  geom_line(data = dfMn, size=1.5, aes(x=Ca, y= value*1000, color = variable, linetype = variable))+
  geom_line(data = dfMn1, size=1.5, aes(x=Ca, y= value*1000, color = variable, linetype = variable))+
  theme_pubr(legend="none")+
  xlab(expression("log "*CaCO[3]*"/Seawater ratio ["*g*" "*L^-1*"]"))+
  ylab(expression("Mn/Ca ["*mmol*" "*mol^-1*"]"))+
  scale_y_continuous(n.breaks = 6)+
  scale_color_manual(values = c(calciteMnCaA="#0073C2FF",
                                calciteMnCaL="#EFC000FF",
                                calciteMnCaA1="#0073C2FF",
                                calciteMnCaL1="#EFC000FF"))+
  scale_linetype_manual(values = c(calciteMnCaA="solid",
                                   calciteMnCaL="solid",
                                   calciteMnCaA1="dotted",
                                   calciteMnCaL1="dotted"))

g3
#Sr/Ca Lophelia
hostSr <- 10.1
swSr <- 0.0001
DSr <- 0.16
DSr1<- 0.2

calcSr <- swSr+10^Ca/CaM*hostSr/1000
calciteSrCaL <- calcSr/calcCa*DSr
calciteSrCaL1 <- calcSr/calcCa*DSr1
#Sr/Ca Acesta
hostSr = 1.2

calcSr <- swSr+10^Ca/CaM*hostSr/1000
calciteSrCaA <- calcSr/calcCa*DSr
calciteSrCaA1 <- calcSr/calcCa*DSr1
dfSr <- data.frame(Ca, calciteSrCaA, calciteSrCaL)
dfSr <- melt(dfSr, id="Ca")
dfSr1 <- data.frame(Ca, calciteSrCaA1, calciteSrCaL1)
dfSr1 <- melt(dfSr1, id="Ca")

g4<-ggplot()+
  geom_line(data = dfSr, size=1.5, aes(x=Ca, y= value*1000, color = variable, linetype = variable))+
  geom_line(data = dfSr1, size=1.5, aes(x=Ca, y= value*1000, color = variable, linetype= variable))+
  theme_pubr(legend="none")+
  xlab(expression("log "*CaCO[3]*"/Seawater ratio ["*g*" "*L^-1*"]"))+
  ylab(expression("Sr/Ca ["*mmol*" "*mol^-1*"]"))+
  scale_color_manual(values = c(calciteSrCaA="#0073C2FF",
                                calciteSrCaL="#EFC000FF",
                                calciteSrCaA1="#0073C2FF",
                                calciteSrCaL1="#EFC000FF"))+
  scale_linetype_manual(values = c(calciteSrCaA="solid",
                                   calciteSrCaL="solid",
                                   calciteSrCaA1="dotted",
                                   calciteSrCaL1="dotted"))
g4


#Plots
legend <- get_legend(ggplot()+
                       geom_line(data = dfSr, size = 2, aes(x=Ca, y= value*1000, color = variable, linetype = variable))+
                       geom_line(data = dfSr1, size = 2, aes(x=Ca, y= value*1000, color = variable, linetype = variable))+
                       theme_pubr()+
                       xlab("log Carbonate/Seawater ratio [mg/L]")+
                       ylab("Sr/Ca [mmol/mol]")+
                       scale_color_manual(name="Sample",
                                          values = c(calciteSrCaA="#0073C2FF",
                                                    calciteSrCaL="#EFC000FF",
                                                    calciteSrCaA1="#0073C2FF",
                                                    calciteSrCaL1="#EFC000FF"),
                                          breaks = c("calciteSrCaA","calciteSrCaL"),
                                          label=c(expression(over(textstyle(italic("H. sarcophaga")),
                                                                  atop(textstyle(italic("A. excavata"))))),
                                                  expression(over(textstyle(italic("H. sarcophaga")),
                                                                  atop(textstyle(italic("D. pertusum")))))))+
                       scale_linetype_manual(name = "Distribution coefficient",
                                             label = c(expression(D[E]^1),expression(D[E]^2)),
                                             breaks = c("calciteSrCaA","calciteSrCaA1"), 
                                             values = c(calciteSrCaA="solid",
                                                       calciteSrCaL="solid",
                                                       calciteSrCaA1="dotted",
                                                       calciteSrCaL1="dotted")))

Plot<-plot_grid(g2,g1,g4,g3,labels = c("(a)","(b)","(c)","(d)"), align = "hv", vjust = -0.1)
Plot2<-plot_grid(legend, Plot, ncol = 1, rel_heights = c(0.1,1))
Plot2
ggsave(plot = Plot2, filename = "Mixing.png", dpi = 400, device = "png", height = 8, width = 10)
ggsave(plot = Plot2, filename = "Mixing.svg", dpi = 400, device = "svg", height = 8, width = 10)
#####wilcox test EPMA data ######

wilcox_test( Mg_Ca ~ Loc, data = Hyrrokin_EPMA,p.adjust.method = "bonferroni")
wilcox_test( Sr_Ca ~ Loc, data = Hyrrokin_EPMA,p.adjust.method = "bonferroni")
wilcox_test( Na_Ca ~ Loc, data = Hyrrokin_EPMA,p.adjust.method = "bonferroni")
wilcox_test( S_Ca ~ Loc, data = Hyrrokin_EPMA,p.adjust.method = "bonferroni")

###### figure 7#######

p1<-Hyrrokin_EPMA %>% filter(Loc == "Biv R") %>%  ggplot(aes(x=S_Ca, y =Mg_Ca, color = layer))+
  geom_point()+
  geom_smooth(method = "lm",alpha = 0.2)+
  stat_cor(label.y = c(0,0.88), label.x = 4,aes(label = paste( ..p.label.., sep = "~`,`~"))) +
  theme_pubr(legend="none")+
  ylab(expression("Mg/Ca ["*mmol*" "*mol^-1*"]"))+
  xlab(expression("S/Ca ["*mmol*" "*mol^-1*"]"))+
  scale_color_jco()
p1
p2<-Hyrrokin_EPMA %>% filter(Loc == "Biv R") %>%  ggplot(aes(x=S_Ca, y =Na_Ca, color = layer))+
  geom_point()+
  geom_smooth(method = "lm",alpha = 0.2)+
  stat_cor(label.y = c(15,17.5), label.x = 4,aes(label = paste( ..p.label.., sep = "~`,`~"))) +
  theme_pubr(legend="none")+
  ylab(expression("Na/Ca ["*mmol*" "*mol^-1*"]"))+
  xlab(expression("S/Ca ["*mmol*" "*mol^-1*"]"))+
  scale_color_jco()
p2
p3<-Hyrrokin_EPMA %>% filter(Loc == "Biv R") %>%  ggplot(aes(x=S_Ca, y =Sr_Ca, color = layer))+
  geom_point()+
  geom_smooth(method = "lm",alpha = 0.2)+
  stat_cor(label.y = c(2.5,3.3), label.x = 4,aes(label = paste( ..p.label.., sep = "~`,`~"))) +
  theme_pubr(legend="none")+
  ylab(expression("Sr/Ca ["*mmol*" "*mol^-1*"]"))+
  xlab(expression("S/Ca ["*mmol*" "*mol^-1*"]"))+
  scale_color_jco()
p3

p4<-Hyrrokin_EPMA %>% filter(Loc == "Biv R") %>%  ggplot(aes(x=Ca, y =S_Ca, color = layer))+
  geom_point()+
  geom_smooth(method = "lm",alpha = 0.2)+
  stat_cor(label.y = c(8,9.3), label.x = 38,aes(label = paste( ..p.label.., sep = "~`,`~"))) +
  theme_pubr(legend="none")+
  ylab(expression("S/Ca ["*mmol*" "*mol^-1*"]"))+
  xlab(expression("Ca [wt%]"))+
  scale_color_jco()
p4
legend <- get_legend(Hyrrokin_EPMA %>% filter(Loc == "Biv R") %>% ggplot(aes(x=Mg_Ca, y =S_Ca, color = layer))+
                      geom_point()+
                      geom_smooth(method = "lm",se = FALSE, )+
                      stat_cor(label.y = c(7,8,9,10), label.x = 20, show.legend = FALSE) +
                      theme_pubr()+
                      ylab(expression("S/Ca ["*mmol*" "*mol^-1*"]"))+
                      xlab(expression("Mg/Ca ["*mmol*" "*mol^-1*"]"))+
                      scale_color_jco(name="Sample",
                                      labels=c(expression(over(textstyle(italic("A. excavata")),atop(textstyle("fluorescent")))),
                                               expression(over(textstyle(italic("A. excavata")),atop(textstyle("non fluorescent"))))),
                                      breaks=c("f","nf")))
pg1<- plot_grid(p1,p2,p3,p4, labels = c("(a)","(b)","(c)","(d)"), vjust = -0.1)
pg2<-plot_grid(legend, pg1, ncol = 1, rel_heights = c(0.1,1))
pg2

ggsave(plot = pg2, filename = "corrplot.png", dpi = 400, device = "png", height = 8, width = 10)
ggsave(plot = pg2, filename = "corrplot.svg", dpi = 400, device = "svg", height = 8, width = 10)

# Test for significant differences in the composition between fluorescent and non-fluorescent layers
means_fluo<- Hyrrokin_EPMA  %>% group_by(layer) %>% 
    summarise_at(vars(var), funs(mean(., na.rm=TRUE),
                                 median(.,na.rm = TRUE),
                                 sd(., na.rm = TRUE),
                                 min(., na.rm=TRUE),
                                 max(., na.rm=TRUE)))
wilcox_test(Mg_Ca ~ layer, data = Hyrrokin_EPMA,p.adjust.method = "bonferroni")
wilcox_test(Sr_Ca ~ layer, data = Hyrrokin_EPMA,p.adjust.method = "bonferroni")
wilcox_test(Na_Ca ~ layer, data = Hyrrokin_EPMA,p.adjust.method = "bonferroni")
wilcox_test(S_Ca ~ layer, data = Hyrrokin_EPMA,p.adjust.method = "bonferroni")
