function [mu,sigma]=FitLognormalToDecay(t,g)
% This function calculates the lognormal parameters mu and sigma which best
% fit the decay function g(t).
%
% [mu,sigma]=lognormalfit(t,g) returns the best fitting values of the
% lognormal parameters mu and sigma, to the decay specified by the column
% vectors of mass fraction remaining g, and time, t.   0 < g < 1
%
% requires: LognormalDecay.m
%
% by David Forney, forneyd@alum.mit.edu.  2/14/12


% Choose reasonable guesses for the initial values of mu and sigma
    t50=interp1(g(g>0),t(g>0),.5,'nearest','extrap');
    muguess=log(1/t50);  sigmaguess=.5;
    
    guess=[muguess,sigmaguess];
    
% input data and initial values to nonlinear solver    
    [pars]=nlinfit(t,g,@LognormalDecay,guess);
    
    mu=pars(1);
    sigma=pars(2);    
end