## The R script of the pairwise bootstrap test used in the study
## Daniel Graeber, Dep. of Bioscience, Aarhus University, dgr@dmu.dk

# Script of the function can be used in R as is (following Efron and Tibshirani, Introduction to the bootstrap,1993), 
# See attachment of study for background of test
# '#' indicates comments
# function for pairwise bootstrap test
# content of function:
#'x' = vector containing replicates of first sample;
#'y' = vector containing replicates of second sample;
#'n' or 'm' = number of cases for first or second sample, if no number of cases is given, it is defined by the length of the vector;
#'b' = number of resamples, standard is 9999; 
#'alpha' = significance level, standard is 0.05 (5%)

b.pair<-function(x,y,n=length(x),m=length(y),b=9999,alpha=0.05) {
  # generate 'boots' vector to save bootstrap resamples
  boots<-NULL
  
  # 'for' loop start: for 1 to number of b do the following
  for (i in 1:b) {
    # sample n or m values with replacement from sample vectors and save to vector 'test'
    test<-c(sample(x=x,size=n,replace=TRUE),sample(x=y,size=m,replace=TRUE))
    # from vector 'test' sample 'n' or 'm' values with replacement and save to vector 'test2', this second resampling is done to guarantee randomly sampled values from which the difference of means is calculated
    test2<-c(sample(x=test,size=n,replace=TRUE),sample(x=test,size=m,replace=TRUE))
    # calculate differences of means between randomly sampled values, means are calculated for 1:n and for n+1 to n+m, save value of difference to vector 'boots'
    boots<-c(boots,mean(test2[1:(n)]) - mean(test2[(n+1):(n+m)]))
    # end of 'for' loop
  }
  
  # calculate difference between sample means by using sample vectors 'x' and 'y' from function (see above)
  reals<-mean(x) - mean(y)
  # count number of cases in which the absolute difference of each random mean in 'boots' is larger than the difference between sample means of 'x' and 'y' ('reals'), 'tests' is a vector containing a single integer
  tests<-abs(boots) > abs(reals)
  # divide 'tests' by the length of 'boots' calculate the marginal significance level 'p'
  p<-sum(tests)/length(boots)
  # generate note of significance to display on screen in R
  sig<-ifelse(p<alpha,"difference is significant","difference is not significant")
  cat("p =",p,"\n",sig,"at alpha =",alpha,"\n")
  # return the value of 'p' to be displayed or to be saved in a vector
  return(p)
}
# end of function