% constant defintions for "ocean 17O-excess 1D model.m"

dt=0.02 ; % days
days=[31,28,31,30,31,30,31,31,30,31,30,31] ; % days in each month (leap years not taken care of)
r_days(1)=31 ;
for i=2:12
    r_days(i)=r_days(i-1)+days(i) ;
end
%variables definition
o2=zeros(nl,3); 
diff=zeros(nl,3);
R=zeros(nl,1);
GPR=zeros(nl,2);
GP=zeros(nl,1);
RR=zeros(nl,1);
photo=zeros(nl,3);
do18=zeros(nl,1);
D17=zeros(nl,1);
resp=zeros(nl,3);
R=zeros(nl,3);
d=zeros(nl,1);
kapa=zeros(nl,365);
mixd=zeros(31,1);
smd=zeros(31,1);
ptt=zeros(31,1);
endp=zeros(30,4);

%constants
d(1)=0 ;
d(2:nl)=5:10:((nl-2)*10+5) ;
%RSMOW18=(2005e-6*2); %This is the original
 RSMOW18=2*(2005e-6); % I took off the *2 factor. Eyal
% Rhla18=RSMOW18*(23.8/1000+1); % 23.8 permil for HLA versus SMOW
% RBATS18=RSMOW18*(1.1/1000+1) ; % BATS water are heavier in 1.1 permil than SMOW
%RSMOW17=(379e-6*2); %This is the original
 RSMOW17=2*(379e-6); % I took off the *2.  Eyal
%  RBATS17=RSMOW17/exp(0.518*log(RSMOW18/RBATS18));
%  Rhla17=RSMOW17/exp(250/1e6+0.518*log(RSMOW18/Rhla18));

R17p=0.000380579;
R18p=0.002011967;

%Eyal's
% o2eq_all=[224 228 230 225 222 216 206 201 200 206 216 222];
%o2eq_all=[200 200 200 200 200 200 200 200 200 200 200 200];
 % R17eq_all= [0.000384625 0.000384625 0.000384625 0.000384625 0.000384623 0.000384621 0.000384619...
      %0.000384617 0.000384617 0.000384619 0.000384621 0.000384623 ];
 %R18eq_all= [0.002054548 0.002054549 0.002054552 0.00205455 0.00205453 0.002054507 0.002054487 0.002054473...
% 0.00205447 0.002054488  0.002054515 0.00205453 ];
% 
% R17eqmean=mean(R17eq_all);
%  R18eqmean=mean(R18eq_all);
 Rhla17= 0.000384473;
 Rhla18=0.002053057;

%Discrimination values 
Dr(1)=22 ; % discrimnation in respiration in the photic zone
Dd(1)=21.5 ; % discrimnation in respiration below the photic zone
theta_r=0.516 ; % respiration
alpha_k18=0.9972 ; %gas exchange
alpha_k17=0.9986 ; % gas exchange
sat16=200 ;
T=300 ;
sat17=sat16*Rhla17*(1.00037529830) ;
sat18=sat16*Rhla18*(1.00069333006) ;%I've slightly changes the values here. Eyal.

o2eq_all(1:12)=sat16+sat17+sat18;
R17eq_all(1:12)=sat17/sat16;
R18eq_all(1:12)=sat18/sat16;


%gamma_in=0.516 ;
%gamma_out=0.521 ;
Dr(2)=(1- ((1-Dr(1)/1000))^theta_r )*1000 ;
Dd(2)=(1-((1-Dd(1)/1000))^theta_r  )*1000 ;
lrd= 100 ;% photic zone depth (for resp. fractionation)
%Din(2)=2.8;  Din(3)=2.8*gamma_in ;
%Dout(2)=3.5; Dout(3)=3.5*gamma_out ;

% top (eq. layer) and deep ocean values
o2(1,1)=sat16 ;
o2(1,2)=sat18 ;	
o2(1,3)=sat17 ;
o2(nl,1)=200*0.92; 
o2(nl,2)=o2(nl,1)*Rhla18*(1+3/1000);
o2(nl,3)=o2(nl,1)*...
   Rhla17*exp(35/1e6+0.518*log((o2(nl,2)/o2(nl,1))/Rhla18)) ;
