% A code for creating time-variable kappa values (eddy-turbulence
% coefficients values)
% Based on simple assumptions
% For "ocean 17O-excess 1D model.m"

f=4 ;
DT=0.04/f ; % days
kapam=1e-2*f ;% m^2/sec  mixed layer
kapat=1e-4%/100; % seasonal thermocline
%kapad=  2e-3  ;      % below seasonl thermocline (mode water)
kapad=  1.7e-5  ;      % below seasonl thermocline (mode water)
kapab=1.7e-5 ; % permennent thermocline
load gas_ex
gasex_f=(1/(3600*24))*10 ; % m/day to m^2/sec

%%% assumed mixed depth values for each month
%mix_depths=[160,200,60,45,30,30,30,30,50,70,90,110,130] ;
%mix_depths=[140   200   250    10    20    20    20    20    40    80    90    100 140] ; %  month 13 is January again
% mix_depths=[250   250   250    20    20    20    20    20    20   20    250 250 250] ; %  month 13 is January again
mix_depths=[40   40   40    40    40    40    40    40    40    40    40  40 40] ; % test
%gas_ex(1:12)=3.5  %%%%test!!!

nls=0 ;
for m=1:12
    %gas_ex_m=gas_ex(m)*gasex_f ;
    gas_ex_m=4*gasex_f ;
    time=days(m) ;
    mixds=mix_depths(m) ;
    mixde=mix_depths(m+1) ;
    % interpolate mix depth linear change with time
    clear mixd
    mixd=zeros(time,1) ;
    if mixds==mixde mixds=mixds+1; end;
    mixd(:)=mixds:(mixde-mixds)/(time-1):mixde;
    mixd(:)=mixd(:)./10;
    mixd(:)=round(mixd(:));
    mixd(:)=mixd(:).*10;
    
    % bottom of seasonal thermo.(smd)
    clear smd
    smd(1:time)=120 ;
    
    % perm. thermo. depth (ptt)
    clear ptt
    ptt(1:time)=290 ;
    
    %calculate kapa
    for t=nls+1:nls+time
        tm=t-nls ;
        kapa(1,t)=gas_ex_m;
        kapa(2:(mixd(tm)./10+1),t)=kapam;
        %kapa((mixd(tm)./10+1):(round(smd(tm)/10)+1),t)=kapat;
        %kapa((round(smd(tm)/10)+1):(round(ptt(tm)/10)+1),t)=kapad;
        kapa((mixd(tm)./10+1):(round(ptt(tm)/10)+1),t)=kapat;
        kapa((round(ptt(tm)/10)+1):30,t)=kapab ;
        k=kapa.*0.1.*0.1.*24.*3600;
    end
    nls=t  ;
end
