# For spatial clustering
#########################
# Prune a distance to k links
pruneK <- function(x, K = 10){
  D <- sort(x)
  # Maximum distance within K links (being connected)
  Max <- max( D[D > 0][1:K] )
  # Every link above this distance is removed
  x[x > Max] <- 0
  return(x)
}

nameGeoCluster <- function(Loc, Groups){
  Group <- rep(NA, nrow(Loc))
  Ord <- order(boxplot(Loc$Depth ~ as.factor(Groups), 
                       plot = FALSE)$stat[3,], decreasing = FALSE)
  # Eco-zone 1 and 2 with almost the same mean depth, 
  # i.e. I need the additional criterion of geographic position
  if(max(Loc$Northings[Groups == Ord[1]]) < 4540000){
    Group[Groups == Ord[1]] <- "1 SE upper littoral zone 1"
  }
  if(max(Loc$Northings[Groups == Ord[1]]) >= 4540000){
    Group[Groups == Ord[1]] <- "2 SE upper littoral zone 2"
  }  
  if(max(Loc$Northings[Groups == Ord[2]]) < 4540000){
    Group[Groups == Ord[2]] <- "1 SE upper littoral zone 1"
  }
  if(max(Loc$Northings[Groups == Ord[2]]) >= 4540000){
    Group[Groups == Ord[2]] <- "2 SE upper littoral zone 2"
  } 
  Group[Groups == Ord[3]] <- "3 SE upper littoral zone 3"
  Group[Groups == Ord[4]] <- "4 Non-SE upper littoral"
  Group[Groups == Ord[5]] <- "5 lower littoral"
  Group[Groups == Ord[6]] <- "6 upper sublittoral"
  Group[Groups == Ord[7]] <- "7 lower sublittoral"
  return(Group)
}