
# coding: utf-8

# In[1]:

import matplotlib.pyplot as plt
from mpl_toolkits.basemap import Basemap, shiftgrid
import numpy as np
import seaborn as sns
import datetime
import netCDF4
import sys
import math 
from pandas import DataFrame 
from numpy import ma



# colors for the grassland, savanna, forest
cmapbare = sns.light_palette("#7570b3", n_colors=5, reverse=False, as_cmap=True)
cmapsava = sns.light_palette("#d95f02", n_colors=5, reverse=False, as_cmap=True)
cmapfore = sns.light_palette("#1b9e77", n_colors=10, reverse=False, as_cmap=True)
colbare = '#7570b3'
colsava = '#d95f02'
colfore = '#1b9e77'

def plot_north_polar(fig, data, lon, lat, blat = 45, lon0 = 60, res = 'l', clevs = np.arange(0), cmap =plt.cm.RdBu_r, par = np.arange(-90.,91.,20.), mer = np.arange(-180.,181.,20.), cbar=True):
    m = Basemap(projection='npaeqd',boundinglat=blat,lon_0=lon0,resolution='l')
    m.drawcoastlines()
    #m.fillcontinents(color='coral',lake_color='aqua')
    # draw parallels and meridians.
    m.drawparallels(par)
    m.drawmeridians(mer)
    m.drawmapboundary(fill_color='white')
    m.drawcoastlines(linewidth=1.5)
    lons,lats = np.meshgrid(lon,lat)
    x, y = m(lons,lats)
    if (len(clevs)>0): 
        cs = m.contourf(x,y,data,clevs=clevs,cmap=cmap)
    else:
        cs = m.contourf(x,y,data,cmap=cmap)
    
    # cs2 = m.contour(x,y,data,,linewidths=0.5,colors='k',animated=True)
    if (cbar==True): cb = m.colorbar(cs,"right", size="5%", pad="4%")
    return m;


# In[54]:

# datasets

path = '/Users/Beniamino/Documents/Datasets/Boreal/'

# load netcdfs
# Eurasia
nc005ea_east = netCDF4.Dataset(path+'NEA_East_50_shift_Bor_MOD44B_V5__VCFFplusVCF__2010__0.05deg__UHAM-ICDC.nc')
ncea_east = netCDF4.Dataset(path+'NEA_East_50_shift_Bor_MOD44B_V5__VCFFplusVCF__2010__0.5deg__UHAM-ICDC.nc')
nc2ea_east = netCDF4.Dataset(path+'NEA_East_50_shift_Bor_MAR_cru_ts3.22.1998.2010.pre.dat.nc')
nc3ea_east = netCDF4.Dataset(path+'NEA_East_50_seasonal_soilw.mon.mean.1998-2010.v2.nc')
#nc3ea_east = netCDF4.Dataset(path+'NEA_East_shift_min_bor_yearmean_soilw.mon.mean.1998-2010.v2.nc')
nc4ea_east = netCDF4.Dataset(path+'NEA_East_50_shift_0_bor_M6H_0.5_tmin.2m.gauss.1998-2010.nc')
nc5ea_east = netCDF4.Dataset(path+'NEA_East_50_shift_bor_GLC2000_0.5.nc')
nc6ea_east = netCDF4.Dataset(path+'NEA_East_50_shift_0_bor_0.5_PZI.nc')
nc7ea_east = netCDF4.Dataset(path+'NEA_East_50_shift_masked_bor_0.5_Year_Fire_Frequency_1996-2012.nc')
# nc8ea_east = netCDF4.Dataset(path+'NEA_East_shift_bor_0.5_Burned_1996-2012_SUM.nc')
nc9ea_east = netCDF4.Dataset(path+'NEA_East_50_shift_Bor_ReBil_GloElev_05.nc')
nc10ea_east = netCDF4.Dataset(path+'NEA_East_50_Boreal_Mean_GDD0_1998-2010_0.5.nc')
nc11ea_east = netCDF4.Dataset(path+'NEA_East_50_Bor_Ease25_Northen_Emisphere_Mean_Thawing_Depth_1901-2002.nc')
nc12ea_east = netCDF4.Dataset(path+'NEA_East_50_soil_texture_0.5.nc')
                            
nc005ea_west = netCDF4.Dataset(path+'NEA_West_Russia_50_shift_Bor_MOD44B_V5__VCFFplusVCF__2010__0.05deg__UHAM-ICDC.nc')
ncea_west = netCDF4.Dataset(path+'NEA_West_Russia_50_shift_Bor_MOD44B_V5__VCFFplusVCF__2010__0.5deg__UHAM-ICDC.nc')
nc2ea_west = netCDF4.Dataset(path+'NEA_West_Russia_50_shift_Bor_MAR_cru_ts3.22.1998.2010.pre.dat.nc')
nc3ea_west = netCDF4.Dataset(path+'NEA_West_Russia_50_seasonal_soilw.mon.mean.1998-2010.v2.nc')
#nc3ea_west = netCDF4.Dataset(path+'NEA_West_Russia_shift_min_bor_yearmean_soilw.mon.mean.1998-2010.v2.nc')
nc4ea_west = netCDF4.Dataset(path+'NEA_West_Russia_50_shift_0_bor_M6H_0.5_tmin.2m.gauss.1998-2010.nc')
nc5ea_west = netCDF4.Dataset(path+'NEA_West_Russia_50_shift_bor_GLC2000_0.5.nc')
nc6ea_west = netCDF4.Dataset(path+'NEA_West_Russia_50_shift_0_bor_0.5_PZI.nc')
nc7ea_west = netCDF4.Dataset(path+'NEA_West_Russia_50_shift_masked_bor_0.5_Year_Fire_Frequency_1996-2012.nc')
# nc8ea_west = netCDF4.Dataset(path+'NEA_West_Russia_shift_bor_0.5_Burned_1996-2012_SUM.nc')
nc9ea_west = netCDF4.Dataset(path+'NEA_West_Russia_50_shift_Bor_ReBil_GloElev_05.nc')
nc10ea_west = netCDF4.Dataset(path+'NEA_West_Russia_50_Boreal_Mean_GDD0_1998-2010_0.5.nc')
nc11ea_west = netCDF4.Dataset(path+'NEA_West_Russia_50_Bor_Ease25_Northen_Emisphere_Mean_Thawing_Depth_1901-2002.nc')
nc12ea_west = netCDF4.Dataset(path+'NEA_West_Russia_50_soil_texture_0.5.nc')


# North America
nc005na_east = netCDF4.Dataset(path+'NA_West_shift_Bor_MOD44B_V5__VCFFplusVCF__2010__0.05deg__UHAM-ICDC.nc')
ncna_east = netCDF4.Dataset(path+'NA_West_shift_Bor_MOD44B_V5__VCFFplusVCF__2010__0.5deg__UHAM-ICDC.nc')
nc2na_east = netCDF4.Dataset(path+'NA_West_shift_Bor_MAR_cru_ts3.22.1998.2010.pre.dat.nc')
nc3na_east = netCDF4.Dataset(path+'NA_West_seasonal_soilw.mon.mean.1998-2010.v2.nc')
#nc3na_east = netCDF4.Dataset(path+'NA_West_shift_min_bor_yearmean_soilw.mon.mean.1998-2010.v2.nc')
nc4na_east = netCDF4.Dataset(path+'NA_West_shift_0_bor_M6H_0.5_tmin.2m.gauss.1998-2010.nc')
nc5na_east = netCDF4.Dataset(path+'NA_West_shift_bor_GLC2000_0.5.nc')
nc6na_east = netCDF4.Dataset(path+'NA_West_shift_0_bor_0.5_PZI.nc')
nc7na_east = netCDF4.Dataset(path+'NA_West_shift_masked_bor_0.5_Year_Fire_Frequency_1996-2012.nc')
# nc8na_east = netCDF4.Dataset(path+'NA_West_shift_bor_0.5_Burned_1996-2012_SUM.nc')
nc9na_east = netCDF4.Dataset(path+'NA_West_shift_Bor_ReBil_GloElev_05.nc')
nc10na_east = netCDF4.Dataset(path+'NA_West_Boreal_Mean_GDD0_1998-2010_0.5.nc')
nc11na_east = netCDF4.Dataset(path+'NA_West_Bor_Ease25_Northen_Emisphere_Mean_Thawing_Depth_1901-2002.nc')
nc12na_east= netCDF4.Dataset(path+'NA_West_soil_texture_0.5.nc')
nc13na_east = netCDF4.Dataset(path+'Terra_NA_West_MODIS_0.5_C6_GSSLAI_2000_2015_Decadal_Trend_SigOnly.nc')

nc005na_west= netCDF4.Dataset(path+'NA_East_shift_Bor_MOD44B_V5__VCFFplusVCF__2010__0.05deg__UHAM-ICDC.nc')
ncna_west= netCDF4.Dataset(path+'NA_East_shift_Bor_MOD44B_V5__VCFFplusVCF__2010__0.5deg__UHAM-ICDC.nc')
nc2na_west= netCDF4.Dataset(path+'NA_East_shift_Bor_MAR_cru_ts3.22.1998.2010.pre.dat.nc')
nc3na_west= netCDF4.Dataset(path+'NA_East_seasonal_soilw.mon.mean.1998-2010.v2.nc')
#nc3na_west= netCDF4.Dataset(path+'NA_shift_min_bor_yearmean_soilw.mon.mean.1998-2010.v2.nc')
nc4na_west= netCDF4.Dataset(path+'NA_East_shift_0_bor_M6H_0.5_tmin.2m.gauss.1998-2010.nc')
nc5na_west= netCDF4.Dataset(path+'NA_East_shift_bor_GLC2000_0.5.nc')
nc6na_west= netCDF4.Dataset(path+'NA_East_shift_0_bor_0.5_PZI.nc')
nc7na_west= netCDF4.Dataset(path+'NA_East_shift_masked_bor_0.5_Year_Fire_Frequency_1996-2012.nc')
# nc8na_west= netCDF4.Dataset(path+'NA_shift_bor_0.5_Burned_1996-2012_SUM.nc')
nc9na_west= netCDF4.Dataset(path+'NA_East_shift_Bor_ReBil_GloElev_05.nc')
nc10na_west= netCDF4.Dataset(path+'NA_East_Boreal_Mean_GDD0_1998-2010_0.5.nc')
nc11na_west= netCDF4.Dataset(path+'NA_East_Bor_Ease25_Northen_Emisphere_Mean_Thawing_Depth_1901-2002.nc')
nc12na_west= netCDF4.Dataset(path+'NA_East_soil_texture_0.5.nc')
nc13na_west= netCDF4.Dataset(path+'Terra_NA_East_MODIS_0.5_C6_GSSLAI_2000_2015_Decadal_Trend_SigOnly.nc')


# assign variables and coordinates

lon_ea_east = ncea_east.variables['lon']#.tolist()
lon_ea_west = ncea_west.variables['lon']
lat_ea_east = ncea_east.variables['lat']
lat_ea_west = ncea_west.variables['lat']
lon005ea_east = nc005ea_east.variables['lon']#.tolist()
lon005ea_west = nc005ea_west.variables['lon']
lat005ea_east = nc005ea_east.variables['lat']


vcff_ea_east = ncea_east.variables['vcff'][0]
vcff005_ea_east = nc005ea_east.variables['vcff'][0]
pcp_ea_east = nc2ea_east.variables['pre'][0]
sm_ea_east = nc3ea_east.variables['soilw'][1]
tm_ea_east = nc4ea_east.variables['tmin'][0]-273.15
mask_ea_east = ma.getmask(tm_ea_east)
glc_ea_east = ma.masked_array(nc5ea_east.variables['var'][:], mask_ea_east)
pzi_ea_east = nc6ea_east.variables['pzi'][:]
ff_ea_east = nc7ea_east.variables['firefreq'][:]
# ba_ea_east = nc8ea_east.variables['burnedarea_east'][:]
elev_ea_east = nc9ea_east.variables['elev'][:]
gdd0_ea_east = nc10ea_east.variables['gdd0'][0]
ptd_ea_east = nc11ea_east.variables['thw_depth'][0]
st_ea_east= ma.masked_array(nc12ea_east.variables['var600'], mask_ea_east)


vcff_ea_west = ncea_west.variables['vcff'][0]
vcff005_ea_west = nc005ea_west.variables['vcff'][0]
pcp_ea_west = nc2ea_west.variables['pre'][0]
sm_ea_west = nc3ea_west.variables['soilw'][1]
tm_ea_west = nc4ea_west.variables['tmin'][0]-273.15
mask_ea_west = ma.getmask(tm_ea_west)
glc_ea_west = ma.masked_array(nc5ea_west.variables['var'][:], mask_ea_west)
pzi_ea_west = nc6ea_west.variables['pzi'][:]
ff_ea_west = nc7ea_west.variables['firefreq'][:]
# ba_ea_west = nc8ea_west.variables['burnedarea'][:]
elev_ea_west = nc9ea_west.variables['elev'][:]
gdd0_ea_west = nc10ea_west.variables['gdd0'][0]
ptd_ea_west = nc11ea_west.variables['thw_depth'][0]
st_ea_west= ma.masked_array(nc12ea_west.variables['var600'], mask_ea_west)

lon_na_east= ncna_east.variables['lon']#.tolist()
lon_na_west= ncna_west.variables['lon']
lat_na_east = ncna_east.variables['lat']
lat_na_west = ncna_west.variables['lat']
lon005na_east= nc005na_east.variables['lon']#.tolist()
lon005na_west= nc005na_west.variables['lon']
lat005na_east= nc005na_east.variables['lat']


vcff_na_east= ncna_east.variables['vcff'][0]
vcff005_na_east= nc005na_east.variables['vcff'][0]
pcp_na_east= nc2na_east.variables['pre'][0]
sm_na_east= nc3na_east.variables['soilw'][1]
tm_na_east= nc4na_east.variables['tmin'][0]-273.15
mask_na_east = ma.getmask(tm_na_east)
glc_na_east= ma.masked_array(nc5na_east.variables['var'][:], mask_na_east)
pzi_na_east= nc6na_east.variables['pzi'][:]
ff_na_east= nc7na_east.variables['firefreq'][:]
# ba_na_east= nc8na_east.variables['burnedarea'][:]
elev_na_east= nc9na_east.variables['elev'][:]
gdd0_na_east= nc10na_east.variables['gdd0'][0]
ptd_na_east= nc11na_east.variables['thw_depth'][0]
lai_na_east= nc13na_east.variables['t_trend'][:]
st_na_east= ma.masked_array(nc12na_east.variables['var600'], mask_na_east)


vcff_na_west= ncna_west.variables['vcff'][0]
vcff005_na_west= nc005na_west.variables['vcff'][0]
pcp_na_west= nc2na_west.variables['pre'][0]
sm_na_west= nc3na_west.variables['soilw'][1]
tm_na_west= nc4na_west.variables['tmin'][0]-273.15
mask_na_west = ma.getmask(tm_na_west)
glc_na_west= ma.masked_array(nc5na_west.variables['var'][:], mask_na_west)
pzi_na_west= nc6na_west.variables['pzi'][:]
ff_na_west= nc7na_west.variables['firefreq'][:]
# ba_na_west= nc8na_west.variables['burnedarea'][:]
elev_na_west= nc9na_west.variables['elev'][:]
gdd0_na_west= nc10na_west.variables['gdd0'][0]
ptd_na_west= nc11na_west.variables['thw_depth'][0]
lai_na_west= nc13na_west.variables['t_trend'][:]
st_na_west= ma.masked_array(nc12na_west.variables['var600'], mask_na_west)

# create new variable of state accordind to the results of the optimisation
vcf_state_ea_east = np.empty(shape=vcff_ea_east.shape)
for i in range(vcff_ea_east.shape[0]):
    for j in range(vcff_ea_east.shape[1]):
        if vcff_ea_east[i][j]<0: 
            vcf_state_ea_east[i][j] = 0  # null
        elif vcff_ea_east[i][j]<10:
            vcf_state_ea_east[i][j] = 1  # bare, the first peak
        elif vcff_ea_east[i][j]<20:
            vcf_state_ea_east[i][j] = 1  # bare
        elif vcff_ea_east[i][j]<45:
            vcf_state_ea_east[i][j] = 3  # savanna, the third peak
        elif vcff_ea_east[i][j]<100:
            vcf_state_ea_east[i][j] = 4  # forest, the fourth peak
        else:
            vcf_state_ea_east[i][j] = 5  # null


            # create new variable of state accordind to the results of the optimisation
vcf_state_ea_west = np.empty(shape=vcff_ea_west.shape)
for i in range(vcff_ea_west.shape[0]):
    for j in range(vcff_ea_west.shape[1]):
        if vcff_ea_west[i][j]<0: 
            vcf_state_ea_west[i][j] = 0  # null
        elif vcff_ea_west[i][j]<10:
            vcf_state_ea_west[i][j] = 1  # bare, the first peak
        elif vcff_ea_west[i][j]<20:
            vcf_state_ea_west[i][j] = 1  # bare the second peak
        elif vcff_ea_west[i][j]<45:
            vcf_state_ea_west[i][j] = 3  # savanna, the third peak
        elif vcff_ea_west[i][j]<100:
            vcf_state_ea_west[i][j] = 4  # forest, the fourth peak
        else:
            vcf_state_ea_west[i][j] = 5  # null

            
vcf_state_na_east = np.empty(shape=vcff_na_east.shape)
for i in range(vcff_na_east.shape[0]):
    for j in range(vcff_na_east.shape[1]):
        if vcff_na_east[i][j]<0: 
            vcf_state_na_east[i][j] = 0  # null
        elif vcff_na_east[i][j]<10:
            vcf_state_na_east[i][j] = 1  # bare, the first peak
        elif vcff_na_east[i][j]<20:
            vcf_state_na_east[i][j] = 1  # sparse savanna, the second peak
        elif vcff_na_east[i][j]<45:
            vcf_state_na_east[i][j] = 3  # savanna, the third peak
        elif vcff_na_east[i][j]<100:
            vcf_state_na_east[i][j] = 4  # forest, the fourth peak
        else:
            vcf_state_na_east[i][j] = 5  # null
            
            
# create new variable of state accordind to the results of the optimisation
vcf_state_na_west = np.empty(shape=vcff_na_west.shape)
for i in range(vcff_na_west.shape[0]):
    for j in range(vcff_na_west.shape[1]):
        if vcff_na_west[i][j]<0: 
            vcf_state_na_west[i][j] = 0  # null
        elif vcff_na_west[i][j]<10:
            vcf_state_na_west[i][j] = 1  # bare, the first peak
        elif vcff_na_west[i][j]<20:
            vcf_state_na_west[i][j] = 1  # sparse savanna, the second peak
        elif vcff_na_west[i][j]<45:
            vcf_state_na_west[i][j] = 3  # savanna, the third peak
        elif vcff_na_west[i][j]<100:
            vcf_state_na_west[i][j] = 4  # forest, the fourth peak
        else:
            vcf_state_na_west[i][j] = 5  # null
            
vcf_state_na_east= ma.masked_array(vcf_state_na_east, mask_na_east)
vcf_state_na_west= ma.masked_array(vcf_state_na_west, mask_na_west)
vcf_state_ea_east= ma.masked_array(vcf_state_ea_east, mask_ea_east)
vcf_state_ea_west= ma.masked_array(vcf_state_ea_west, mask_ea_west)
        


# Let's plot all the variables

# In[35]:

# North Polar Azimuthal Equidistant Projection of Soil Texture
fig = plt.figure(figsize=(15,10))
#ax = fig.add_subplot(111,frameon=True)
fig.suptitle("North Polar Azimuthal Equidistant Projection of Soil Texture")
plot_north_polar(fig=fig, lon0=10,lon=lon_ea_west,lat=lat_ea_west,data=st_ea_west, clevs=np.arange(0,16,1), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_ea_east,lat=lat_ea_east,data=st_ea_east, clevs=np.arange(0,16,1), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_na_east,lat=lat_na_east,data=st_na_east, clevs=np.arange(0,16,1), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_na_west,lat=lat_na_west,data=st_na_west, clevs=np.arange(0,16,1), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=True)

# plt.savefig( '/Users/Beniamino/Documents/OneDrive/MPI-M/iPython_Notebooks/Pic/bor_vcf_'+str(picctr)+'.pdf',dpi=600, transparent=False)
plt.show()


# In[ ]:

# North Polar Azimuthal Equidistant Projection of VCFF
fig = plt.figure(figsize=(15,10))
#ax = fig.add_subplot(111,frameon=True)
fig.suptitle("North Polar Azimuthal Equidistant Projection of TCF")

plot_north_polar(fig=fig, lon0=10,lon=lon_ea_west,lat=lat_ea_west,data=vcff_ea_west, clevs=np.arange(0,90,15), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_ea_east,lat=lat_ea_east,data=vcff_ea_east, clevs=np.arange(0,90,15), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_na_east,lat=lat_na_east,data=vcff_na_east, clevs=np.arange(0,90,15), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_na_west,lat=lat_na_west,data=vcff_na_west, clevs=np.arange(0,90,15), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=True)

# plt.savefig( '/Users/Beniamino/Documents/OneDrive/MPI-M/iPython_Notebooks/Pic/bor_vcf_'+str(picctr)+'.pdf',dpi=600, transparent=False)
plt.show()


# In[ ]:

# North Polar Azimuthal Equidistant Projection of Fire Frequency from GFEDv4
fig = plt.figure(figsize=(12,12))
#ax = fig.add_subplot(111,frameon=True)
fig.suptitle("North Polar Azimuthal Equidistant Projection of Fire Frequency from GFEDv4")


plot_north_polar(fig=fig, lon0=10,lon=lon_ea_west,lat=lat_ea_west,data=ff_ea_west, clevs=np.arange(0,5,0.1), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_ea_east,lat=lat_ea_east,data=ff_ea_east, clevs=np.arange(0,5,0.1), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_na_east,lat=lat_na_east,data=ff_na_east, clevs=np.arange(0,5,0.1), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_na_west,lat=lat_na_west,data=ff_na_west, clevs=np.arange(0,5,0.1), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=True)

# plt.savefig( '/Users/Beniamino/Documents/OneDrive/MPI-M/iPython_Notebooks/Pic/bor_vcf_'+str(picctr)+'.pdf',dpi=600, transparent=False)
plt.show()


# In[ ]:

# North Polar Azimuthal Equidistant Projection of PTD
fig = plt.figure(figsize=(12,12))
#ax = fig.add_subplot(111,frameon=True)
fig.suptitle("North Polar Azimuthal Equidistant Projection of PTD")

plot_north_polar(fig=fig, lon0=10,lon=lon_ea_west,lat=lat_ea_west,data=ptd_ea_west, clevs=np.arange(0,5.5,0.5), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_ea_east,lat=lat_ea_east,data=ptd_ea_east, clevs=np.arange(0,5.5,0.5), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_na_east,lat=lat_na_east,data=ptd_na_east, clevs=np.arange(0,5.5,0.5), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_na_west,lat=lat_na_west,data=ptd_na_west, clevs=np.arange(0,5.5,0.5), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=True)

#plt.savefig( '/Users/Beniamino/Documents/OneDrive/MPI-M/iPython_Notebooks/Pic/Meeting_Victor/bor_ptd_05.pdf',dpi=600, transparent=False)
plt.show()


# In[ ]:

# North Polar Azimuthal Equidistant Projection of Mean Daily (6h) TMIN from NCEP_Reanalysis 1998-2010

fig = plt.figure(figsize=(12,12))
fig.suptitle("North Polar Azimuthal Equidistant Projection of Mean Daily (6h) TMIN from NCEP_Reanalysis 1998-2010")

plot_north_polar(fig=fig, lon0=10,lon=lon_ea_west,lat=lat_ea_west,data=tm_ea_west, clevs=np.arange(-36,18,6), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_ea_east,lat=lat_ea_east,data=tm_ea_east, clevs=np.arange(-36,18,6), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_na_east,lat=lat_na_east,data=tm_na_east, clevs=np.arange(-36,18,6), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_na_west,lat=lat_na_west,data=tm_na_west, clevs=np.arange(-36,18,6), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=True)

#plt.savefig( '/Users/Beniamino/Documents/OneDrive/MPI-M/iPython_Notebooks/Pic/Meeting_Victor/bor_ptd_05.pdf',dpi=600, transparent=False)
plt.show()


# In[6]:

# North Polar Azimuthal Equidistant Projection of MAR from CRU 1998-2010

fig = plt.figure(figsize=(12,12))
fig.suptitle("North Polar Azimuthal Equidistant Projection of MAR from CRU 1998-2010")

plot_north_polar(fig=fig, lon0=10,lon=lon_ea_west,lat=lat_ea_west,data=pcp_ea_west, clevs=np.arange(0,2000,100), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_ea_east,lat=lat_ea_east,data=pcp_ea_east, clevs=np.arange(0,2000,100), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_na_east,lat=lat_na_east,data=pcp_na_east, clevs=np.arange(0,2000,100), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_na_west,lat=lat_na_west,data=pcp_na_west, clevs=np.arange(0,2000,100), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=True)

#plt.savefig( '/Users/Beniamino/Documents/OneDrive/MPI-M/iPython_Notebooks/Pic/Meeting_Victor/bor_ptd_05.pdf',dpi=600, transparent=False)
plt.show()


# In[18]:

# North Polar Azimuthal Equidistant Projection of CPC Soil Moisture data provided by the NOAA/OAR/ESRL PSD
fig = plt.figure(figsize=(12,12))
fig.suptitle("North Polar Azimuthal Equidistant Projection of CPC Soil Moisture data provided by the NOAA/OAR/ESRL PSD")

plot_north_polar(fig=fig, lon0=10,lon=lon_ea_west,lat=lat_ea_west,data=sm_ea_west, clevs=np.arange(0,700,100), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_ea_east,lat=lat_ea_east,data=sm_ea_east, clevs=np.arange(0,700,100), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_na_east,lat=lat_na_east,data=sm_na_east, clevs=np.arange(0,700,100), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=True)
plot_north_polar(fig=fig, lon0=10,lon=lon_na_west,lat=lat_na_west,data=sm_na_west, clevs=np.arange(0,700,100), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)

#plt.savefig( '/Users/Beniamino/Documents/OneDrive/MPI-M/iPython_Notebooks/Pic/Meeting_Victor/bor_ptd_05.pdf',dpi=600, transparent=False)
plt.show()


# In[21]:

# North Polar Azimuthal Equidistant Projection of PZI (Permafrost Zonation Index)
fig = plt.figure(figsize=(12,12))
fig.suptitle("North Polar Azimuthal Equidistant Projection of PZI (Permafrost Zonation Index)")
plot_north_polar(fig=fig, lon0=10,lon=lon_ea_west,lat=lat_ea_west,data=pzi_ea_west, clevs=np.arange(0,1.05,0.05), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_ea_east,lat=lat_ea_east,data=pzi_ea_east, clevs=np.arange(0,1.05,0.05), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_na_east,lat=lat_na_east,data=pzi_na_east, clevs=np.arange(0,1.05,0.05), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=True)
plot_north_polar(fig=fig, lon0=10,lon=lon_na_west,lat=lat_na_west,data=pzi_na_west, clevs=np.arange(0,1.05,0.05), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)

#plt.savefig( '/Users/Beniamino/Documents/OneDrive/MPI-M/iPython_Notebooks/Pic/Meeting_Victor/bor_ptd_05.pdf',dpi=600, transparent=False)
plt.show()


# In[22]:

# North Polar Azimuthal Equidistant Projection of Growing Degree Days 0 from NCEP Reanalysis
fig = plt.figure(figsize=(12,12))
ax = fig.add_subplot(111)
ax.set_title("North Polar Azimuthal Equidistant Projection of GLC2000")
plot_north_polar(fig=fig, lon0=10,lon=lon_ea_west,lat=lat_ea_west,data=glc_ea_west, clevs=np.arange(0,22,1), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_ea_east,lat=lat_ea_east,data=glc_ea_east, clevs=np.arange(0,22,1), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_na_east,lat=lat_na_east,data=glc_na_east, clevs=np.arange(0,22,1), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=True)
plot_north_polar(fig=fig, lon0=10,lon=lon_na_west,lat=lat_na_west,data=glc_na_west, clevs=np.arange(0,22,1), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)

#plt.savefig( '/Users/Beniamino/Documents/OneDrive/MPI-M/iPython_Notebooks/Pic/Meeting_Victor/bor_ptd_05.pdf',dpi=600, transparent=False)
plt.show()


# In[25]:

# North Polar Azimuthal Equidistant Projection of Growing Degree Days 0 from NCEP Reanalysis
fig = plt.figure(figsize=(12,12))
ax = fig.add_subplot(111)
ax.set_title("North Polar Azimuthal Equidistant Projection of Growing Degree Days 0 from NCEP Reanalysis at 0.5 degrees")
plot_north_polar(fig=fig, lon0=10,lon=lon_ea_west,lat=lat_ea_west,data=gdd0_ea_west, clevs=np.arange(0,4250,250), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_ea_east,lat=lat_ea_east,data=gdd0_ea_east, clevs=np.arange(0,4250,250), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_na_east,lat=lat_na_east,data=gdd0_na_east, clevs=np.arange(0,4250,250), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=True)
plot_north_polar(fig=fig, lon0=10,lon=lon_na_west,lat=lat_na_west,data=gdd0_na_west, clevs=np.arange(0,4250,250), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)

#plt.savefig( '/Users/Beniamino/Documents/OneDrive/MPI-M/iPython_Notebooks/Pic/Meeting_Victor/bor_ptd_05.pdf',dpi=600, transparent=False)
plt.show()


# In[46]:

# North Polar Azimuthal Equidistant Projection of Vegetation State
fig = plt.figure(figsize=(12,12))
#ax = fig.add_subplot(111,frameon=True)
fig.suptitle("North Polar Azimuthal Equidistant Projection of Vegetation State")
plot_north_polar(fig=fig, lon0=10,lon=lon_ea_west,lat=lat_ea_west,data=vcf_state_ea_west, clevs=np.array([1,2,3,4]), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_ea_east,lat=lat_ea_east,data=vcf_state_ea_east, clevs=np.array([1,2,3,4]), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_na_east,lat=lat_na_east,data=vcf_state_na_east, clevs=np.array([1,2,3,4]), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=True)
plot_north_polar(fig=fig, lon0=10,lon=lon_na_west,lat=lat_na_west,data=vcf_state_na_west, clevs=np.array([1,2,3,4]), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)

#plt.savefig( '/Users/Beniamino/Documents/OneDrive/MPI-M/iPython_Notebooks/Pic/Meeting_Victor/bor_ptd_05.pdf',dpi=600, transparent=False)
plt.show()


# In[55]:

# Subplots with all
fig = plt.figure(figsize=(18,14))

ax = fig.add_subplot(341)
ax.set_title('TCFF')
plot_north_polar(fig=fig, lon0=10,lon=lon_ea_west,lat=lat_ea_west,data=vcff_ea_west, clevs=np.arange(0,90,15), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_ea_east,lat=lat_ea_east,data=vcff_ea_east, clevs=np.arange(0,90,15), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_na_east,lat=lat_na_east,data=vcff_na_east, clevs=np.arange(0,90,15), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_na_west,lat=lat_na_west,data=vcff_na_west, clevs=np.arange(0,90,15), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=True)



ax2 = fig.add_subplot(342)
ax2.set_title('MAR')
plot_north_polar(fig=fig, lon0=10,lon=lon_ea_west,lat=lat_ea_west,data=pcp_ea_west, clevs=np.arange(0,2000,100), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_ea_east,lat=lat_ea_east,data=pcp_ea_east, clevs=np.arange(0,2000,100), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_na_east,lat=lat_na_east,data=pcp_na_east, clevs=np.arange(0,2000,100), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_na_west,lat=lat_na_west,data=pcp_na_west, clevs=np.arange(0,2000,100), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=True)



ax3 = fig.add_subplot(343)
ax3.set_title('MSSM')
plot_north_polar(fig=fig, lon0=10,lon=lon_ea_west,lat=lat_ea_west,data=sm_ea_west, clevs=np.arange(0,700,100), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_ea_east,lat=lat_ea_east,data=sm_ea_east, clevs=np.arange(0,700,100), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_na_east,lat=lat_na_east,data=sm_na_east, clevs=np.arange(0,700,100), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=True)
plot_north_polar(fig=fig, lon0=10,lon=lon_na_west,lat=lat_na_west,data=sm_na_west, clevs=np.arange(0,700,100), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)



ax4 = fig.add_subplot(344)
ax4.set_title('MTmin')
plot_north_polar(fig=fig, lon0=10,lon=lon_ea_west,lat=lat_ea_west,data=tm_ea_west, clevs=np.arange(-36,18,6), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_ea_east,lat=lat_ea_east,data=tm_ea_east, clevs=np.arange(-36,18,6), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_na_east,lat=lat_na_east,data=tm_na_east, clevs=np.arange(-36,18,6), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_na_west,lat=lat_na_west,data=tm_na_west, clevs=np.arange(-36,18,6), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=True)



ax5 = fig.add_subplot(345)
ax5.set_title('FF')
plot_north_polar(fig=fig, lon0=10,lon=lon_ea_west,lat=lat_ea_west,data=ff_ea_west, clevs=np.arange(0,5,0.1), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_ea_east,lat=lat_ea_east,data=ff_ea_east, clevs=np.arange(0,5,0.1), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_na_east,lat=lat_na_east,data=ff_na_east, clevs=np.arange(0,5,0.1), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_na_west,lat=lat_na_west,data=ff_na_west, clevs=np.arange(0,5,0.1), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=True)



ax6 = fig.add_subplot(346)
ax6.set_title('PZI')
plot_north_polar(fig=fig, lon0=10,lon=lon_ea_west,lat=lat_ea_west,data=pzi_ea_west, clevs=np.arange(0,1.05,0.05), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_ea_east,lat=lat_ea_east,data=pzi_ea_east, clevs=np.arange(0,1.05,0.05), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_na_east,lat=lat_na_east,data=pzi_na_east, clevs=np.arange(0,1.05,0.05), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=True)
plot_north_polar(fig=fig, lon0=10,lon=lon_na_west,lat=lat_na_west,data=pzi_na_west, clevs=np.arange(0,1.05,0.05), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)

ax7 = fig.add_subplot(347)
ax7.set_title('State')
plot_north_polar(fig=fig, lon0=10,lon=lon_ea_west,lat=lat_ea_west,data=vcf_state_ea_west, clevs=np.array([1,2,3,4]), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_ea_east,lat=lat_ea_east,data=vcf_state_ea_east, clevs=np.array([1,2,3,4]), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_na_east,lat=lat_na_east,data=vcf_state_na_east, clevs=np.array([1,2,3,4]), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=True)
plot_north_polar(fig=fig, lon0=10,lon=lon_na_west,lat=lat_na_west,data=vcf_state_na_west, clevs=np.array([1,2,3,4]), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)

ax8 = fig.add_subplot(348)
ax8.set_title('GDD0')
plot_north_polar(fig=fig, lon0=10,lon=lon_ea_west,lat=lat_ea_west,data=gdd0_ea_west, clevs=np.arange(0,4250,250), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_ea_east,lat=lat_ea_east,data=gdd0_ea_east, clevs=np.arange(0,4250,250), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_na_east,lat=lat_na_east,data=gdd0_na_east, clevs=np.arange(0,4250,250), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=True)
plot_north_polar(fig=fig, lon0=10,lon=lon_na_west,lat=lat_na_west,data=gdd0_na_west, clevs=np.arange(0,4250,250), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)

ax9 = fig.add_subplot(3,4,9)
ax9.set_title('ST')
plot_north_polar(fig=fig, lon0=10,lon=lon_ea_west,lat=lat_ea_west,data=st_ea_west, clevs=np.arange(0,16,1), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_ea_east,lat=lat_ea_east,data=st_ea_east, clevs=np.arange(0,16,1), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_na_east,lat=lat_na_east,data=st_na_east, clevs=np.arange(0,16,1), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_na_west,lat=lat_na_west,data=st_na_west, clevs=np.arange(0,16,1), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=True)

ax10 = fig.add_subplot(3,4,10)
ax10.set_title('PTD')
plot_north_polar(fig=fig, lon0=10,lon=lon_ea_west,lat=lat_ea_west,data=ptd_ea_west, clevs=np.arange(0,5.5,0.5), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_ea_east,lat=lat_ea_east,data=ptd_ea_east, clevs=np.arange(0,5.5,0.5), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_na_east,lat=lat_na_east,data=ptd_na_east, clevs=np.arange(0,5.5,0.5), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_na_west,lat=lat_na_west,data=ptd_na_west, clevs=np.arange(0,5.5,0.5), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=True)

ax11 = fig.add_subplot(3,4,11)
ax11.set_title('GLC')
plot_north_polar(fig=fig, lon0=10,lon=lon_ea_west,lat=lat_ea_west,data=glc_ea_west, clevs=np.arange(0,22,1), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_ea_east,lat=lat_ea_east,data=glc_ea_east, clevs=np.arange(0,22,1), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)
plot_north_polar(fig=fig, lon0=10,lon=lon_na_east,lat=lat_na_east,data=glc_na_east, clevs=np.arange(0,22,1), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=True)
plot_north_polar(fig=fig, lon0=10,lon=lon_na_west,lat=lat_na_west,data=glc_na_west, clevs=np.arange(0,22,1), cmap='viridis', par = np.arange(-90.,91.,30.), mer = np.arange(-180.,181.,30.),cbar=False)

#plt.savefig( '/Users/Beniamino/Documents/OneDrive/MPI-M/iPython_Notebooks/Pic/ea+na_bor_complete_'+str(picctr)+'.pdf',dpi=600, transparent=False)

plt.show()


# In[ ]:



