# EXAMPLE:
# get working path
script.dir <- dirname(sys.frame(1)$ofile)

# load ramanFit script
source(paste(script.dir,"/","ramanFit.R",sep=""))

# load the data
data = read.table(paste(script.dir,"/","example_spectrum.csv",sep=""),header=TRUE,sep=',')

# run the analysis
fits = ramanFit(data$wavenumber,data$intensity)

# name the outputs
FWHM = fits[1] # should be 3.506543
peak = fits[2] # should be 56.45596 
position = fits[3] # should be 1087.545 
background = fits[4] # should be 650.4095
thisFit_v1 = fits[5]

# plot the data and the fit:
plot(data,xlim=c(1080,1100))
wn = seq(1080,1100,0.1)
fit = coef(thisFit_v1[[1]])[1] + coef(thisFit_v1[[1]])[5]*wn + coef(thisFit_v1[[1]])[2] * exp(-((wn-coef(thisFit_v1[[1]])[3]))^2/(coef(thisFit_v1[[1]])[4]))
lines(wn,fit)
