%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Script to determine likeliest turnover time with a single 14C data-point%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% 1- pool %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Script by utsav mannu and tessa van der voort
% prerequisites: 1. Matlab Licence
% 2. 2-point 14C time-series data 
% 3. matrix with year & atmospheric Fm values (Hua2013). Should be updated
% depending on recent atmospheric values. File is provided
% We follow standard equations such as explained in Torn et al., 2009.


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Variable input %%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear
%close all
load UDnew.mat
% Change the following four things for your run:
% 1. sampling year of time-point 1
% 2. Time-point 1 D14C signature

% 1. Time-point: include starting year of time-series
% 1996 =2 1997 = 3 1998 = 4 %% change accordingly
st_yr=1;%starting year

% 2. Time-point 1 D14C signature
D14C_single_time_point = -344.755452125994;

%%%%%other parameters
Fatm=UDnew(:,2);% select atmospheric signature second column matrix
Fac(st_yr)=1;%concentration in the starting year
lamda = 1.210*10^-4;
step=1:0.1:10000; %range of turnover time and step size
erR=Inf;
KM=1./step;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%Now we start with the optimization loop!%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% 1- pool %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

counter=1;
for K=KM
    K;
    for i=(st_yr):12014 % insert year gap here
        Fac(i+1)=K*Fatm(i+1)+Fac(i)*(1-K-lamda);
    end
    er(counter)=abs(Fac(12014)-((D14C_single_time_point/1000)+1)); %insert 2014 value here %% insert year+1
    counter=counter+1;
end
index=find(er==(min(er)));
output=step(index);
K=1/output;
 for i=(st_yr):12014 % insert year gap here
        Fac(i+1)=K*Fatm(i+1)+Fac(i)*(1-K-lamda);
 end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% Results %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% 1- pool %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
dxx=['The turovertime is is ::',num2str(output),'years'];
RE_lowest=['The lowest error is:',num2str(min(er)),' R']; % lowest error for this turnover
disp(dxx);
disp(RE_lowest);

hold on
plot(11950:12014,Fac(11950:12014),'-or');
