%%%%%%%%%%%%%%%%%%%%%%%Radiocarbon_modelling_time_series_commented%%%%%%%%%
%%% Script to determine likeliest turnover time with two 14C data-points%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% 1- pool %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Script by utsav mannu and tessa van der voort
% prerequisites: 
%1. Matlab Licence
% 2. 2-point 14C time-series data 
% 3. matrix with year & atmospheric Fm values. Should be updated
% depending on recent atmospheric values. File is provided
% We follow standard equations such as explained in Torn et al., 2009.

% How to run the model: 
% 1. load this script and the UDnew in a folder
% 2. do not change the name of the script of mat file
% 3. Fill in your data in the script. These are the following 4 datapoints: 
% 3a. D14C_time_point_1
% 3b. D14C_time_point_2
% 3c. sampling year of time-point 1
% 3d. sampling year of time-point 2
% 4. fill in the data & run the script
% Results will be produced as output and figures will be automatically
% generated
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%% Standard variable input %%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% 1- pool %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%clear any previous logged materials
clear
% load file with atmospheric Fm 14C signature
load UDnew.mat %UD new can be adjusted for potential vegetation-induced lag.
%%%%%other parameters
lamda = 1.210*10^-4; % decay rate 14C
% range turnover times possible and step-size
% step size is 1 year to save computation, but reduce if deadling with ad
% dynamic pool 
start_time = 10000;
step=1:1:start_time; %range of turnover time from 1 year to 10.000 years, steps of 1
KM=1./step; % k is inverse turnover time, so decay rate

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%% Variable input by user %%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% 1- pool %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Change the following four things for your run:
% 1. Time-point 1 
% 2. Time-point 2 
% 3. sampling year of time-point 1 % this is the input value for the
% function
% 4. sampling year of time-point 2

% 1. Fill in the D14C signature of time-point 1
D14C_time_point_1 = -17.61;
% 2. fill in D14C signature of time-point 2
D14C_time_point_2 = -17.15;
% 3. sampling year of time-point 1
st_yr=1; %starting year  counting from 1995, so e.g. 1996 = 2 %
% 4. sampling year of time-point 2
end_yr = 2014;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%Now we start with the optimization loop!%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% 1- pool %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
end_yr = end_yr+start_time;
%yr_1=1995; %change for sampling year
yr_1=1995+start_time;

UDnew(1:10000,:)=[];
sd=UDnew(1:2014,2);
UDnew(1:end_yr,1)=1:end_yr;
UDnew(1:start_time,2)=1;
UDnew(start_time+1:end_yr,2)=sd;

Fatm=UDnew(:,2);% slect atmospheric signature second column matrix
Fac(st_yr)=1; %concentration in the starting year, assumed to be 1
counter=1;
for K=KM
    K;
    for i=(st_yr):(end_yr-1) % insert year gap here
        Fac(i+1)=K*Fatm(i+1 )+Fac(i)*(1-K-lamda);
    end
    er1(counter)=abs(Fac(end_yr)-((D14C_time_point_2/1000)+1));
    er2(counter)=abs(Fac(yr_1)-((D14C_time_point_1/1000)+1)); %insert 2014 value here %% insert year+1
    counter=counter+1;
end
er=sqrt((er1).^2+(er2).^2); 
[val1,index1]=min(er1); % error of data point 1
[val2,index2]=min(er2);% error of data point 2
[val,index]=min(er); % take mean square error booth values


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%% Translate optimisation to output %%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% 1- pool %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Visualize output
output=step(index); 
K=1/output;
 for i=(st_yr):end_yr-1 % insert year gap here
        Fac(i+1)=K*Fatm(i+1)+Fac(i)*(1-K-lamda);
 end

% give turnover times
dxx1=['The turovertime(data1) is ::',num2str(step(index1)),'years'];
dxx2=['The turovertime(data2) is ::',num2str(step(index2)),'years'];
dxx=['The turovertime is ::',num2str(step(index)),'years'];


disp(dxx1);
disp(dxx2);
disp(dxx);

% plot optimsation and bomb-peak 14C incorporation
% adapt plot to personal preference. year A.D. +10.000 --> year
% input
hold on
plot(end_yr-50:end_yr,Fac(end_yr-50:end_yr),'-or'); hold on %1000 was 11950
plot(Fatm); hold on
plot(yr_1, ((D14C_time_point_1/1000)+1), '*'); hold on
plot(end_yr, ((D14C_time_point_2/1000)+1), '*');
figure
plot(step,er1,'r');hold on;
plot(step,er2,'g');
plot(step,er,'k');
