module biozoo
  ! ----------------------------------------------------------------------------
  ! A module containing the zooplankton dynamics 
  !
  ! The process rates are collected on the zoorates tape and return to the 
  ! biomod
  !
  ! output: zrates
  ! 
  ! Author: Lars Jonasson
  !-----------------------------------------------------------------------------
  implicit none
  private

  type zoorates
    real(8) :: mezgrazdia 
    real(8) :: mezgrazflag
    real(8) :: mezgrazcyano
    real(8) :: mezgrazmiz
    real(8) :: mizgrazdia 
    real(8) :: mizgrazflag
    real(8) :: mizgrazcyano
    REAL(8) :: ldmez
    REAL(8) :: ldmiz
    REAL(8) :: lnmez
    REAL(8) :: lnmiz
  end type zoorates
  public :: zoorates
  
  ! public routines
  public :: zoodynamics  

 ! FIXME NEUMANND: create real template

contains

!===============================================================================

  subroutine zoodynamics(temp,dia,flag,cyano,mez,miz, hypoxia, zrate)
    !---------------------------------------------------------------------------
    ! A routine for calculating the zooplankton rates
    ! The zoodynamics are based on DMU-ergom
    !
    ! Author: Lars Jonasson, DMI
    !---------------------------------------------------------------------------

    !- Modules 
    !~ use bioparam,  only : miztk, mizgraz,mizgrazf,mezgraz, mezgrazf,           &
                          !~ mezprefmiz,                                          &
                          !~ mezcl, ldmez, lnmez,ldmiz, lnmiz,                    &
                          !~ sigma_b,                                             &
                          !~ mizprefdia, mizprefflag, mizprefcyano,               &
                          !~ mezprefdia, mezprefflag, mezprefcyano,               &
                          !~ mez_tscale, meztk
    !~ use constants, only : zero, half, one, ten

    !- Directives
    implicit none

    !- Arguments
    logical, intent(in)         :: hypoxia
    real(8), intent(in)         :: temp, mez, miz, dia, flag, cyano
    type(zoorates), intent(out) :: zrate

    ! Locals
    !~ real(8) :: tldmez, tldmiz, mezgt, mezgscal, foodmiz, foodmiz2, foodmez
    !~ real(8) :: foodmez2, mizgrazf2, mezgrazf2, mizgt,mizgscal, tlnmiz, tlnmez
    !~ real(8) :: meztotgraz, miztotgraz
    !~ real(8) :: temp2

    ! Initialize zrates to zero
    !~ zrate%mezgrazdia  = zero
    !~ zrate%mezgrazflag = zero
    !~ zrate%mezgrazcyano= zero
    !~ zrate%mezgrazmiz  = zero
    !~ zrate%mizgrazdia  = zero
    !~ zrate%mizgrazflag = zero
    !~ zrate%mizgrazcyano= zero
    !~ zrate%lnmez       = zero
    !~ zrate%lnmiz       = zero
    !~ zrate%ldmez       = ten*sigma_b*mez
    !~ zrate%ldmiz       = ten*sigma_b*miz
    
 
    !~ if (hypoxia) then
      !~ ! No respiration or grazing so these are kept zero from above
      !~ return
    !~ endif


    ! Grazing temperature dependece
    !~ mezgt = half + mez_tscale*temp2/(meztk+temp2)
    !~ mizgt = one  + temp2/(miztk+temp2)     

    ! food dependent grazing
    ! these have been divided by food
    ! mezfgrazf2 low compared to paper
    !~ mezgscal = mezgraz*foodmez/(foodmez*foodmez+mezgrazf*mezgrazf)
    !~ mizgscal = mizgraz*foodmiz/(foodmiz*foodmiz+mizgrazf*mizgrazf)

    ! total grazing
    !~ meztotgraz = mezgscal*mezgt
    !~ miztotgraz = mizgscal*mizgt

    ! grazing rates
    !~ zrate%mezgrazdia  = mezprefdia  *meztotgraz*mez
    !~ zrate%mezgrazflag = mezprefflag *meztotgraz*mez
    !~ zrate%mezgrazcyano= mezprefcyano*meztotgraz*mez
    !~ zrate%mezgrazmiz  = mezprefmiz  *meztotgraz*mez

    !~ zrate%mizgrazdia  = mizprefdia  *miztotgraz*miz
    !~ zrate%mizgrazflag = mizprefflag *miztotgraz*miz
    !~ zrate%mizgrazcyano= mizprefcyano*miztotgraz*miz

    ! zoo plankton loss rates (mortality)
    !~ tldmez = ldmez*mez + mezcl*mez*mez
    !~ tldmiz = ldmiz*miz
    !~ zrate%ldmez = tldmez
    !~ zrate%ldmiz = tldmiz

    ! zoo plankton loss rates (Basal- and active respiration for oxygen;
    ! excretion for nutrients)
    !~ tlnmez = lnmez*meztotgraz*foodmez*mez
    !~ tlnmiz = lnmiz*miztotgraz*foodmiz*miz
    !~ zrate%lnmez = tlnmez
    !~ zrate%lnmiz = tlnmiz
    
  end subroutine zoodynamics


end module biozoo
