# Overview

* ERGOM code and documentation
* supplement figures
* table data of the manuscript
* annual average model output
* station model output  

# ERGOM code and documentation

The ERGOM code is located in `code_partB` and the ERGOM documentation is located in `pdfs_partB`.

Four sources of nitrogen were tagged in two simulations for this study (each two sources in one simulation): total atmospheric nitrogen deposition and agriculturally-related atmospheric nitrogen deposition in one simulation **and** shippined-related nitrogen deposition and riverine nitrogen loads. Therefore, the code and the documentation exists twice and contain each two tagged source. However, we did not evaluate riverine nitrogen loads in this publication. Because we wanted to attach the original model code (and not a modified version), the two code and documentation versions with each two tagged sources are included here.


# supplement figures

There are no supplementary figures provided.


# table data of the manuscript

The data shown in Table~3 are provided as `csv` file in `data_partB/rel_contrib_tagged_sources/`.


# annual average model output

Annual average nitrogen deposition and biogeochemical tracer concentrations at sea surface (also tagged components) are provided in this supplement as NetCDF files in the listed folders:

* nitrogen deposition: `data_partB/atmos_dep`
* tracer concentrations: `data_partB/biogeo_conc/cmaq16_i5`, with `5` defining data of the fifth model iteration


# station model output

Vertically resolved time series at locations of six measurement stations are provided in this supplement as NetCDF files in the folder `data_partB/station_data`. The total tracer concentrations, tracer concentrations _with nitrogen from atmospheric deposition_, tracer concentrations _with nitrogen from atmospheric deposition of shipping emissions_, and tracer concentrations _with nitrogen from atmospheric deposition of agricultural emissions_ are provided in different folders (`total`, `atmos`, `ship`, and `agri`, resp.).


