function Iv = latlondepth_interp(Glat,Glon,Gz,Gv,Ilat,Ilon,Iz,proj_zone)
% Yann Marcon, April 2019
%LATLONDEPTH_INTERP interpolates values for a set of 3D points using a
%triangulation-based linear interpolation. All input points must be in
%geographic coordinates (lat/lon/depth). 

    % Remove points for which the value is NaN
    sel = logical(~isnan(Glat) .* ~isnan(Glon) .* ~isnan(Gz) .* ~isnan(Gv));
    Glat = Glat(sel);
    Glon = Glon(sel);
    Gz = Gz(sel);
    Gv = Gv(sel);
    
    % Convert datasets to UTM coordinates
    if exist('proj_zone','var')~=1 || isempty(proj_zone)
        [Ix,Iy,proj_zone] = latlon2xy([Ilat, Ilon]);
    else
        [Ix,Iy] = latlon2xy([Ilat, Ilon],proj_zone);
    end
    [Gx,Gy] = latlon2xy([Glat, Glon],proj_zone); % UTM grid with non-regular grid
    
    F = scatteredInterpolant([Gx,Gy,Gz],Gv,'linear','nearest');
    Iv = F(Ix,Iy,Iz);

end



function [x,y,proj_zone] = latlon2xy(latlon,proj_zone)
%% Large-Area Photo-Mosaicking (LAPM) Toolbox
% Yann Marcon, August 2013
% email: ymarcon@marum.de

    if nargin < 2
        lat0 = mean(latlon(:,1));
        lon0 = mean(latlon(:,2));
        proj_zone = utmzone(lat0,lon0);
    end
    
    projstruct = defaultm('utm');
    projstruct.zone = proj_zone;
    projstruct.geoid = almanac('earth','wgs84','meters');
    projstruct = defaultm(projstruct);
    [x,y] = mfwdtran(projstruct,latlon(:,1),latlon(:,2));

end
